/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard;

import com.anf.cryptotoken.auth.PasswordContainer;
import com.anf.cryptotoken.auth.PasswordContainerFactory;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ui.keyboard.KeyBoardLang;
import com.anf.cryptotoken.ui.keyboard.KeyBoardTextConfig;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;

public class KeyBoardConfig {
    private static final Logger log = Logger.getLogger(KeyBoardConfig.class);
    private boolean confirm;
    private PasswordContainer pass1;
    private PasswordContainer pass2;
    private PasswordContainer current;
    private boolean confirming = false;
    private boolean validate = true;
    private KeyBoardLang lang;
    private KeyBoardTextConfig textConf;
    private boolean showCenterPanel = true;
    private String title;
    private X509Certificate[] certificates;
    private Consumer<Void> resetPasswordEventHandler;

    public KeyBoardConfig(KeyBoardLang lang, KeyBoardTextConfig textConf, PasswordContainer pass1) {
        this.pass1 = pass1;
        this.current = pass1;
        this.lang = lang;
        this.textConf = textConf;
    }

    public KeyBoardConfig(KeyBoardLang lang, KeyBoardTextConfig textConf, PasswordContainer pass1, PasswordContainer pass2) {
        this(lang, textConf, pass1);
        this.pass2 = pass2;
        this.current = pass1;
        this.confirm = true;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
        if (this.pass2 == null) {
            this.pass2 = PasswordContainerFactory.getContainer();
        }
    }

    public PasswordContainer getPass1() {
        return this.pass1;
    }

    public void setPass1(PasswordContainer pass1) {
        this.pass1 = pass1;
    }

    public PasswordContainer getPass2() {
        return this.pass2;
    }

    public void setPass2(PasswordContainer pass2) {
        this.pass2 = pass2;
    }

    public PasswordContainer getCurrent() {
        return this.current;
    }

    public PasswordContainer confirmContainer() {
        if (this.confirm) {
            this.confirming = true;
            this.current = this.pass2;
            return this.current;
        }
        return null;
    }

    public PasswordContainer firstContainer() {
        this.confirming = false;
        this.current = this.pass1;
        return this.current;
    }

    public boolean isConfirming() {
        return this.confirming;
    }

    public boolean checkPassword() {
        if (this.confirm) {
            boolean equals = this.pass1.getPassword().equals(this.pass2.getPassword());
            log.info((Object)("keyboard config checkPassword equals " + equals));
            return equals;
        }
        return true;
    }

    public String getString(String id, Object ... args) {
        return this.lang.getString(id, args);
    }

    public KeyBoardTextConfig getTextConf() {
        return this.textConf;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setShowCenterPanel(boolean showCenterPanel) {
        this.showCenterPanel = showCenterPanel;
    }

    public boolean isShowCenterPanel() {
        return this.showCenterPanel;
    }

    public void clearPassword() {
        this.pass1.reset();
        if (this.confirm && this.pass2 != null) {
            this.pass2.reset();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCertificates(X509Certificate[] chain) {
        this.certificates = chain;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public KeyBoardLang getLang() {
        return this.lang;
    }

    public void setResetPasswordEventHandler(Consumer<Void> resetPasswordEventHandler) {
        this.resetPasswordEventHandler = resetPasswordEventHandler;
    }

    public Consumer<Void> getResetPasswordEventHandler() {
        return this.resetPasswordEventHandler;
    }

    public void reset() {
        if (this.pass1 != null) {
            this.pass1.reset();
        }
        if (this.pass2 != null) {
            this.pass2.reset();
        }
    }

    public void clear() {
        this.reset();
        this.clearPassword();
        this.setCertificates(null);
        this.setConfirm(false);
        this.setShowCenterPanel(false);
        this.setTitle("");
        this.setValidate(false);
    }
}

