/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard;

import com.anf.cryptotoken.auth.PasswordContainer;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.dto.LoginParams;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.ui.keyboard.KeyBoardConfig;
import com.anf.cryptotoken.ui.keyboard.KeyBoardLangImpl;
import com.anf.cryptotoken.ui.keyboard.KeyBoardTextConfig;
import com.anf.cryptotoken.ui.keyboard.StageHandler;
import com.anf.cryptotoken.ui.keyboard.behaviour.KeyBoardBehaviour;
import com.anf.cryptotoken.ui.keyboard.behaviour.impl.PasswordCounterBehaviour;
import com.anf.cryptotoken.ui.keyboard.exception.KeyBoardError;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.stage.Stage;

public class KeyBoard {
    private static final Logger log = Logger.getLogger(KeyBoard.class);
    private static StageHandler stageHandler;

    public static StageHandler getStageHandler() {
        if (stageHandler == null) {
            try {
                stageHandler = new StageHandler();
            }
            catch (IOException e) {
                throw new KeyBoardError(e);
            }
        }
        return stageHandler;
    }

    public static void setPrimaryStage(Stage primaryStage) {
        KeyBoard.getStageHandler().setPrimaryStage(primaryStage);
    }

    public <LOGINRESULT> LoginResult<LOGINRESULT> showPUKKeyBoard(PasswordContainer pass, LoginParams loginParams, KeyBoardBehaviour<LOGINRESULT> boardBehaviour) {
        log.info((Object)("showPUKKeyBoard " + loginParams.getTitle()));
        KeyBoardLangImpl lang = new KeyBoardLangImpl();
        KeyBoardConfig conf = new KeyBoardConfig(lang, KeyBoardTextConfig.createPUKConfig(lang), pass);
        conf.setShowCenterPanel(false);
        conf.setConfirm(loginParams.isDoublePin());
        conf.setTitle(loginParams.getTitle());
        conf.setValidate(loginParams.isDoublePin());
        return KeyBoard.getStageHandler().show(conf, boardBehaviour);
    }

    public <LOGINRESULT> LoginResult<LOGINRESULT> showPINKeyBoard(PasswordContainer pass, LoginParams loginParams, KeyBoardBehaviour<LOGINRESULT> boardBehaviour) {
        log.info((Object)("showPINKeyBoard " + loginParams.getTitle()));
        KeyBoardLangImpl lang = new KeyBoardLangImpl();
        KeyBoardConfig conf = new KeyBoardConfig(lang, KeyBoardTextConfig.createPINConfig(lang), pass);
        conf.setShowCenterPanel(false);
        conf.setConfirm(loginParams.isDoublePin());
        conf.setTitle(loginParams.getTitle());
        conf.setValidate(loginParams.isDoublePin());
        return KeyBoard.getStageHandler().show(conf, boardBehaviour);
    }

    public LoginResult<String> showBasicKeyBoard(PasswordContainer pass, String title, KeyBoardTextConfig textConf) {
        log.info((Object)("showBasicKeyBoard " + title));
        KeyBoardLangImpl lang = new KeyBoardLangImpl();
        KeyBoardConfig conf = new KeyBoardConfig(lang, textConf, pass);
        conf.setShowCenterPanel(false);
        conf.setConfirm(false);
        conf.setTitle(title);
        conf.setValidate(false);
        return KeyBoard.getStageHandler().show(conf, new PasswordCounterBehaviour(login -> new LoginResult<String>(new String(login.getPin())), null, 1, 0, title));
    }

    public LoginResult<String> showSleepKeyBoard(PasswordContainer pass, String title, KeyBoardTextConfig textConf, TimeUnit unit, int time) {
        log.info((Object)("showSleepKeyBoard " + title));
        KeyBoardLangImpl lang = new KeyBoardLangImpl();
        KeyBoardConfig conf = new KeyBoardConfig(lang, textConf, pass);
        conf.setShowCenterPanel(false);
        conf.setConfirm(false);
        conf.setTitle(title);
        conf.setValidate(false);
        return KeyBoard.getStageHandler().show(conf, new PasswordCounterBehaviour(login -> {
            try {
                unit.sleep(time);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            return new LoginResult<String>(new String(login.getPin()));
        }, null, 1, 0, title));
    }

    public LoginResult<Boolean> showSMSKeyBoard(PasswordContainer pass, String title, Consumer<Void> resetPasswordEventHandler, KeyBoardBehaviour<Boolean> boardBehaviour) {
        log.info((Object)("showSMSKeyBoard " + title));
        KeyBoardLangImpl lang = new KeyBoardLangImpl();
        KeyBoardConfig conf = new KeyBoardConfig(lang, KeyBoardTextConfig.createSMSConfig(lang), pass);
        conf.setShowCenterPanel(false);
        conf.setConfirm(false);
        conf.setTitle(title);
        conf.setValidate(false);
        conf.setResetPasswordEventHandler(resetPasswordEventHandler);
        return KeyBoard.getStageHandler().show(conf, boardBehaviour);
    }

    public <LOGINRESULT> LoginResult<LOGINRESULT> showCertKeyBoard(PasswordContainer pass, LoginParams loginParams, KeyBoardBehaviour<LOGINRESULT> boardBehaviour) {
        log.info((Object)("showCertKeyBoard " + loginParams.getTitle()));
        KeyBoardLangImpl lang = new KeyBoardLangImpl();
        KeyBoardTextConfig pinConf = loginParams.isPuk() ? KeyBoardTextConfig.createPUKConfig(lang) : KeyBoardTextConfig.createPINConfig(lang);
        KeyBoardConfig conf = new KeyBoardConfig(lang, pinConf, pass);
        conf.setShowCenterPanel(true);
        conf.setCertificates(loginParams.getChain());
        conf.setConfirm(loginParams.isDoublePin());
        conf.setTitle(loginParams.getTitle());
        conf.setValidate(loginParams.isDoublePin());
        return KeyBoard.getStageHandler().show(conf, boardBehaviour);
    }
}

