/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tsl;

import com.anf.cert.utils.CertType;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.clients.TSLValidationCertClient;
import com.anf.cryptotoken.json.QualifierInfo;
import com.anf.cryptotoken.json.ServiceStatus;
import com.anf.cryptotoken.json.TSLCertificateValidation;
import com.anf.cryptotoken.oid.QcStatementsUtils;
import com.anf.cryptotoken.qc.QcStatementsOID;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;

public class TSLController {
    private TSLValidationCertClient validationClient;

    public TSLController() {
        this(System.getProperty("tsl.service.url", "https://validaciones.anf.es"), 60000);
    }

    public TSLController(String url, int timeout) {
        this.validationClient = new TSLValidationCertClient(url, timeout);
    }

    public TSLCertificateValidation validateSignCertificateChain(X509Certificate[] chain) throws Exception {
        return this.validationClient.validateSignCertificateChain(chain);
    }

    public String generateTSLPassword() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            sb.append((char)(97 + (789 - 26 * i) / 2 * (i * 98 / 3) % 26));
        }
        return sb.toString();
    }

    public boolean isQualified(TSLCertificateValidation result, X509Certificate[] chain, CertType type) throws CertificateEncodingException, IOException {
        boolean qualified = false;
        if (result.getCurrentServiceStatus() != null && result.getCurrentServiceStatus().getStatus().endsWith("granted") && result.isQualifiedService() && result.isIssuedQualified()) {
            if (type == null) {
                type = this.checkCertType(result, chain);
            }
            if (type == CertType.signature) {
                if (result.isServiceSignatureQualified()) {
                    qualified = this.checkSpecificQualified(result, chain);
                }
            } else if (type == CertType.seal && result.isServiceSealQualified()) {
                qualified = this.checkSpecificQualified(result, chain);
            }
        }
        return qualified;
    }

    private boolean checkSpecificQualified(TSLCertificateValidation result, X509Certificate[] chain) throws IOException {
        boolean qualified = true;
        if (result.getCurrentServiceStatus() != null && result.getCurrentServiceStatus().getQualifierInfo().isNotQualified() && result.getCurrentServiceStatus().getQualifierInfo().getNotQualifiedURI() != null) {
            qualified = false;
        } else if (result.getCurrentServiceStatus() != null && result.getCurrentServiceStatus().getQualifierInfo().getQcStatementURI() != null && result.getCurrentServiceStatus().getQualifierInfo().getQcForESigURI() != null && result.getCurrentServiceStatus().getQualifierInfo().isConditionChequed()) {
            qualified = true;
        } else {
            int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
            if (finalCert != -1) {
                X509Certificate cert = chain[finalCert];
                qualified = QcStatementsUtils.checkQcCompliance((X509Certificate)cert) != null;
            }
        }
        return qualified;
    }

    public CertType checkCertType(TSLCertificateValidation result, X509Certificate[] chain) throws CertificateEncodingException, IOException {
        boolean signBySeal;
        int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
        if (finalCert == -1) {
            return CertType.unknokn;
        }
        X509Certificate cert = chain[finalCert];
        ServiceStatus certIssueDateStatus = result.getCertIssueDateStatus();
        QualifierInfo qualifierInfo = certIssueDateStatus != null ? certIssueDateStatus.getQualifierInfo() : null;
        boolean isSignTsl = result.isServiceSignatureQualified() || qualifierInfo != null && qualifierInfo.getQcForESigURI() != null;
        boolean isSealTsl = result.isServiceSealQualified() || qualifierInfo != null && qualifierInfo.getQcForSealURI() != null;
        ASN1ObjectIdentifier qcType = QcStatementsUtils.checkQcType((X509Certificate)cert);
        boolean signByOid = qcType != null && qcType.equals((ASN1Primitive)QcStatementsOID.id_etsi_qct_esign);
        boolean bl = signBySeal = qcType != null && qcType.equals((ASN1Primitive)QcStatementsOID.id_etsi_qct_eseal);
        if (isSealTsl) {
            if (!isSignTsl && signByOid) {
                throw new CertificateEncodingException("ERR_QCTYPE_WRONG_VALUE:" + qcType);
            }
            if (signBySeal) {
                return CertType.seal;
            }
        }
        if (isSignTsl || signByOid) {
            return CertType.signature;
        }
        if (signBySeal) {
            return CertType.seal;
        }
        return CertType.unknokn;
    }
}

