/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.utils;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.api.sign.exception.ANFVerifySignatureException;
import com.anf.cryptotoken.api.tkmanager.exception.EncryptException;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.utils.BLOQ_CIPHER_TYPE;
import com.anf.utils.ProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class UtilsPki {
    private static final Logger log = Logger.getLogger(UtilsPki.class);
    public static final int[] KeySizeAES = new int[]{128, 192, 256};
    private static ProgressListener progListener;

    private static void checkCancel() throws InterruptedException {
        if (progListener != null && progListener.canceled()) {
            throw new InterruptedException("cancel");
        }
    }

    public static byte[] cipherData(byte[] data, Provider prov, PublicKey pubKey, String algorithm) {
        try {
            Cipher rsa = Cipher.getInstance(algorithm, prov);
            rsa.init(1, (Key)pubKey, new SecureRandom(new String("" + System.nanoTime()).getBytes()));
            UtilsPki.updateBuffer(data, rsa, 32);
            byte[] ciphertext = rsa.doFinal();
            return ciphertext;
        }
        catch (IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptException("ERR_ENCRYPT", (Throwable)e);
        }
    }

    public static byte[] cipherData(byte[] data, Provider prov, PrivateKey privKey, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InterruptedException, IOException {
        Cipher rsa = Cipher.getInstance(algorithm, prov);
        rsa.init(1, (Key)privKey, new SecureRandom(new byte[]{0}));
        UtilsPki.updateBuffer(data, rsa, 32);
        byte[] ciphertext = rsa.doFinal();
        return ciphertext;
    }

    public static byte[] encryptDataAES(byte[] data, String password, String hashAlg, BLOQ_CIPHER_TYPE bloq) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InterruptedException, IOException {
        MessageDigest msgDigest = MessageDigest.getInstance(hashAlg);
        msgDigest.update(password.getBytes());
        UtilsPki.checkCancel();
        byte[] keyScretD = msgDigest.digest();
        SecretKeySpec skeySpec = new SecretKeySpec(keyScretD, "AES");
        return UtilsPki.encryptDataAES(data, bloq, skeySpec);
    }

    public static byte[] encryptDataAES(byte[] data, BLOQ_CIPHER_TYPE bloq, SecretKey skeySpec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InterruptedException, IOException {
        IvParameterSpec algParam = new IvParameterSpec("0000000000000000".getBytes());
        Cipher rsa = Cipher.getInstance("AES/" + bloq.name() + "/NoPadding");
        rsa.init(1, (Key)skeySpec, algParam);
        byte[] updateBuffer = UtilsPki.updateBuffer(data, rsa, 10);
        byte[] ciphertext = rsa.doFinal();
        byte[] ciphered = new byte[updateBuffer.length + ciphertext.length];
        System.arraycopy(updateBuffer, 0, ciphered, 0, updateBuffer.length);
        System.arraycopy(ciphertext, 0, ciphered, updateBuffer.length, ciphertext.length);
        return ciphered;
    }

    public static void encryptDataAES(InputStream input, BLOQ_CIPHER_TYPE bloq, SecretKey skeySpec, OutputStream out) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InterruptedException, IOException {
        IvParameterSpec algParam = new IvParameterSpec("0000000000000000".getBytes());
        Cipher rsa = Cipher.getInstance("AES/" + bloq.name() + "/NoPadding");
        rsa.init(1, (Key)skeySpec, algParam);
        UtilsPki.updateBuffer(input, rsa, 1024, out);
        byte[] ciphertext = rsa.doFinal();
        out.write(ciphertext);
    }

    private static void updateBuffer(InputStream input, Cipher rsa, int bufferSize, OutputStream out) throws InterruptedException, IOException {
        while (true) {
            UtilsPki.checkCancel();
            byte[] buf = new byte[bufferSize];
            int read = input.read(buf);
            if (read == -1) break;
            byte[] buffer = new byte[read];
            System.arraycopy(buf, 0, buffer, 0, read);
            byte[] update = rsa.update(buffer);
            if (update == null) continue;
            out.write(update);
        }
    }

    private static byte[] updateBuffer(byte[] data, Cipher rsa, int bufferSize) throws InterruptedException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < data.length; i += bufferSize) {
            UtilsPki.checkCancel();
            byte[] buf = new byte[Math.min(bufferSize, data.length - i)];
            System.arraycopy(data, i, buf, 0, buf.length);
            byte[] update = rsa.update(buf);
            if (update == null) continue;
            out.write(update);
        }
        return out.toByteArray();
    }

    public static SecretKey generateSecretKey(int length) throws InterruptedException {
        AgregarProveedor.agregarBouncyCastleProvider();
        UtilsPki.checkCancel();
        SecureRandom rnd = new SecureRandom();
        byte[] key = new byte[length];
        rnd.nextBytes(key);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        return skeySpec;
    }

    public static byte[] decryptDataAES(byte[] data, String password, String hashAlg, BLOQ_CIPHER_TYPE bloq) {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance(hashAlg);
            msgDigest.update(password.getBytes());
            byte[] keyScretD = msgDigest.digest();
            SecretKeySpec skeySpec = new SecretKeySpec(keyScretD, "AES");
            IvParameterSpec algParam = new IvParameterSpec("0000000000000000".getBytes());
            Cipher rsa = Cipher.getInstance("AES/" + bloq.name() + "/NoPadding");
            rsa.init(2, (Key)skeySpec, algParam);
            UtilsPki.updateBuffer(data, rsa, 2048);
            byte[] ciphertext = rsa.doFinal();
            return ciphertext;
        }
        catch (IOException | InterruptedException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptException("ERR_DECRYPT_AES", (Throwable)e);
        }
    }

    public static byte[] decipherData(byte[] encryptedData, Provider prov, PrivateKey priKey, String algorithm) {
        try {
            Cipher rsa = Cipher.getInstance(algorithm, prov);
            rsa.init(2, priKey);
            UtilsPki.updateBuffer(encryptedData, rsa, 32);
            byte[] cleartext = rsa.doFinal();
            return cleartext;
        }
        catch (IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptException("ERR_DECIPHER", (Throwable)e);
        }
    }

    public static byte[] decipherData(byte[] encryptedData, Provider prov, PublicKey pubKey, String algorithm) {
        try {
            Cipher rsa = Cipher.getInstance(algorithm, prov);
            rsa.init(2, pubKey);
            UtilsPki.updateBuffer(encryptedData, rsa, 32);
            byte[] cleartext = rsa.doFinal();
            return cleartext;
        }
        catch (IOException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptException("ERR_DECIPHER", (Throwable)e);
        }
    }

    public static Signature getSignature(String algorithm, String providerName) {
        try {
            Signature result = Signature.getInstance(algorithm, providerName);
            return result;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public static Signature getSignature(String algorithm, Provider provider) {
        try {
            Signature result = Signature.getInstance(algorithm, provider);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public static byte[] signData(byte[] data, PrivateKey priKey, String algorithm, Provider prov) {
        try {
            log.info((Object)("UtilsPKI.signData\nalg:" + algorithm + "\n"));
            Signature sign = Signature.getInstance(algorithm, prov);
            log.info((Object)("Signature instance: " + sign));
            return UtilsPki.signature(data, priKey, sign);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | SignatureException | UnrecoverableKeyException e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public static byte[] signData(byte[] data, PrivateKey priKey, String algorithm, String prov) {
        try {
            Signature sign = Signature.getInstance(algorithm, prov);
            return UtilsPki.signature(data, priKey, sign);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    private static byte[] signature(byte[] data, PrivateKey priKey, Signature sign) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, InvalidKeyException, SignatureException {
        log.info((Object)"sign.initSign()");
        sign.initSign(priKey);
        log.info((Object)("sign.update() data with length: " + data.length));
        sign.update(data);
        log.info((Object)"sign.sign()");
        byte[] signedData = sign.sign();
        log.info((Object)("signedData: " + signedData != null ? "OK" : "NULL"));
        return signedData;
    }

    public static boolean verifyData(byte[] data, byte[] signedData, PublicKey pubKey, String algorithm, Provider prov) {
        try {
            log.info((Object)("UtilsPKI.verifyData\nalg:" + algorithm + "\n"));
            Signature sign = Signature.getInstance(algorithm, prov);
            log.info((Object)("Signature instance: " + sign));
            return UtilsPki.verify(data, signedData, pubKey, sign);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | SignatureException | UnrecoverableKeyException e) {
            throw new ANFVerifySignatureException((Throwable)e);
        }
    }

    public static boolean verifyData(byte[] data, byte[] signedData, PublicKey pubKey, String algorithm, String prov) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, InvalidKeyException, SignatureException, NoSuchProviderException {
        Signature sign = Signature.getInstance(algorithm, prov);
        return UtilsPki.verify(data, signedData, pubKey, sign);
    }

    private static boolean verify(byte[] data, byte[] signedData, PublicKey pubKey, Signature sign) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, InvalidKeyException, SignatureException {
        log.info((Object)"sign.initVerify()");
        sign.initVerify(pubKey);
        log.info((Object)("sign.update() data with length: " + data.length));
        sign.update(data);
        log.info((Object)("sign.verify() signedData length:" + signedData.length));
        boolean verify = sign.verify(signedData);
        log.info((Object)("verify: " + verify));
        return verify;
    }

    public static void importCertInWinStore(Certificate cert, String alias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("Windows-MY");
        ks.load(null, null);
        ks.setCertificateEntry(alias, cert);
    }

    public static void listProviders() {
        try {
            Provider[] p;
            for (Provider p1 : p = Security.getProviders()) {
                log.info((Object)p1);
                Enumeration<Object> e = p1.keys();
                while (e.hasMoreElements()) {
                    log.info((Object)("\t" + e.nextElement()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static byte[] getRandomKey(int count) {
        byte[] result = new byte[count];
        for (int cont = 0; cont < count; ++cont) {
            result[cont] = (byte)(Math.random() * 100.0);
        }
        return result;
    }

    public static void setProgListener(ProgressListener progListener) {
        UtilsPki.progListener = progListener;
    }

    public static ProgressListener getProgListener() {
        return progListener;
    }
}

