/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token.detect.impl;

import com.anf.cryptotoken.log.Logger;
import com.anf.utils.OSUtils;
import com.sun.jna.platform.win32.DBT;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.swing.filechooser.FileSystemView;

public class USBDetector {
    private static final Logger log = Logger.getLogger(USBDetector.class);
    Thread thread;
    WinDef.HWND hWnd;
    static final int WM_NCCREATE = 129;
    private static TreeMap<String, Callable<Object>> actions = new TreeMap();
    WinUser.WindowProc callback = this::handleEvent;
    static long lastTime = -1L;

    public void start() {
        if (OSUtils.isWindows()) {
            this.thread = new Thread(this::myThread, "USB Detector Service ANFCT");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void onDetectUSB(List<File> usbs) {
    }

    void stop() {
        if (OSUtils.isWindows()) {
            User32.INSTANCE.PostMessage(this.hWnd, 18, null, null);
        }
    }

    private WinDef.LRESULT handleEvent(WinDef.HWND hWnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (uMsg) {
            case 129: {
                return new WinDef.LRESULT(1L);
            }
            case 537: {
                if (wParam.longValue() > 0L && lParam.longValue() > 0L) {
                    DBT.DEV_BROADCAST_VOLUME volume = this.onDeviceChange(wParam, lParam);
                    if (volume != null) {
                        log.info((Object)("cambio usb detectado " + hWnd.getPointer() + " " + uMsg + " " + wParam.longValue() + " " + lParam.longValue()));
                        List<File> usbs = USBDetector.getRemovableDevices();
                        this.onDetectUSB(usbs);
                    }
                } else if (wParam.longValue() != 0L) {
                    Set<Map.Entry<String, Callable<Object>>> entrySet = actions.entrySet();
                    for (Map.Entry<String, Callable<Object>> e : entrySet) {
                        try {
                            e.getValue().call();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1);
                        }
                    }
                }
                return new WinDef.LRESULT(1L);
            }
        }
        return new WinDef.LRESULT(0L);
    }

    protected DBT.DEV_BROADCAST_VOLUME onDeviceChange(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (wParam.intValue()) {
            case 32768: {
                return this.onDeviceChangeArrival(lParam);
            }
            case 32772: {
                return this.onDeviceChangeRemoveComplete(lParam);
            }
        }
        return null;
    }

    protected DBT.DEV_BROADCAST_VOLUME onDeviceChangeArrivalOrRemoveComplete(WinDef.LPARAM lParam, String action) {
        DBT.DEV_BROADCAST_HDR bhdr = new DBT.DEV_BROADCAST_HDR(lParam.longValue());
        bhdr.read();
        if (2 == bhdr.dbch_devicetype) {
            DBT.DEV_BROADCAST_VOLUME volume = new DBT.DEV_BROADCAST_VOLUME(bhdr.getPointer());
            int logicalDriveAffected = volume.dbcv_unitmask;
            int driveLetterIndex = 0;
            char driveLetter = '\u0000';
            while (logicalDriveAffected != 0) {
                if (0 != (logicalDriveAffected & 1)) {
                    driveLetter = (char)(65 + driveLetterIndex);
                }
                logicalDriveAffected >>>= 1;
                ++driveLetterIndex;
            }
            log.info((Object)(action + " el dispositivo USB " + driveLetter));
            return volume;
        }
        return null;
    }

    protected DBT.DEV_BROADCAST_VOLUME onDeviceChangeArrival(WinDef.LPARAM lParam) {
        return this.onDeviceChangeArrivalOrRemoveComplete(lParam, "se ha conectado");
    }

    protected DBT.DEV_BROADCAST_VOLUME onDeviceChangeRemoveComplete(WinDef.LPARAM lParam) {
        return this.onDeviceChangeArrivalOrRemoveComplete(lParam, "se ha desconectado");
    }

    public static List<File> getRemovableDevices() {
        File[] listRoots = File.listRoots();
        ArrayList<File> usbs = new ArrayList<File>();
        for (int i = 0; i < listRoots.length; ++i) {
            File rootFile = listRoots[i];
            boolean isUSB = USBDetector.isUSB(rootFile);
            if (!isUSB) continue;
            usbs.add(rootFile);
        }
        return usbs;
    }

    public static boolean isUSB(File rootFile) {
        log.info((Object)("isUSB " + rootFile));
        try {
            String type = FileSystemView.getFileSystemView().getSystemTypeDescription(rootFile);
            return FileSystemView.getFileSystemView().isDrive(rootFile) && (type.toLowerCase().contains("rem") || type.toLowerCase().contains("usb"));
        }
        catch (Exception e) {
            log.warn((Object)"error isUSB", (Throwable)e);
            return false;
        }
    }

    void myThread() {
        WinUser.WNDCLASSEX wx = new WinUser.WNDCLASSEX();
        wx.clear();
        wx.lpszClassName = "myclass";
        wx.lpfnWndProc = this.callback;
        if (User32.INSTANCE.RegisterClassEx(wx).intValue() != 0) {
            this.hWnd = User32.INSTANCE.CreateWindowEx(0, wx.lpszClassName, null, 0, 0, 0, 0, 0, null, null, null, null);
            WinUser.MSG msg = new WinUser.MSG();
            msg.clear();
            while (User32.INSTANCE.GetMessage(msg, this.hWnd, 0, 0) > 0) {
                User32.INSTANCE.TranslateMessage(msg);
                User32.INSTANCE.DispatchMessage(msg);
            }
        }
    }

    private void checkMsg(WinUser.MSG msg) {
        long now = System.nanoTime();
        if (lastTime == -1L) {
            lastTime = now;
            System.out.println("nuevo mensaje(" + now + ")");
        } else {
            long dif = now - lastTime;
            System.out.println("dif=" + dif);
            if (dif > 1000000000L) {
                lastTime = now;
                System.out.println("nuevo mensaje(" + now + ")");
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        USBDetector d = new USBDetector();
        d.start();
        TimeUnit.MINUTES.sleep(10L);
    }

    public static void addUSBChangeAction(String string, Callable<Object> onUSBChange) {
        actions.computeIfAbsent(string, k -> onUSBChange);
    }
}

