/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token;

import com.anf.cryptotoken.config.AtrObject;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.config.Device;
import com.anf.cryptotoken.config.DvcType;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.token.ANFToken;
import com.anf.jna.smartcardio.JnaCard;
import com.anf.jna.smartcardio.JnaCardChannel;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import java.io.IOException;

public abstract class ANFTokenAbstract
implements ANFToken {
    private static final Logger log = Logger.getLogger(ANFTokenAbstract.class);
    protected static final String XML_FILENAME = "ATRList.xml";
    protected static final String protocol = "*";
    protected AtrObject atr;
    protected JnaCard card;
    protected JnaCardChannel cardChannel;
    protected String serialNumber;
    protected long slot;
    private String PINManufacturer;
    private String PINSODefault;
    private String PINSOManufacturer;
    private String labelToken;
    private String labelTokenManufacturer;
    private String iniFileName;
    private CK_TOKEN_INFO tkinfo;

    protected ANFTokenAbstract(DvcType type, CK_TOKEN_INFO tkinfo, JnaCard card, AtrObject atrObj) throws IOException {
        this.atr = atrObj;
        this.card = card;
        if (card != null) {
            this.cardChannel = card.getBasicChannel();
        }
        this.tkinfo = tkinfo;
        Confis confis = Confis.get();
        Device dvc = confis.getDevice(type);
        this.PINManufacturer = dvc.getManufacturerPin();
        this.PINSODefault = dvc.getSoDefaultPin();
        this.PINSOManufacturer = dvc.getSoManufacturerPin();
        this.labelTokenManufacturer = dvc.getLabelManufacurer();
        this.labelToken = dvc.getLabel();
        this.iniFileName = dvc.getIniFile();
    }

    @Override
    public String getTokenPkcs11() {
        return this.atr.getPkcs11();
    }

    @Override
    public String getTokenSerialNumber() {
        log.info((Object)"\"getTokenSerialNumber()\" Not supported yet.");
        return "";
    }

    @Override
    public boolean isTokenInitialized() {
        log.info((Object)"\"isTokenInitialized()\" Not supported yet.");
        return true;
    }

    @Override
    public String getPINManufacturer() {
        return this.PINManufacturer;
    }

    public void setPINManufacturer(String pINManufacturer) {
        this.PINManufacturer = pINManufacturer;
    }

    @Override
    public String getPINSODefault() {
        return this.PINSODefault;
    }

    public void setPINSODefault(String pINSODefault) {
        this.PINSODefault = pINSODefault;
    }

    @Override
    public String getPINSOManufacturer() {
        return this.PINSOManufacturer;
    }

    public void setPINSOManufacturer(String pINSOManufacturer) {
        this.PINSOManufacturer = pINSOManufacturer;
    }

    @Override
    public String getLabelToken() {
        return this.labelToken;
    }

    public void setLabelToken(String labelToken) {
        this.labelToken = labelToken;
    }

    public String getLabelTokenManufacturer() {
        return this.labelTokenManufacturer;
    }

    public void setLabelTokenManufacturer(String labelTokenManufacturer) {
        this.labelTokenManufacturer = labelTokenManufacturer;
    }

    public String getIniFileName() {
        return this.iniFileName;
    }

    public void setIniFileName(String iniFileName) {
        this.iniFileName = iniFileName;
    }
}

