/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token;

import com.anf.cryptotoken.config.DvcType;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.token.ANFTokenAbstract;
import com.anf.firmas.jni.InitANFP11;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.utils.SerialUtils;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.Level;

public class ANFTokenANFP11
extends ANFTokenAbstract {
    private static final Logger log = Logger.getLogger(ANFTokenANFP11.class);

    public ANFTokenANFP11(CK_TOKEN_INFO tinfo, long slot) throws IOException {
        super(DvcType.ANFP11, tinfo, null, null);
        this.serialNumber = new String(tinfo.getSerialNumber()).trim();
        if (this.serialNumber.isEmpty()) {
            try {
                log.info(new Object[]{"el numero de serie del slot " + slot + " de ANFP11, esta vacio", Level.WARN});
                log.info((Object)("token info: " + tinfo));
                this.serialNumber = SerialUtils.getSerialNumber((String)InitANFP11.get().getSlotUnit(slot));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (this.serialNumber == null || this.serialNumber.isEmpty()) {
            log.error((Object)("el numero de serie del slot " + slot + " de ANFP11 es nulo, se pondra en 0"));
            this.serialNumber = "0";
        }
        this.serialNumber = new BigInteger(this.serialNumber, 16).toString();
    }

    @Override
    public String getTokenPkcs11() {
        return this.atr.getPkcs11();
    }

    @Override
    public String getTokenSerialNumber() {
        return this.serialNumber;
    }
}

