/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.KeyPairException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.TKManagerAbstract;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.controller.impl.AuthHandlerImpl;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.USBFactory;
import com.anf.cryptotoken.utils.DatosPersonales;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import link.DiskStatus;
import link.SMILink;

public class TKManagerSMI
extends TKManagerAbstract {
    private static final Logger log = Logger.getLogger(TKManagerSMI.class);
    private static final String KEYSTORE_TYPE = "UBER";
    private String passwordStore = "";
    private String storePath;
    public static final String FILE = "appmgmts.dll";
    public static final SMILink link = new SMILink();

    private TKManagerSMI(String unitUUID) {
        this.usb = USBFactory.newUSB((String)"", (String)unitUUID);
    }

    protected TKManagerSMI(USB usb, String path) {
        this.usb = usb;
        this.storePath = path;
        this.passwordStore = usb.getUUID();
        this.loadStore(usb, path);
    }

    public static void createStores() throws FileNotFoundException, IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        AgregarProveedor.agregarBouncyCastleProvider();
        ArrayList<USB> usbs = TKManagerSMI.listUSBs();
        for (USB usb : usbs) {
            try {
                TKManagerSMI.createStore(usb);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public static void createStore(USB usb) throws Exception {
        if (TKManagerSMI.copyFile(usb, FILE)) {
            KeyStore store = TKManagerSMI.createEmptyKeyStore(usb);
            TKManagerSMI.createStore(usb, store);
        }
    }

    public static KeyStore createEmptyKeyStore(USB usb) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        store.load(null, usb.getUUID().toCharArray());
        return store;
    }

    public static void createStore(USB usb, KeyStore store) throws Exception {
        if (TKManagerSMI.copyFile(usb, FILE)) {
            TKManagerSMI smi = new TKManagerSMI(usb.getUUID());
            smi.saveStore(usb, FILE, store, usb.getUUID());
        }
    }

    public static boolean copyFile(USB usb, String file) throws FileNotFoundException, IOException {
        SecureRandom sec = new SecureRandom(new byte[]{(byte)System.nanoTime()});
        byte[] buffer = new byte[(int)(164000L + (long)sec.nextInt(1000))];
        sec.nextBytes(buffer);
        return link.writeFileFromBufferToReserv(usb.getLetter(), buffer, file, "");
    }

    private void loadStore(USB usb, String path) {
        try {
            this.usb = usb;
            AgregarProveedor.agregarBouncyCastleProvider();
            this.store = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
            this.storePath = path;
            char letter = usb.getLetter();
            try (LockerImpl locker = TKManagerSMI.getLocker(letter).acquireLock();){
                if (link.checkReservFileExist(letter, this.storePath)) {
                    byte[] buffer = link.readFileReservToBuffer(letter, this.storePath, "", "");
                    long aliasSerialMapPoint = TKManagerSMI.getAliasSerialMapPoint();
                    boolean doUpdate = false;
                    int mapLength = TKManagerSMI.getInt(buffer, (int)aliasSerialMapPoint);
                    if (mapLength > 0 && (long)mapLength < TKManagerSMI.getAccessPoint() - (aliasSerialMapPoint += 4L)) {
                        byte[] aliasSerialMapBytes = new byte[mapLength];
                        System.arraycopy(buffer, (int)aliasSerialMapPoint, aliasSerialMapBytes, 0, mapLength);
                        this.loadAliasSerialMap(aliasSerialMapBytes);
                    } else {
                        doUpdate = true;
                    }
                    long accessPoint = TKManagerSMI.getAccessPoint();
                    if ((long)buffer.length > accessPoint + 4L) {
                        int storeLength;
                        if ((storeLength = TKManagerSMI.getInt(buffer[(int)accessPoint++], buffer[(int)accessPoint++], buffer[(int)accessPoint++], buffer[(int)accessPoint++])) <= 0 || (long)storeLength > (long)buffer.length - TKManagerSMI.getAccessPoint()) {
                            this.store.load(null, null);
                        } else if ((long)buffer.length > accessPoint + (long)storeLength) {
                            byte[] data = Arrays.copyOfRange(buffer, (int)accessPoint, (int)accessPoint + storeLength);
                            ByteArrayInputStream dataInput = new ByteArrayInputStream(data);
                            this.store.load(dataInput, this.passwordStore.toCharArray());
                        }
                    }
                    if (doUpdate) {
                        this.updatePUKData(buffer, this.store, TKManagerSMI.getAliasSerialMapPoint(), usb.getLetter(), this.storePath);
                    }
                } else {
                    this.store.load(null, null);
                }
            }
        }
        catch (Exception e) {
            throw new ANFKeyStoreException("ERR_SMI_STORE_LOAD", (Throwable)e);
        }
    }

    private void updatePUKData(byte[] buffer, KeyStore store, long aliasSerialMapPoint, char letter, String path) {
        log.info((Object)"updatePUKData");
        try {
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                try {
                    Certificate[] certChain = store.getCertificateChain(alias);
                    X509Certificate[] chain = CertUtils.sortChain((X509Certificate[])CertUtils.toX509((Certificate[])certChain));
                    String title = Confis.get().getString("insertPUKofCert", new Object[0]);
                    String serial = chain[CertUtils.getFinalCert((X509Certificate[])chain)].getSerialNumber().toString();
                    String id = this.getPukId(serial, alias);
                    this.updateAliasSerialMap(alias, serial, new String(KeyBoardHandler.getPasswordForCertificates(id, chain, title, true, true, this.getAuthHandler(alias))), null);
                }
                catch (Exception e1) {
                    log.error((Object)e1);
                }
            }
            byte[] saveAliasSerialMap = this.saveAliasSerialMap();
            byte[] bytes = TKManagerSMI.toBytes(saveAliasSerialMap.length);
            System.arraycopy(bytes, 0, buffer, (int)aliasSerialMapPoint, bytes.length);
            System.arraycopy(saveAliasSerialMap, 0, buffer, (int)TKManagerSMI.getAliasSerialMapPoint() + 4, saveAliasSerialMap.length);
            link.writeFileFromBufferToReserv(letter, buffer, path, "");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static final int getInt(byte[] buf, int start) throws IOException {
        return TKManagerSMI.getInt(buf[start], buf[start + 1], buf[start + 2], buf[start + 3]);
    }

    public static final int getInt(byte b1, byte b2, byte b3, byte b4) throws IOException {
        int ch4;
        int ch1 = b1 < 0 ? 256 + b1 : b1;
        int ch2 = b2 < 0 ? 256 + b2 : b2;
        int ch3 = b3 < 0 ? 256 + b3 : b3;
        int n = ch4 = b4 < 0 ? 256 + b4 : b4;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final byte[] toBytes(int v) throws IOException {
        return new byte[]{(byte)((byte)(v >>> 24) & 0xFF), (byte)((byte)(v >>> 16) & 0xFF), (byte)((byte)(v >>> 8) & 0xFF), (byte)((byte)(v >>> 0) & 0xFF)};
    }

    public static ArrayList<USB> listUSBs() {
        ArrayList<USB> usbs = new ArrayList<USB>();
        char[] sysInfo = link.getSysInfo(null, null);
        char[] cdromLetter = link.getCDROMLetter();
        String str = cdromLetter == null ? "" : new String(cdromLetter);
        for (int i = 0; i < sysInfo.length; ++i) {
            if (str.contains("" + sysInfo[i])) continue;
            DiskStatus dm = link.getDiskCurrentMode(sysInfo[i]);
            if (dm.reservAreaLBA == 0L) continue;
            try {
                String path = sysInfo[i] + ":" + File.separator;
                usbs.add(USBFactory.newUSB((String)path, (String)TKManagerSMI.getSerialForSMI(path)));
                continue;
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        if (sysInfo.length == 0) {
            // empty if block
        }
        return usbs;
    }

    public static String getSerialForSMI(String unit) throws IOException {
        return new BigInteger(link.getSerialNumber(unit.charAt(0)), 16).toString();
    }

    @Override
    public void saveStore() {
        KeyStore store = this.store;
        String pass = this.passwordStore;
        this.saveStore(this.usb, FILE, store, pass);
    }

    public void saveStore(USB usb, String path, KeyStore store, String pass) {
        if (path == null) {
            return;
        }
        char letter = usb.getLetter();
        try (LockerImpl locker = TKManagerSMI.getLocker(letter).acquireLock();){
            if (link.checkReservFileExist(letter, path)) {
                byte[] buffer = link.readFileReservToBuffer(letter, path, "", "");
                byte[] saveAliasSerialMap = this.saveAliasSerialMap();
                byte[] bytes = TKManagerSMI.toBytes(saveAliasSerialMap.length);
                System.arraycopy(bytes, 0, buffer, (int)TKManagerSMI.getAliasSerialMapPoint(), bytes.length);
                System.arraycopy(saveAliasSerialMap, 0, buffer, (int)TKManagerSMI.getAliasSerialMapPoint() + 4, saveAliasSerialMap.length);
                ByteArrayOutputStream storeDataStream = new ByteArrayOutputStream();
                store.store(storeDataStream, pass.toCharArray());
                byte[] storeData = storeDataStream.toByteArray();
                bytes = TKManagerSMI.toBytes(storeData.length);
                long accessPoint = TKManagerSMI.getAccessPoint();
                System.arraycopy(bytes, 0, buffer, (int)accessPoint, bytes.length);
                System.arraycopy(storeData, 0, buffer, (int)(accessPoint += (long)bytes.length), storeData.length);
                link.writeFileFromBufferToReserv(letter, buffer, path, "");
            }
        }
        catch (Exception e) {
            throw new ANFKeyStoreException("ERR_SAVE_STORE", (Throwable)e);
        }
    }

    @Override
    public String getPrPath() {
        return null;
    }

    @Override
    public PublicKey getPublicKey(String alias) {
        try {
            return this.store.getCertificate(alias).getPublicKey();
        }
        catch (KeyStoreException e) {
            throw new ANFCertificateException();
        }
    }

    @Override
    protected String getImportTitle(String alias) {
        String title = Confis.get().getString("importAlias", new Object[0]) + Confis.get().getString("importAliasSMI", new Object[0]) + this.getUSB().getLetter();
        return title;
    }

    @Override
    public void reloadToken() {
        this.loadStore(this.usb, this.storePath);
    }

    @Override
    public void resetToken() {
        throw new UnsupportedOperationException(Confis.get().getString("30", new Object[0]));
    }

    @Override
    public String getSerialNumberToken() {
        return this.usb != null ? this.usb.getUUID() : null;
    }

    public void export(String alias, String password, File outputFile) throws Exception {
        try {
            PrivateKey privateKey = this.getPrivateKeyStore(alias);
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(null, null);
            Certificate certificate = store.getCertificate(alias);
            X509Certificate mainCert = (X509Certificate)certificate;
            X500Principal datosPersonales = mainCert.getSubjectX500Principal();
            DatosPersonales dpSubject = new DatosPersonales(datosPersonales);
            String cn = dpSubject.getCN();
            Certificate[] cert = new Certificate[]{certificate};
            store.setKeyEntry(cn, privateKey, null, cert);
            FileOutputStream out = new FileOutputStream(outputFile);
            store.store(out, password.toCharArray());
            out.close();
        }
        catch (IOException | NoSuchProviderException | CertificateException ex) {
            log.error((Object)ex);
        }
    }

    public String getPassword() {
        return this.passwordStore;
    }

    public String getStorePath() {
        return this.storePath;
    }

    @Override
    protected KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", this.store.getProvider());
            kpg.initialize(keySize);
            return kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyPairException((Throwable)e);
        }
    }

    private static long getAccessPoint() {
        return 12600L;
    }

    private static long getAliasSerialMapPoint() {
        return 5600L;
    }

    @Override
    public USB getUSB() {
        return this.usb;
    }

    public LockerImpl getLocker() {
        return LockerImpl.get((String)("smi-" + this.usb.getLetter()));
    }

    public static LockerImpl getLocker(char letter) {
        return LockerImpl.get((String)("smi-" + letter));
    }

    @Override
    public void removeCertificate(String alias) throws Throwable {
        PrivateKey pk = this.getPrivateKey(alias);
        if (pk != null) {
            super.removeCertificate(alias);
            this.saveStore();
        }
    }

    @Override
    public AuthHandler getAuthHandler(Object ... data) {
        String alias = null;
        if (data != null && data.length > 0) {
            alias = data[0].toString();
        }
        return new AuthHandlerImpl(this, alias);
    }

    @Override
    protected boolean supportPUK() {
        return true;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.getPrivateKeyStore(alias);
    }

    @Override
    public boolean isSignatureStore() {
        return false;
    }
}

