/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import anf.centralizados.client.client.CentralClient;
import anf.centralizados.core.json.response.Response;
import anf.centralizados.core.json.response.ResponseBoolean;
import anf.centralizados.core.json.response.ResponseByteArray;
import anf.centralizados.core.json.response.ResponseCreateVerificationCode;
import anf.centralizados.core.json.response.ResponseGetAlias;
import anf.centralizados.core.json.response.ResponseGetCertificateChain;
import anf.centralizados.core.json.response.ResponseGetCertificates;
import anf.centralizados.core.json.response.ResponseGetCounterInfo;
import anf.centralizados.core.json.response.ResponseGetPersonalInformacion;
import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.AuthInfo;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCentralServerError;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCentralServerNotLoggedIn;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.api.tkmanager.params.UnlockPINParams;
import com.anf.cryptotoken.api.token.TokenInfo;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.json.TrayIconUserLogin;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.server.CentralServerController;
import com.anf.cryptotoken.server.TrayIconClient;
import com.anf.cryptotoken.tkmanager.AuthInfoImpl;
import com.anf.cryptotoken.tkmanager.TKManagerCommon;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.tkmanager.params.UnlockPINParamsImpl;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;

public class TKManagerRemote
extends TKManagerCommon {
    private static final Logger log = Logger.getLogger(TKManagerRemote.class);
    private CentralServerController controller;
    private String userId;
    private String pass;
    private boolean checkLocalLogin = false;
    private CentralClient client;
    private char[] pin;
    private Date loginCheckNextUpdate;

    public TKManagerRemote(CentralServerController controller) {
        this.reload(controller.getUser(), controller.getPassword(), controller.createClient());
        this.controller = controller;
    }

    private void reload(String userId, String pass, CentralClient client) {
        this.userId = userId;
        this.pass = pass;
        this.client = client;
        this.validateUser();
        this.getNextLoginUpdateDate();
        client.initCache();
        log.info((Object)("user " + userId + " logged in using password"));
    }

    public TKManagerRemote(boolean usePasswordAsPIN, CentralServerController controller) {
        this(controller);
        if (usePasswordAsPIN) {
            this.pin = this.pass.toCharArray();
        }
    }

    public TKManagerRemote(char[] pin, CentralServerController controller) {
        this(controller);
        this.pin = pin;
    }

    private void validateUser() {
        try {
            this.client.login();
        }
        catch (Exception e) {
            throw new ANFCentralServerError("ERR_SERVER_LOGIN_FAILED", (Throwable)e);
        }
    }

    public TKManagerRemote(CentralServerController controller, boolean checkLogin) throws Exception {
        this(controller);
        this.checkLocalLogin = checkLogin;
    }

    public void checkLogin() {
        block5: {
            if (this.checkLocalLogin && (this.loginCheckNextUpdate == null || new Date().after(this.loginCheckNextUpdate))) {
                try {
                    this.getNextLoginUpdateDate();
                    TrayIconUserLogin login = TrayIconClient.loginToLocalAuthServer();
                    if (login != null && login.isResult() && login.isLogin() && login.getUserId() != null && login.getUserPassword() != null && !login.getUserId().isEmpty() && !login.getUserPassword().isEmpty()) {
                        boolean changeDetected;
                        boolean bl = changeDetected = this.userId == null || this.pass == null || !login.getUserId().equals(this.userId) || !login.getUserPassword().equals(this.pass);
                        if (changeDetected) {
                            this.userId = login.getUserId();
                            this.pass = login.getUserPassword();
                            this.reloadToken();
                        }
                        break block5;
                    }
                    throw new ANFCentralServerNotLoggedIn();
                }
                catch (Throwable e) {
                    throw new ANFCentralServerError(e.getMessage(), e);
                }
            }
        }
    }

    private void getNextLoginUpdateDate() {
        Calendar nextUpdate = Calendar.getInstance();
        nextUpdate.add(13, 30);
        this.loginCheckNextUpdate = nextUpdate.getTime();
    }

    @Override
    public void reloadToken() {
        this.resetToken();
    }

    @Override
    public void resetToken() {
        try {
            this.controller.setUser(this.userId);
            this.controller.setPassword(this.pass);
            this.reload(this.userId, this.pass, this.controller.createClient());
        }
        catch (Exception e) {
            throw new ANFKeyStoreException((Throwable)e);
        }
    }

    @Override
    public boolean changePIN(String alias) {
        this.checkLogin();
        X509Certificate[] chain = this.getCertificateChain(alias);
        X509Certificate cert = chain[CertUtils.getFinalCert((X509Certificate[])chain)];
        if (cert != null) {
            char[] old = null;
            String subject = CertUtils.getSubjectCN((X509Certificate)cert);
            try {
                String id = this.getKeyBoardId(alias) + "old-pin";
                old = KeyBoardHandler.getPasswordForCertificates(id, chain, Confis.get().getString("inputOldPINCert", subject, this.userId), false, false, this.getAuthHandler(alias));
                id = this.getKeyBoardId(alias) + "new-pin";
                char[] newPIN = KeyBoardHandler.getPasswordForCertificates(id, chain, Confis.get().getString("inputPINCert", subject, this.userId), true, false, this.getAuthHandler(new Object[0]));
                id = this.getKeyBoardId(alias) + "new-puk";
                char[] newPUK = KeyBoardHandler.getPassword(id, Confis.get().getString("insertPUK", new Object[0]), true, true, this.getAuthHandler(new Object[0]));
                String code = this.getVerificationCode(alias);
                if (code != null) {
                    boolean ok = this.controller.parseResponse((Response)this.client.changePIN(alias, old, newPIN, newPUK, code));
                    return ok;
                }
            }
            catch (NOPINException e) {
                KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                throw e;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getVerificationCode(String alias) {
        ResponseCreateVerificationCode codeResp;
        String code = null;
        ResponseGetPersonalInformacion personalInformacion = this.client.getPersonalInformacion();
        if (personalInformacion == null || !personalInformacion.isSuccess()) throw new ANFCentralServerError(personalInformacion != null ? personalInformacion.getErrorId() : "ERR_VERIFICATION_NO_CONTACT_INFO");
        String mail = personalInformacion.getMail();
        String phoneNumber = personalInformacion.getPhoneNumber();
        if (mail == null) {
            if (phoneNumber == null) throw new ANFCentralServerError("ERR_VERIFICATION_NO_CONTACT_INFO");
        }
        if ((codeResp = this.client.createVerificationCode(mail, phoneNumber)) == null || !codeResp.isSuccess()) throw new ANFCentralServerError(codeResp != null ? codeResp.getErrorId() : "ERR_VERIFICATION_CODE");
        if (!KeyBoardHandler.isShowMessages()) throw new ANFCentralServerError("ERR_CODE_CONFIRM_REQUIRED");
        String id = this.getKeyBoardId(alias) + "-sms-code";
        char[] codeChars = KeyBoardHandler.getPassword(id, Confis.get().getString("TITLE_MAIL_SMS", new Object[0]), false, false, this.getAuthHandler(new Object[0]));
        if (codeChars == null) throw new ANFCentralServerError("ERR_VERIFICATION_CODE");
        return new String(codeChars);
    }

    @Override
    public boolean changePIN(String alias, char[] old, char[] newPIN, char[] newPuk) {
        boolean ok = false;
        this.checkLogin();
        String code = this.getVerificationCode(alias);
        if (code != null) {
            ok = this.controller.parseResponse((Response)this.client.changePIN(alias, old, newPIN, newPuk, code));
        }
        return ok;
    }

    private AuthHandler getAuthHandler(Object ... data) {
        return null;
    }

    @Override
    public String getSerialNumberToken() {
        return this.userId;
    }

    @Override
    public byte[] generateRequest(String alias, X500Name x500Name, BigInteger serial, Date notBefore, Date notAfter, int keySize, ASN1Set attributes, String signAlg) {
        this.checkLogin();
        if (alias == null) {
            alias = this.getNewValidAlias(x500Name);
        }
        String title = this.getCertCreationTitle();
        Object id = this.getKeyBoardId(alias);
        char[] password = KeyBoardHandler.getPassword((String)id, title, false, false, this.getAuthHandler(alias));
        title = Confis.get().getString("insertPUK", new Object[0]);
        id = this.getKeyBoardId(alias) + "-puk";
        char[] puk = KeyBoardHandler.getPassword((String)id, title, false, false, this.getAuthHandler(alias));
        ResponseByteArray generateRequestResponse = this.client.generateRequest(new String(password), new String(puk), alias, x500Name, serial, notBefore, notAfter, keySize, attributes, null, signAlg);
        if (this.controller.parseResponse((Response)generateRequestResponse)) {
            return generateRequestResponse.getResult();
        }
        return null;
    }

    @Override
    public void importCertificate(String alias, X509Certificate[] certs) {
        this.checkLogin();
        String title = this.getImportTitle(alias);
        char[] password = KeyBoardHandler.getPasswordForCertificates(alias, certs, title, false, false, this.getAuthHandler(alias));
        title = Confis.get().getString("insertPUK", new Object[0]);
        String id = this.getKeyBoardId(alias) + "-puk";
        char[] puk = KeyBoardHandler.getPassword(id, title, true, true, null);
        Response resp = this.client.importCertificate(new String(password), new String(puk), alias, certs);
        if (!resp.isSuccess()) {
            String error = "ERR_IMPORT_CERT_CENTRALIZED";
            if (resp.getErrorId() != null) {
                error = resp.getErrorId();
            }
            throw new ANFCentralServerError(error);
        }
    }

    @Override
    public void removeCertificate(String alias) {
        this.checkLogin();
        this.client.removeCertificate(alias);
    }

    @Override
    public Enumeration<String> getAlias() {
        this.checkLogin();
        this.client.updateCache();
        ResponseGetAlias aliasResponse = this.client.getAliasV2();
        if (this.controller.parseResponse((Response)aliasResponse)) {
            return Collections.enumeration(aliasResponse.getResult());
        }
        return Collections.enumeration(new ArrayList());
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        X509Certificate[] chain = this.getCertificateChain(alias);
        if (chain != null) {
            int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
            if (finalCert != -1) {
                return chain[finalCert];
            }
            throw new ANFCertificateException("ERR_NO_USER_CERTIFICATE:" + alias);
        }
        throw new ANFCertificateException("ERR_NO_CERTIFICATE_ALIAS:" + alias);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        this.checkLogin();
        ResponseGetCertificateChain certificateChainResponse = this.client.getCertificateChainV2Cache(alias);
        if (this.controller.parseResponse((Response)certificateChainResponse)) {
            return certificateChainResponse.getResult();
        }
        return null;
    }

    @Override
    public Provider getProvider() {
        return Security.getProvider("BC");
    }

    @Override
    public KeyStore getKeyStore() {
        throw new UnsupportedOperationException("getKeyStore not supported");
    }

    @Override
    public KeyPair getKeyPair(String alias) {
        throw new UnsupportedOperationException("getKeyPair not supported");
    }

    @Override
    public KeyPair getKeyPair(String alias, char[] pin) {
        throw new UnsupportedOperationException("getKeyPair not supported");
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm) {
        if (this.pin != null) {
            return this.signData(alias, data, signAlgorithm, this.pin);
        }
        this.checkLogin();
        String title = Confis.get().getString("accessKey", new Object[0]);
        X509Certificate[] chain = this.getCertificateChain(alias);
        if (chain == null) {
            throw new ANFCentralServerError("ERR_NULL_CERT_CHAIN");
        }
        chain = CertUtils.sortChain((X509Certificate[])chain);
        String id = this.getKeyBoardId(alias);
        Function act = login -> {
            char[] password = login.getPin();
            try {
                ResponseByteArray signDataResponse = null;
                try {
                    signDataResponse = this.client.signData(alias, data, signAlgorithm, password);
                }
                catch (Exception e) {
                    log.error((Object)"error en primer intento de firma, repetimos...", (Throwable)e);
                    signDataResponse = this.client.signData(alias, data, signAlgorithm, password);
                }
                if (this.controller.parseResponse((Response)signDataResponse)) {
                    return new LoginResult<byte[]>(signDataResponse.getResult());
                }
                throw new ANFCentralServerError(signDataResponse.getErrorId());
            }
            catch (Exception e) {
                log.error((Object)e);
                return new LoginResult(e);
            }
        };
        try {
            X509Certificate signCert = chain[CertUtils.getFinalCert((X509Certificate[])chain)];
            signCert.checkValidity();
            BigInteger certSn = signCert.getSerialNumber();
            String serialCert = certSn.toString();
            AuthInfoImpl auth = this.getCounterInfo(alias);
            int start = this.getStartPinCounter(alias, serialCert, auth);
            int maxTries = auth.getMaxPIN();
            return (byte[])KeyBoardHandler.checkPassword(id, title, act, false, false, this.getAuthHandler(new Object[0]), chain, start, maxTries, ignore -> null);
        }
        catch (ANFCentralServerError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ANFCentralServerError("ERR_PIN_ERROR", e);
        }
    }

    private int getStartPinCounter(String alias, String serialCert, AuthInfo auth) throws IOException {
        int start = 0;
        if (auth != null) {
            if (auth.getPinCounter() >= auth.getMaxPIN()) {
                if (auth.getPukCounter() >= auth.getMaxPUK()) {
                    String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                    KeyBoardHandler.msg(Confis.get().getString("privateKeyAttacked", new Object[0]), errorTitle, 0);
                    throw new PINLOCKEDException(false);
                }
                this.onPINLocked(alias, serialCert, auth);
            }
            start = auth.getPinCounter();
        }
        return start;
    }

    protected int onPINLocked(String alias, String serial, AuthInfo auth) {
        if (auth.getPinCounter() >= auth.getMaxPIN()) {
            while (true) {
                if (auth.getPinCounter() >= auth.getMaxPIN() && auth.getPukCounter() < auth.getMaxPUK()) {
                    if (serial == null) {
                        serial = this.getSerialCert(alias);
                    }
                    KeyBoardHandler.msg(Confis.get().getString("235", new Object[0]));
                    boolean unlock = this.unlockPIN(new UnlockPINParamsImpl(alias, serial, null, null));
                    if (!unlock) {
                        String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                        if (auth.getPukCounter() < auth.getMaxPUK()) {
                            KeyBoardHandler.msg(Confis.get().getString("pukFailed", new Object[0]), errorTitle, 2);
                        } else {
                            KeyBoardHandler.msg(Confis.get().getString("pukBloqued", new Object[0]), errorTitle, 0);
                        }
                        if (auth.getPinCounter() < auth.getMaxPIN() || auth.getPukCounter() < auth.getMaxPUK()) continue;
                        throw new PINLOCKEDException(false);
                    }
                    return auth.getPinCounter();
                }
                if (auth.getPinCounter() >= auth.getMaxPIN()) break;
            }
            throw new PINLOCKEDException(false);
        }
        return auth.getPinCounter();
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm, char[] pin) {
        this.checkLogin();
        ResponseByteArray signDataResponse = this.client.signData(alias, data, signAlgorithm, pin);
        if (this.controller.parseResponse((Response)signDataResponse)) {
            return signDataResponse.getResult();
        }
        return null;
    }

    @Override
    public boolean verifyData(String alias, byte[] data, byte[] signedData, String signAlgorithm) {
        return UtilsPki.verifyData(data, signedData, this.getCertificate(alias).getPublicKey(), signAlgorithm, Security.getProvider("BC"));
    }

    @Override
    public byte[] encryptData(String alias, byte[] data, String algorithm) {
        return UtilsPki.cipherData(data, Security.getProvider("BC"), this.getCertificate(alias).getPublicKey(), algorithm);
    }

    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm) {
        if (this.pin != null) {
            return this.decryptData(alias, encryptedData, algorithm, this.pin);
        }
        this.checkLogin();
        String title = Confis.get().getString("accessKey", new Object[0]);
        X509Certificate[] chain = this.getCertificateChain(alias);
        if (chain == null) {
            throw new ANFCentralServerError("ERR_NULL_CERT_CHAIN");
        }
        chain = CertUtils.sortChain((X509Certificate[])this.getCertificateChain(alias));
        String id = this.getKeyBoardId(alias);
        char[] password = KeyBoardHandler.getPasswordForCertificates(id, chain, title, false, false, this.getAuthHandler(alias));
        ResponseByteArray decryptDataResponse = this.client.decryptData(alias, encryptedData, algorithm, password);
        if (this.controller.parseResponse((Response)decryptDataResponse)) {
            return decryptDataResponse.getResult();
        }
        return null;
    }

    @Override
    protected String getKeyBoardId(String alias) {
        String id = this.getSerialNumberToken() + "-" + alias;
        if (this.getUSB() != null) {
            id = id + this.getUSB();
        }
        return id;
    }

    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm, char[] pin) {
        this.checkLogin();
        ResponseByteArray decryptDataResponse = this.client.decryptData(alias, encryptedData, algorithm, pin);
        if (this.controller.parseResponse((Response)decryptDataResponse)) {
            return decryptDataResponse.getResult();
        }
        return null;
    }

    @Override
    public TokenInfo getTokenInfo() {
        TokenInfo info = null;
        return info;
    }

    @Override
    public int[] getCertificateCounts() {
        return new int[]{100, 100};
    }

    @Override
    public LinkedList<X509Certificate> getCertificates() {
        this.checkLogin();
        ResponseGetCertificates certificatesResponse = this.client.getCertificates();
        if (this.controller.parseResponse((Response)certificatesResponse)) {
            return certificatesResponse.getResult();
        }
        return null;
    }

    @Override
    public boolean canGenerateCertificateCount(int count2048) {
        return count2048 < 100;
    }

    @Override
    public X509Certificate[] convertCertificateArraytoX509CertificateArray(Certificate[] certArray) {
        if (certArray instanceof X509Certificate[]) {
            return (X509Certificate[])certArray;
        }
        X509Certificate[] result = new X509Certificate[certArray.length];
        if (this.isAllItemInstanceOfX509Certificate(certArray)) {
            for (int i = 0; i < certArray.length; ++i) {
                result[i] = (X509Certificate)certArray[i];
            }
        }
        return result;
    }

    @Override
    public boolean isAllItemInstanceOfX509Certificate(Certificate[] certArray) {
        boolean result = true;
        for (int i = 0; i < certArray.length; ++i) {
            if (certArray[i] instanceof X509Certificate) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public String getPrPath() {
        return this.userId;
    }

    @Override
    public PrivateKey getPrivateKey2(String alias) {
        throw new UnsupportedOperationException("getPrivateKey2 not supported");
    }

    @Override
    public KeyPair _generateKeyPair(int keySize) {
        throw new UnsupportedOperationException("_generateKeyPair not supported");
    }

    @Override
    public SecretKey generateSecretKey(int byteLength) throws NOPINException, PINLOCKEDException {
        try {
            AgregarProveedor.agregarBouncyCastleProvider();
            Provider provider = Security.getProvider("BC");
            KeyGenerator keygen = KeyGenerator.getInstance("AES", provider);
            keygen.init(byteLength * 8);
            keygen.init(new SecureRandom());
            SecretKey secretKey = keygen.generateKey();
            return secretKey;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public X509Certificate createCertAndKeyPair(String alias, X500Name x500Name, BigInteger serialCert, Date notBefore, Date notAfter, int keySize, char[] pass) throws PINLOCKEDException {
        throw new UnsupportedOperationException("createCertAndKeyPair not supported");
    }

    @Override
    public USB getUSB() {
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        throw new UnsupportedOperationException("getPrivateKey not supported");
    }

    @Override
    public PrivateKey getPrivateKey(String alias, char[] pin) {
        throw new UnsupportedOperationException("getPrivateKey not supported");
    }

    @Override
    public boolean containsAlias(String alias) {
        Enumeration<String> aliases = this.getAlias();
        while (aliases.hasMoreElements()) {
            String aliasi = aliases.nextElement();
            if (!aliasi.equals(alias)) continue;
            return true;
        }
        return false;
    }

    public LockerImpl getLocker() {
        return LockerImpl.get((String)("centralizados-" + this.getSerialNumberToken()));
    }

    @Override
    public char[] getPIN(String alias) {
        throw new UnsupportedOperationException("getPIN not supported");
    }

    @Override
    public AuthInfoImpl getCounterInfo(String alias) {
        this.checkLogin();
        ResponseGetCounterInfo counterInfoResponse = this.client.getCounterInfo(alias);
        if (this.controller.parseResponse((Response)counterInfoResponse)) {
            return new AuthInfoImpl(counterInfoResponse.getPinCounter(), counterInfoResponse.getPukCounter(), this.getSerialNumberToken(), counterInfoResponse.getPinEnc(), 10, 5);
        }
        return null;
    }

    @Override
    public String getName() {
        return "ANF-Centralized-Token";
    }

    @Override
    public boolean unlockPIN(UnlockPINParams params) {
        char[] puk;
        X509Certificate[] chain;
        X509Certificate cert;
        char[] newPin;
        this.checkLogin();
        String code = params.getCode();
        String alias = params.getAlias();
        if (code == null) {
            code = this.getVerificationCode(alias);
        }
        if ((newPin = params.getNewPin()) == null && (cert = (chain = this.getCertificateChain(alias))[CertUtils.getFinalCert((X509Certificate[])chain)]) != null) {
            String subject = CertUtils.getSubjectCN((X509Certificate)cert);
            String id = this.getKeyBoardId(alias) + "new-pin";
            newPin = KeyBoardHandler.getPasswordForCertificates(id, chain, Confis.get().getString("inputPINCert", subject, this.userId), true, false, this.getAuthHandler(new Object[0]));
        }
        if ((puk = params.getPuk()) == null) {
            String id = this.getKeyBoardId(alias) + "new-puk";
            puk = KeyBoardHandler.getPassword(id, Confis.get().getString("247-PUK", new Object[0]), true, true, this.getAuthHandler(new Object[0]));
        }
        if (code != null && newPin != null && puk != null) {
            ResponseBoolean unlockPINResponse = this.client.unlockPIN(alias, puk, newPin, code);
            return this.controller.parseResponse((Response)unlockPINResponse);
        }
        return false;
    }

    @Override
    public boolean initUserPIN(String alias, String certSerialNumber, char[] pukArray, char[] pinArray) {
        this.checkLogin();
        ResponseBoolean initUserPINRresponse = this.client.initUserPIN(alias, certSerialNumber, pukArray, pinArray);
        return this.controller.parseResponse((Response)initUserPINRresponse);
    }

    @Override
    public String getNewValidAlias(X500Name x500Name) {
        String alias = String.valueOf((int)(Math.random() * 100000.0));
        while (this.containsAlias(alias)) {
            alias = String.valueOf((int)(Math.random() * 100000.0));
        }
        return alias;
    }

    @Override
    public List<String> importPFX(File pfx, char[] password) {
        ArrayList<String> aliasesOK = new ArrayList<String>();
        try {
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            try (FileInputStream in = new FileInputStream(pfx);){
                store.load(in, password);
            }
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] chain = store.getCertificateChain(alias);
                X509Certificate[] x509 = CertUtils.toX509((Certificate[])chain);
                Key key = store.getKey(alias, password);
                X509Certificate[] builtChain = x509;
                builtChain = CertUtils.buildChain((X509Certificate[])builtChain);
                if (key == null || builtChain == null || builtChain.length <= 0) continue;
                String title = Confis.get().getString("insertPUK", new Object[0]);
                String id = this.getKeyBoardId(alias) + "-puk";
                char[] puk = KeyBoardHandler.getPassword(id, title, false, false, this.getAuthHandler(alias));
                if (!this.controller.uploadPFX(pfx, new String(password), new String(puk))) continue;
                aliasesOK.add(alias);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException e) {
            throw new ANFCentralServerError("ERR_IMPORT_PFX", (Throwable)e);
        }
        return aliasesOK;
    }

    public String getPass() {
        return this.pass;
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public boolean accept(ProfilePolicy profile) {
        return profile.name().contains("Central");
    }

    public boolean isHSM() {
        return true;
    }

    @Override
    public Signature getSignatureInstance(String signAlg) {
        return UtilsPki.getSignature(signAlg, this.getProvider());
    }

    @Override
    public boolean isSignatureStore() {
        return true;
    }

    @Override
    public void saveKeyPairInStore(String title, String alias, X509Certificate[] certChain, PrivateKey privKey, int keySize) {
    }

    @Override
    protected void checkWriteSupported() {
    }

    @Override
    protected KeyPair generateKeyPair(int keySize) {
        throw new UnsupportedOperationException("REMOTE_GEN_KEY_PAIR");
    }

    @Override
    protected String getImportTitle(String alias) {
        String title = Confis.get().getString("importAlias", new Object[0]) + Confis.get().getString("importAliasCentral", new Object[0]);
        return title;
    }

    @Override
    public void saveStore() {
    }
}

