/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.api.tkmanager.params.UnlockPINParams;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.AuthInfoImpl;
import com.anf.cryptotoken.tkmanager.RemoteHandler;
import com.anf.cryptotoken.tkmanager.TKManagerAbstractStore;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.usb.USB;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x500.X500Name;

public final class TKManagerPFXRemote
extends TKManagerAbstractStore {
    private RemoteHandler handler;
    private String clientId;
    private String password;
    private Map<String, X509Certificate[]> cachedMap = null;

    public TKManagerPFXRemote(String clientId, String password, RemoteHandler handler) {
        this.handler = handler;
        this.clientId = clientId;
        this.password = password;
        handler.init(clientId, password);
    }

    public void setHandler(RemoteHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getSerialNumberToken() {
        return this.clientId;
    }

    @Override
    public Enumeration<String> getAlias() {
        this.getCachedMap();
        return Collections.enumeration(this.cachedMap.keySet());
    }

    private void getCachedMap() {
        if (this.cachedMap == null || this.cachedMap.isEmpty()) {
            this.cachedMap = this.handler.getAliases();
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        this.getCachedMap();
        return this.cachedMap.get(alias);
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm) {
        return this.handler.signData(alias, data, signAlgorithm, this.password.toCharArray());
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm, char[] pin) {
        return this.handler.signData(alias, data, signAlgorithm, this.password.toCharArray());
    }

    @Override
    public Provider getProvider() {
        return Security.getProvider("BC");
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        X509Certificate[] chain = this.getCertificateChain(alias);
        int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
        if (finalCert != -1) {
            return chain[finalCert];
        }
        return null;
    }

    @Override
    public boolean verifyData(String alias, byte[] data, byte[] signedData, String signAlgorithm) {
        return UtilsPki.verifyData(data, signedData, this.getCertificate(alias).getPublicKey(), signAlgorithm, this.getProvider());
    }

    @Override
    public void importCertificate(String alias, X509Certificate[] certs) {
    }

    @Override
    public void removeCertificate(String alias) {
    }

    @Override
    public KeyStore getKeyStore() {
        return null;
    }

    @Override
    public KeyPair getKeyPair(String alias) {
        return null;
    }

    @Override
    public KeyPair getKeyPair(String alias, char[] pin) {
        return null;
    }

    @Override
    public X509Certificate[] convertCertificateArraytoX509CertificateArray(Certificate[] certArray) {
        return CertUtils.toX509((Certificate[])certArray);
    }

    @Override
    public boolean isAllItemInstanceOfX509Certificate(Certificate[] certArray) {
        boolean result = true;
        for (int i = 0; i < certArray.length; ++i) {
            if (certArray[i] instanceof X509Certificate) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public String getPrPath() {
        return null;
    }

    @Override
    public PrivateKey getPrivateKey2(String alias) {
        return null;
    }

    @Override
    public SecretKey generateSecretKey(int byteLength) {
        try {
            return UtilsPki.generateSecretKey(byteLength);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public X509Certificate createCertAndKeyPair(String alias, X500Name x500Name, BigInteger serialCert, Date notBefore, Date notAfter, int keySize, char[] pass) throws PINLOCKEDException {
        return null;
    }

    @Override
    public USB getUSB() {
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias, char[] pin) {
        return null;
    }

    @Override
    public boolean containsAlias(String alias) {
        return false;
    }

    public LockerImpl getLocker() {
        return LockerImpl.get((String)"pfx-remote");
    }

    @Override
    public char[] getPIN(String alias) {
        return null;
    }

    @Override
    public AuthInfoImpl getCounterInfo(String alias) {
        return null;
    }

    @Override
    public String getName() {
        return "PFX-REMOTE";
    }

    @Override
    public boolean unlockPIN(UnlockPINParams params) {
        return false;
    }

    @Override
    public boolean initUserPIN(String alias, String certSerialNumber, char[] pukArray, char[] pinArray) {
        return false;
    }

    @Override
    public String getNewValidAlias(X500Name x500Name) {
        return null;
    }

    @Override
    public List<String> importPFX(File pfx, char[] password) {
        throw new ANFKeyStoreException("ERR_OPERATION_NOT_SUPPORTED");
    }

    @Override
    public boolean accept(ProfilePolicy profile) {
        return true;
    }

    public boolean isHSM() {
        return false;
    }

    @Override
    public void saveStore() {
    }

    @Override
    protected boolean writeSupported() {
        return true;
    }

    @Override
    public boolean isSignatureStore() {
        return true;
    }

    @Override
    public void reloadToken() {
    }

    @Override
    public void resetToken() {
    }

    @Override
    public boolean changePIN(String alias) {
        return false;
    }

    @Override
    public boolean changePIN(String alias, char[] old, char[] newPIN, char[] newPuk) {
        return false;
    }

    @Override
    public boolean canGenerateCertificateCount(int count2048) {
        return false;
    }

    @Override
    public KeyPair _generateKeyPair(int keySize) {
        return null;
    }

    @Override
    protected KeyPair generateKeyPair(int keySize) {
        return null;
    }

    @Override
    protected String getImportTitle(String alias) {
        String title = Confis.get().getString("importAlias", new Object[0]) + alias + Confis.get().getString("importAliasPFX", new Object[0]) + this.getName();
        return title;
    }
}

