/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.api.tkmanager.exception.PFXStoreException;
import com.anf.cryptotoken.api.tkmanager.params.UnlockPINParams;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.AuthInfoImpl;
import com.anf.cryptotoken.tkmanager.TKManagerAbstractStore;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.encoders.Hex;

public class TKManagerPFX
extends TKManagerAbstractStore {
    private static final Logger log = Logger.getLogger(TKManagerPFX.class);
    private File pfxFile;
    private String serial = null;
    private boolean canWrite = false;

    public TKManagerPFX(File pfxFile, char[] pass) {
        this.set(pfxFile, pass);
    }

    public TKManagerPFX(InputStream pfx, char[] pass) {
        this.set(pfx, pass);
    }

    private void set(InputStream pfx, char[] pass) {
        this.pass = pass;
        try {
            this.store = KeyStore.getInstance("PKCS12", "BC");
            this.store.load(pfx, pass);
            this.canWrite = true;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.store.store(out, pass);
            MessageDigest dig = MessageDigest.getInstance("SHA256");
            byte[] digest = dig.digest(out.toByteArray());
            this.serial = new String(Hex.encode((byte[])digest));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new PFXStoreException("ERR_PFX_LOAD_STORE", (Throwable)e);
        }
    }

    public void set(File pfxFile, char[] pass) {
        this.pfxFile = pfxFile;
        this.pass = pass;
        try {
            this.store = KeyStore.getInstance("PKCS12", "BC");
            if (!pfxFile.exists() || pfxFile.length() == 0L) {
                log.info((Object)("PFX " + pfxFile.getName() + " no existe, creando el archivo..."));
                this.store.load(null, pass);
                try (FileOutputStream out = new FileOutputStream(pfxFile);){
                    this.store.store(out, pass);
                }
            }
            log.info((Object)("archivo PFX " + pfxFile.getName() + " existe. cargando..."));
            try (FileInputStream in = new FileInputStream(pfxFile);){
                this.store.load(in, pass);
            }
            log.info((Object)("archivo PFX " + pfxFile.getName() + " cargado"));
            this.canWrite = true;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new PFXStoreException("ERR_LOAD_PFX_STORE", (Throwable)e);
        }
    }

    @Override
    public void reloadToken() {
        throw new UnsupportedOperationException("use set(File,char[]) method instead");
    }

    @Override
    public void resetToken() {
        throw new UnsupportedOperationException("use set(File,char[]) method instead");
    }

    @Override
    public boolean changePIN(String alias) {
        X509Certificate[] chain = this.getCertificateChain(alias);
        X509Certificate cert = chain[CertUtils.getFinalCert((X509Certificate[])chain)];
        if (cert != null) {
            char[] old = null;
            String subject = CertUtils.getSubjectCN((X509Certificate)cert);
            String deviceSerial = this.getSerialNumberToken();
            try {
                String id = this.getKeyBoardId(alias) + "-old-pin";
                old = KeyBoardHandler.getPassword(id, Confis.get().getString("inputOldPINCert", subject, deviceSerial), false, false, null);
                id = this.getKeyBoardId(alias) + "-new-pin";
                char[] newPIN = KeyBoardHandler.getPassword(id, Confis.get().getString("inputPINCert", subject, deviceSerial), true, false, null);
                boolean ok = this.changePIN(alias, old, newPIN, null);
                this.saveStore();
                return ok;
            }
            catch (NOPINException e) {
                KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                throw e;
            }
        }
        return false;
    }

    @Override
    protected String getKeyBoardId(String alias) {
        String id = this.getSerialNumberToken() + "-" + alias;
        if (this.getUSB() != null) {
            id = id + this.getUSB();
        }
        return id;
    }

    @Override
    public boolean changePIN(String aliasIgnore, char[] old, char[] newPIN, char[] newpuk) {
        try {
            if (old == null || newPIN == null) {
                throw new FailedLoginException("ERR_NULL_PIN_PARAMETER");
            }
            boolean result = false;
            KeyStore newStore = KeyStore.getInstance("PKCS12", "BC");
            newStore.load(null, null);
            Enumeration<String> aliases = this.store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] chain = this.store.getCertificateChain(alias);
                Key key = this.store.getKey(alias, old);
                newStore.setKeyEntry(alias, key, newPIN, chain);
            }
            if (this.pfxFile != null) {
                FileOutputStream out = new FileOutputStream(this.pfxFile);
                newStore.store(out, newPIN);
                out.close();
                this.store = KeyStore.getInstance("PKCS12", "BC");
                try (FileInputStream in = new FileInputStream(this.pfxFile);){
                    this.store.load(in, newPIN);
                }
            } else {
                this.store = newStore;
            }
            result = true;
            Enumeration<String> aliases2 = this.store.aliases();
            while (result && aliases2.hasMoreElements()) {
                String alias = aliases2.nextElement();
                Certificate cert = this.store.getCertificate(alias);
                Key key = this.store.getKey(alias, newPIN);
                if (cert != null && key != null) continue;
                result = false;
            }
            if (result) {
                this.pass = newPIN;
            }
            return result;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException | FailedLoginException e) {
            throw new ANFKeyStoreException("ERR_CHANGE_PIN", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerialNumberToken() {
        if (this.serial != null) {
            return this.serial;
        }
        if (this.pfxFile != null && this.pfxFile.exists()) {
            FileInputStream in = null;
            try {
                MessageDigest dig = MessageDigest.getInstance("SHA256");
                in = new FileInputStream(this.pfxFile);
                byte[] digest = dig.digest(IOUtils.toByteArray((InputStream)in));
                String string = this.serial = new String(Hex.encode((byte[])digest));
                return string;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                log.error((Object)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        return this.serial;
    }

    @Override
    protected boolean writeSupported() {
        return this.canWrite;
    }

    @Override
    public void saveStore() {
        try {
            if (this.pfxFile != null && this.pfxFile.exists()) {
                this.checkWriteSupported();
                log.info((Object)("actualizando store en PFX " + this.pfxFile.getName()));
                FileOutputStream out = new FileOutputStream(this.pfxFile);
                this.store.store(out, this.pass);
                out.close();
                log.info((Object)("PFX " + this.pfxFile.getName() + " actualizado"));
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error((Object)e);
        }
    }

    @Override
    public boolean canGenerateCertificateCount(int count2048) {
        return true;
    }

    @Override
    public X509Certificate[] convertCertificateArraytoX509CertificateArray(Certificate[] certArray) {
        return CertUtils.toX509((Certificate[])certArray);
    }

    @Override
    public boolean isAllItemInstanceOfX509Certificate(Certificate[] certArray) {
        boolean result = true;
        for (int i = 0; i < certArray.length; ++i) {
            if (certArray[i] instanceof X509Certificate) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public String getPrPath() {
        return this.pfxFile.getAbsolutePath();
    }

    @Override
    public PrivateKey getPrivateKey2(String alias) {
        return null;
    }

    @Override
    public KeyPair _generateKeyPair(int keySize) {
        return this.generateKeyPair(keySize);
    }

    @Override
    public USB getUSB() {
        return null;
    }

    public LockerImpl getLocker() {
        if (this.pfxFile != null) {
            return LockerImpl.get((String)("pfx-" + this.pfxFile.getName()));
        }
        return LockerImpl.get((String)("pfx-" + this.serial));
    }

    @Override
    public char[] getPIN(String alias) {
        return this.pass;
    }

    @Override
    public AuthInfoImpl getCounterInfo(String alias) {
        return new AuthInfoImpl(0, 0, null, null, 3, 3);
    }

    @Override
    public String getName() {
        return "PFX";
    }

    @Override
    public boolean unlockPIN(UnlockPINParams params) {
        return false;
    }

    @Override
    public boolean initUserPIN(String alias, String certSerialNumber, char[] pukArray, char[] pinArray) {
        return false;
    }

    public File getPfxFile() {
        return this.pfxFile;
    }

    @Override
    public String getNewValidAlias(X500Name x500Name) {
        String alias = String.valueOf((int)(Math.random() * 100000.0));
        while (this.containsAlias(alias)) {
            alias = String.valueOf((int)(Math.random() * 100000.0));
        }
        return alias;
    }

    @Override
    public boolean accept(ProfilePolicy profile) {
        return true;
    }

    public boolean isHSM() {
        return false;
    }

    @Override
    public boolean isSignatureStore() {
        return true;
    }

    @Override
    protected String getImportTitle(String alias) {
        String title = Confis.get().getString("importAlias", new Object[0]) + Confis.get().getString("importAliasPFX", new Object[0]) + this.getName();
        return title;
    }

    static {
        AgregarProveedor.agregarBouncyCastleProvider();
    }
}

