/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.json.TrayIconUserLogin;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.server.CentralServerController;
import com.anf.cryptotoken.server.TrayIconClient;
import com.anf.cryptotoken.tkmanager.ManagerType;
import com.anf.cryptotoken.tkmanager.PKCS11ModuleFactory;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManager;
import com.anf.cryptotoken.tkmanager.TKManagerANFP11;
import com.anf.cryptotoken.tkmanager.TKManagerAbstract;
import com.anf.cryptotoken.tkmanager.TKManagerBit4id;
import com.anf.cryptotoken.tkmanager.TKManagerCritAcces;
import com.anf.cryptotoken.tkmanager.TKManagerDNI;
import com.anf.cryptotoken.tkmanager.TKManagerIDEMIA;
import com.anf.cryptotoken.tkmanager.TKManagerLinuxST;
import com.anf.cryptotoken.tkmanager.TKManagerPKCS11;
import com.anf.cryptotoken.tkmanager.TKManagerRemote;
import com.anf.cryptotoken.tkmanager.TKManagerSMI;
import com.anf.cryptotoken.tkmanager.TKManagerST;
import com.anf.cryptotoken.tkmanager.TKManagerSafeNet;
import com.anf.cryptotoken.tkmanager.TKManagerServerST;
import com.anf.cryptotoken.tkmanager.TKManagerVaultP11;
import com.anf.cryptotoken.tkmanager.TKManagerWindows;
import com.anf.cryptotoken.tkmanager.token.ANFToken;
import com.anf.cryptotoken.tkmanager.token.ANFTokenFactory;
import com.anf.cryptotoken.tkmanager.token.detect.impl.CardDetector;
import com.anf.cryptotoken.tkmanager.token.detect.impl.USBDetector;
import com.anf.cryptotoken.tkmanager.utils.Utils;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.USBFactory;
import com.anf.cryptotoken.usb.impl.LinuxUSBController;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.P11Manager;
import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.utils.OSUtils;
import com.anf.utils.SerialUtils;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.util.encoders.Hex;

public class TKManagerFactory {
    private static final Logger log = Logger.getLogger(TKManagerFactory.class);
    protected static TreeSet<String> serialLocked = new TreeSet();
    private CentralServerController centralServerController;
    private CardDetector cardDetector;

    public TKManagerFactory(CentralServerController centralServerController) {
        this.centralServerController = centralServerController;
    }

    public TKManagerFactory(CentralServerController centralServerController, CardDetector cardDetector) {
        this.centralServerController = centralServerController;
        this.cardDetector = cardDetector;
    }

    public TKManager[] getTKManagers(ManagerType type) {
        log.info((Object)("TKManagerFactory.getTKManagers(" + type.name() + ")"));
        TKManager[] m = new TKManager[]{};
        try {
            switch (type) {
                case P11_VAULT: {
                    if (OSUtils.isWindows()) {
                        m = this.getP11Managers(PKCS11Type.VAULT_HSM);
                    }
                    break;
                }
                case P11_ANF: {
                    if (OSUtils.isWindows()) {
                        m = this.getP11Managers(PKCS11Type.ANFP11);
                    }
                    break;
                }
                case P11_ST: {
                    if (OSUtils.isWindows()) {
                        m = this.getP11Managers(PKCS11Type.ST);
                        break;
                    }
                    if (OSUtils.isLinux()) {
                        m = this.getSTLinuxManagers(null, null, false);
                    }
                    break;
                }
                case P11_BIT4ID: {
                    if (OSUtils.isWindows()) {
                        m = this.getP11Managers(PKCS11Type.Bit4id);
                        break;
                    }
                    if (OSUtils.isLinux()) {
                        m = this.getSTLinuxManagers(null, null, false);
                    }
                    break;
                }
                case P11_SAFENET: {
                    if (OSUtils.isWindows()) {
                        m = this.getP11Managers(PKCS11Type.SafeNet);
                    }
                    break;
                }
                case P11_DNI: {
                    if (OSUtils.isWindows()) {
                        m = this.getP11Managers(PKCS11Type.DNI);
                    }
                    break;
                }
                case P11_IDEMIA: {
                    if (OSUtils.isWindows()) {
                        m = this.getP11Managers(PKCS11Type.IDEMIA);
                    }
                    break;
                }
                case PLUGSIGN: {
                    m = TKManagerFactory.getPSManagers();
                    break;
                }
                case SMI: {
                    if (OSUtils.isWindows()) {
                        m = this.getSMIManagers();
                    }
                    break;
                }
                case WINDOWS: {
                    if (OSUtils.isWindows()) {
                        m = this.getWindowsManager();
                    }
                    break;
                }
                case SERVER: {
                    m = this.getRemoteManager();
                    break;
                }
                default: {
                    throw new KeyStoreException(Confis.get().getString("46", new Object[0]));
                }
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)e);
        }
        return m;
    }

    public TKManagerAbstract[] getWindowsManager() {
        TKManagerAbstract[] m = new TKManagerAbstract[]{TKManagerWindows.get()};
        return m;
    }

    public TKManagerAbstract[] updateWindowsManager() {
        TKManagerAbstract[] m = new TKManagerAbstract[]{TKManagerWindows.get()};
        try {
            m[0].reloadToken();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return m;
    }

    public TKManager[] getRemoteManager() {
        TKManager[] m = new TKManager[]{};
        try {
            TKManagerRemote remoteInstance = this.getTrayIconInstance();
            if (remoteInstance != null) {
                m = new TKManager[]{remoteInstance};
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return m;
    }

    private TKManager[] updateRemoteManager(TKManager[] managers) {
        TKManager previous = null;
        if (managers != null && managers.length == 1 && (managers[0] == null || managers[0] instanceof TKManagerRemote)) {
            previous = managers[0];
        }
        TKManager[] update = new TKManager[]{this.updateTrayIconInstance((TKManagerRemote)previous, this.centralServerController)};
        return update;
    }

    public TKManager[] updateSMIManagers(Map<String, TKManager> map, TKManager[] managers) throws Exception {
        ArrayList<TKManager> list;
        AgregarProveedor.agregarBouncyCastleProvider();
        try (LockerImpl locker = LockerImpl.get((String)"smi").acquireLock();){
            ArrayList<USB> usbs = TKManagerSMI.listUSBs();
            list = new ArrayList<TKManager>(usbs.size());
            for (USB usb : usbs) {
                if (!TKManagerSMI.link.checkReservFileExist(usb.getLetter(), "appmgmts.dll")) continue;
                try {
                    TKManager to = map.get(usb.getUUID());
                    if (to == null) {
                        list.add(new TKManagerSMI(usb, "appmgmts.dll"));
                        continue;
                    }
                    list.add(to);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        return list.toArray(new TKManagerSMI[list.size()]);
    }

    public TKManager[] updateTKManagers(TKManager[] managers, ManagerType type) throws Exception {
        TreeMap<String, TKManager> map = new TreeMap<String, TKManager>();
        for (int i = 0; i < managers.length; ++i) {
            if (managers[i] == null || managers[i].getSerialNumberToken() == null) continue;
            map.put(managers[i].getSerialNumberToken(), managers[i]);
        }
        TKManager[] m = null;
        switch (type) {
            case P11_VAULT: {
                if (!OSUtils.isWindows()) break;
                m = this.updateP11Managers(map, managers, PKCS11Type.VAULT_HSM);
                break;
            }
            case P11_ANF: {
                if (!OSUtils.isWindows()) break;
                m = this.updateP11Managers(map, managers, PKCS11Type.ANFP11);
                break;
            }
            case P11_ST: {
                if (OSUtils.isWindows()) {
                    m = this.updateP11Managers(map, managers, PKCS11Type.ST);
                    break;
                }
                if (!OSUtils.isLinux()) break;
                m = this.getSTLinuxManagers();
                break;
            }
            case P11_BIT4ID: {
                if (!OSUtils.isWindows()) break;
                m = this.updateP11Managers(map, managers, PKCS11Type.Bit4id);
                break;
            }
            case P11_SAFENET: {
                if (!OSUtils.isWindows()) break;
                m = this.updateP11Managers(map, managers, PKCS11Type.SafeNet);
                break;
            }
            case P11_DNI: {
                if (!OSUtils.isWindows()) break;
                m = this.updateP11Managers(map, managers, PKCS11Type.DNI);
                break;
            }
            case P11_IDEMIA: {
                if (!OSUtils.isWindows()) break;
                m = this.updateP11Managers(map, managers, PKCS11Type.IDEMIA);
                break;
            }
            case PLUGSIGN: {
                m = this.updatePSManagers(map, managers);
                break;
            }
            case SMI: {
                if (!OSUtils.isWindows()) break;
                m = this.updateSMIManagers(map, managers);
                break;
            }
            case WINDOWS: {
                if (!OSUtils.isWindows()) break;
                m = this.updateWindowsManager();
                break;
            }
            case SERVER: {
                m = this.updateRemoteManager(managers);
                break;
            }
            default: {
                throw new KeyStoreException(Confis.get().getString("46", new Object[0]));
            }
        }
        return m;
    }

    public TKManagerSMI[] getSMIManagers() {
        AgregarProveedor.agregarBouncyCastleProvider();
        try (LockerImpl locker = LockerImpl.get((String)"smi").acquireLock();){
            ArrayList<USB> usbs = TKManagerSMI.listUSBs();
            ArrayList<TKManagerSMI> list = new ArrayList<TKManagerSMI>(usbs.size());
            for (USB usb : usbs) {
                if (!TKManagerSMI.link.checkReservFileExist(usb.getLetter(), "appmgmts.dll")) continue;
                try {
                    TKManagerSMI t = new TKManagerSMI(usb, "appmgmts.dll");
                    list.add(t);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            TKManagerSMI[] tKManagerSMIArray = list.toArray(new TKManagerSMI[list.size()]);
            return tKManagerSMIArray;
        }
    }

    public static TKManagerCritAcces[] getPSManagers() {
        AgregarProveedor.agregarBouncyCastleProvider();
        ArrayList<USB> usbs = TKManagerFactory.listUSBs();
        ArrayList<TKManagerCritAcces> list = new ArrayList<TKManagerCritAcces>(usbs.size());
        log.info((Object)("TKManagerCritAcces.getManagers() usb list.size=" + list.size()));
        for (USB usb : usbs) {
            TKManagerCritAcces t;
            log.info((Object)("TKManagerCritAcces.getManagers() usb=" + usb.getLetter() + ", serial=" + usb.getUUID()));
            File f = new File(usb.getMountPoint(), TKManagerCritAcces.RUTA_CA);
            boolean ok = false;
            if (f.exists()) {
                try {
                    t = new TKManagerCritAcces(usb, f);
                    ok = list.add(t);
                }
                catch (Exception e) {
                    ok = false;
                    log.error((Object)e);
                }
            }
            if (ok || !(f = new File(usb.getMountPoint(), TKManagerCritAcces.RUTA_PS)).exists()) continue;
            try {
                t = new TKManagerCritAcces(usb, f);
                ok = list.add(t);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return list.toArray(new TKManagerCritAcces[list.size()]);
    }

    public TKManager[] updatePSManagers(Map<String, TKManager> map, TKManager[] managers) {
        AgregarProveedor.agregarBouncyCastleProvider();
        ArrayList<USB> usbs = TKManagerFactory.listUSBs();
        ArrayList<TKManager> list = new ArrayList<TKManager>(usbs.size());
        for (USB usb : usbs) {
            TKManager to;
            File f = new File(usb.getMountPoint(), TKManagerCritAcces.RUTA_CA);
            boolean ok = false;
            if (f.exists()) {
                try {
                    to = map.get(usb.getUUID());
                    ok = to == null ? list.add(new TKManagerCritAcces(usb, f)) : list.add(to);
                }
                catch (Exception e) {
                    ok = false;
                    log.error((Object)e);
                }
            }
            if (ok || !(f = new File(usb.getMountPoint(), TKManagerCritAcces.RUTA_PS)).exists()) continue;
            try {
                to = map.get(usb.getUUID());
                if (to == null) {
                    ok = list.add(new TKManagerCritAcces(usb, f));
                    continue;
                }
                ok = list.add(to);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return list.toArray(new TKManagerCritAcces[list.size()]);
    }

    public static ArrayList<USB> listUSBs() {
        ArrayList usbs = new ArrayList();
        if (Utils.isWindowsOS()) {
            File[] roots = File.listRoots();
            for (int i = 0; i < roots.length; ++i) {
                String absolutePath = roots[i].getAbsolutePath();
                if (!USBDetector.isUSB(roots[i])) continue;
                try {
                    String serial = SerialUtils.getSerialNumber((String)absolutePath);
                    usbs.add(USBFactory.newUSB((String)absolutePath, (String)serial));
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        } else {
            LinuxUSBController manejadorUSBs = new LinuxUSBController();
            usbs = manejadorUSBs.getUSBUnits();
        }
        return usbs;
    }

    public TKManagerPKCS11 getTKManagerPKCS11(int token, PKCS11Type type) throws KeyStoreException, IOException {
        P11Manager p11 = PKCS11ModuleFactory.getP11(type);
        long[] slots = p11.GetSlotList(true);
        try (Locker locker = TKManagerPKCS11.getLocker(type).acquireLock();){
            TKManagerPKCS11 tKManagerPKCS11 = this.getPKCS11Instance(p11, type, slots[token]);
            return tKManagerPKCS11;
        }
    }

    public TKManagerPKCS11[] getP11Managers(PKCS11Type type) {
        log.info((Object)("TKManagerFactory.getP11Managers(" + type.name() + ")"));
        TKManagerPKCS11[] m = new TKManagerPKCS11[]{};
        if (this.cardDetector != null && !this.cardDetector.isCardConnected(type)) {
            log.debug((Object)("no hay tarjetas de " + type + " conectadas"));
            return m;
        }
        ArrayList<TKManagerPKCS11> mlist = null;
        long[] slots = null;
        CK_SLOT_INFO[] slotInfos = null;
        CK_TOKEN_INFO[] tokenInfos = null;
        P11Manager p11 = PKCS11ModuleFactory.getP11(type);
        try (Locker locker = TKManagerPKCS11.getLocker(type).acquireLock();){
            try (LockerImpl smartCardLock = CardDetector.acquireLock();){
                log.info((Object)("finalize p11 " + type));
                p11.finalizeP11();
                log.info((Object)("initialize p11 " + type));
                p11.initialize();
                log.info((Object)("listando slots de " + type.name()));
                TimeUnit.SECONDS.sleep(5L);
                slots = p11.GetSlotList(true);
                log.info((Object)("slots de " + type.name() + ": " + slots.length));
                slotInfos = new CK_SLOT_INFO[slots.length];
                tokenInfos = new CK_TOKEN_INFO[slots.length];
                for (int i = 0; i < slots.length; ++i) {
                    log.info((Object)("get slotInfo de " + type.name() + " [" + i + "]"));
                    slotInfos[i] = p11.getSlotInfo(slots[i]);
                    String slotDesc = new String(slotInfos[i].slotDescription);
                    log.info((Object)("slotInfo de " + type.name() + " [" + i + "] = " + slotDesc));
                    if (!TKManagerFactory.acceptTokenDescription(type, slotDesc)) continue;
                    try {
                        tokenInfos[i] = p11.getTokenInfo(slots[i]);
                        continue;
                    }
                    catch (PKCS11Exception | Error e) {
                        log.warn((Object)("se ignora el token de " + type + " slot " + slots[i]));
                    }
                }
            }
            catch (Exception e) {
                p11.finalizeP11();
                throw e;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (slots != null) {
            mlist = new ArrayList<TKManagerPKCS11>(slots.length);
            for (int i = 0; i < slots.length; ++i) {
                if (slotInfos[i] == null) continue;
                void slot = slots[i];
                log.info((Object)((long)slot));
                try {
                    String serial;
                    void c_GetSlotInfo = slotInfos[i];
                    String slotDesc = new String(c_GetSlotInfo.slotDescription);
                    if (!TKManagerFactory.acceptTokenDescription(type, slotDesc) || tokenInfos[i] == null) continue;
                    log.info((Object)("slot " + (long)slot + " con descripcion: " + slotDesc + " Aceptado para el tipo: " + type.name()));
                    CK_TOKEN_INFO tokenInfo = tokenInfos[i];
                    if (!TKManagerFactory.acceptTokenInfo(type, tokenInfo) || serialLocked.contains(serial = Hex.toHexString((byte[])tokenInfo.getSerialNumber()))) continue;
                    String str = slotDesc;
                    int id = str.indexOf("|id=");
                    if (id != -1) {
                        String sid = str.substring(id + 4);
                        log.info((Object)sid);
                    }
                    try {
                        mlist.add(this.getPKCS11Instance(p11, type, (long)slot));
                    }
                    catch (PINLOCKEDException e) {
                        log.error((Object)e);
                        serialLocked.add(serial);
                    }
                    catch (KeyStoreException e) {
                        log.error((Object)e);
                    }
                    continue;
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
        }
        if (mlist != null) {
            ArrayList<USB> usbs;
            m = new TKManagerPKCS11[mlist.size()];
            mlist.toArray(m);
            if (type == PKCS11Type.VAULT_HSM && m.length > 0 && (usbs = TKManagerSMI.listUSBs()).size() == m.length) {
                for (int j = 0; j < m.length; ++j) {
                    ((TKManagerVaultP11)m[j]).setLetterUnit(usbs.get(j).getMountPoint());
                }
            }
        }
        return m;
    }

    protected static boolean acceptTokenInfo(PKCS11Type type, CK_TOKEN_INFO tokenInfo) {
        switch (type) {
            case ANFP11: {
                return true;
            }
            case VAULT_HSM: {
                return true;
            }
            case Bit4id: {
                return true;
            }
            case ST: {
                return true;
            }
            case DNI: {
                return new String(tokenInfo.getLabel()).contains("DNI");
            }
            case IDEMIA: {
                return new String(tokenInfo.getManufacturerID()).contains("IDEMIA") && new String(tokenInfo.getLabel()).contains("PKI Application");
            }
            case SafeNet: {
                return true;
            }
        }
        return false;
    }

    protected static boolean acceptTokenDescription(PKCS11Type type, String slotDesc) {
        switch (type) {
            case ANFP11: {
                return slotDesc.contains("HSM Plug & Sign") || slotDesc.contains("eSign ANF AC");
            }
            case VAULT_HSM: {
                return slotDesc.contains("VaultIC") || slotDesc.contains("VMware Virtual USB CCID");
            }
            case Bit4id: {
                return slotDesc.toUpperCase().contains("BIT4");
            }
            case SafeNet: {
                return slotDesc.toUpperCase().contains("SAFENET");
            }
            case ST: 
            case DNI: {
                return true;
            }
            case IDEMIA: {
                return !slotDesc.toUpperCase().contains("ANF");
            }
        }
        return false;
    }

    public TKManagerPKCS11[] updateP11Managers(Map<String, TKManager> map, TKManager[] managers, PKCS11Type type) {
        TKManagerPKCS11[] m = new TKManagerPKCS11[]{};
        if (this.cardDetector != null && !this.cardDetector.isCardConnected(type)) {
            log.debug((Object)("no hay tarjetas de " + type + " conectadas"));
            return m;
        }
        ArrayList<TKManagerPKCS11> m2 = null;
        long[] slots = null;
        CK_SLOT_INFO[] slotInfos = null;
        CK_TOKEN_INFO[] tokenInfos = null;
        P11Manager p11i = PKCS11ModuleFactory.getP11(type);
        log.info((Object)("Update " + type + " PKCS11 Managers"));
        try (Locker locker = TKManagerPKCS11.getLocker(type).acquireLock();){
            try (LockerImpl smartCardLock = CardDetector.acquireLock();){
                p11i.finalizeP11();
                p11i.initialize();
                log.info((Object)("listando slots de " + type.name()));
                TimeUnit.SECONDS.sleep(5L);
                slots = p11i.GetSlotList(true);
                log.info((Object)("slots de " + type.name() + ": " + slots.length));
                slotInfos = new CK_SLOT_INFO[slots.length];
                tokenInfos = new CK_TOKEN_INFO[slots.length];
                for (int i = 0; i < slots.length; ++i) {
                    slotInfos[i] = p11i.getSlotInfo(slots[i]);
                    String slotDesc = new String(slotInfos[i].slotDescription);
                    if (!TKManagerFactory.acceptTokenDescription(type, slotDesc)) continue;
                    tokenInfos[i] = p11i.getTokenInfo(slots[i]);
                }
            }
            catch (Exception e) {
                p11i.finalizeP11();
                throw e;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (slots != null && slots.length > 0) {
            ArrayList<USB> usbs;
            m = new TKManagerPKCS11[slots.length];
            m2 = new ArrayList<TKManagerPKCS11>();
            for (int i = 0; i < slots.length; ++i) {
                if (slotInfos[i] == null) continue;
                long slot = slots[i];
                try {
                    log.info((Object)("slot:" + slot));
                    try {
                        String serial;
                        CK_TOKEN_INFO tokenInfo;
                        CK_SLOT_INFO c_GetSlotInfo = slotInfos[i];
                        String slotDesc = new String(c_GetSlotInfo.slotDescription);
                        if (!TKManagerFactory.acceptTokenDescription(type, slotDesc) || tokenInfos[i] == null || !TKManagerFactory.acceptTokenInfo(type, tokenInfo = tokenInfos[i]) || serialLocked.contains(serial = new String(tokenInfo.getSerialNumber()))) continue;
                        ANFToken token = ANFTokenFactory.getToken(type, tokenInfo, slot);
                        TKManagerPKCS11 to = (TKManagerPKCS11)map.get(token.getTokenSerialNumber());
                        if (to == null) {
                            try {
                                TKManagerPKCS11 ti = this.getPKCS11Instance(p11i, type, slot);
                                m2.add(ti);
                            }
                            catch (PINLOCKEDException e) {
                                log.error((Object)e);
                                serialLocked.add(serial);
                            }
                            catch (Throwable e) {
                                log.error((Object)e);
                            }
                            continue;
                        }
                        m2.add(to);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)(Confis.get().getString("57", new Object[0]) + slot + Confis.get().getString("58", new Object[0])), (Throwable)e);
                }
            }
            m = new TKManagerPKCS11[m2.size()];
            m = m2.toArray(m);
            if (type == PKCS11Type.VAULT_HSM && m.length > 0 && (usbs = TKManagerSMI.listUSBs()).size() == m.length) {
                for (int j = 0; j < m.length; ++j) {
                    ((TKManagerVaultP11)m[j]).setLetterUnit(usbs.get(j).getMountPoint());
                }
            }
        }
        return m;
    }

    public TKManagerPKCS11 getPKCS11Instance(PKCS11Type type, long slot) throws KeyStoreException, IOException {
        return this.getPKCS11Instance(PKCS11ModuleFactory.getP11(type), type, slot);
    }

    public TKManagerPKCS11 getPKCS11Instance(P11Manager p11, PKCS11Type type, long slot) throws KeyStoreException, IOException {
        switch (type) {
            case VAULT_HSM: {
                return new TKManagerVaultP11(p11, slot);
            }
            case ANFP11: {
                return new TKManagerANFP11(p11, slot);
            }
            case Bit4id: {
                return new TKManagerBit4id(p11, slot);
            }
            case ST: {
                return new TKManagerST(p11, slot);
            }
            case SafeNet: {
                return new TKManagerSafeNet(p11, slot);
            }
            case DNI: {
                return new TKManagerDNI(p11, slot);
            }
            case IDEMIA: {
                return new TKManagerIDEMIA(p11, slot);
            }
        }
        return null;
    }

    public static CK_TOKEN_INFO[] getTokenInfos(PKCS11Type type) {
        long[] c_GetSlotList = null;
        CK_SLOT_INFO[] slotInfos = null;
        CK_TOKEN_INFO[] tokenInfos = null;
        P11Manager p11i = PKCS11ModuleFactory.getP11(type);
        try (Locker locker = TKManagerPKCS11.getLocker(type).acquireLock();){
            p11i.finalizeP11();
            p11i.initialize();
            c_GetSlotList = p11i.GetSlotList(true);
            slotInfos = new CK_SLOT_INFO[c_GetSlotList.length];
            tokenInfos = new CK_TOKEN_INFO[c_GetSlotList.length];
            for (int i = 0; i < c_GetSlotList.length; ++i) {
                slotInfos[i] = p11i.getSlotInfo(c_GetSlotList[i]);
                String slotDesc = new String(slotInfos[i].slotDescription);
                if (!TKManagerFactory.acceptTokenDescription(type, slotDesc)) continue;
                tokenInfos[i] = p11i.getTokenInfo(c_GetSlotList[i]);
            }
        }
        catch (PKCS11Exception | IOException e) {
            log.error((Object)e);
        }
        return tokenInfos;
    }

    public TKManagerLinuxST[] getSTLinuxManagers() {
        return this.getSTLinuxManagers(null, null, false);
    }

    public TKManagerServerST[] getSTServerManagers(Map<String, char[]> pinXSerial, char[] defaultPin) {
        TKManagerLinuxST[] stLinuxManagers = this.getSTLinuxManagers(pinXSerial, defaultPin, true);
        TKManagerServerST[] stServerManagers = null;
        if (stLinuxManagers != null) {
            stServerManagers = new TKManagerServerST[stLinuxManagers.length];
            for (int i = 0; i < stLinuxManagers.length; ++i) {
                stServerManagers[i] = (TKManagerServerST)stLinuxManagers[i];
            }
        }
        return stServerManagers;
    }

    public TKManagerLinuxST[] getSTLinuxManagers(Map<String, char[]> pinXSerial, char[] defaultPin, boolean usePIN) {
        log.info((Object)"TKManagerServerST.getManagers()");
        TKManagerLinuxST[] m = new TKManagerLinuxST[]{};
        ArrayList<TKManagerLinuxST> mlist = null;
        long[] slots = null;
        CK_SLOT_INFO[] slotInfos = null;
        CK_TOKEN_INFO[] tokenInfos = null;
        PKCS11Type type = PKCS11Type.ST;
        P11Manager p11i = PKCS11ModuleFactory.getP11(type);
        try (Locker locker = TKManagerPKCS11.getLocker(type).acquireLock();){
            slots = p11i.GetSlotList(true);
            log.info((Object)("slots de " + type.name() + ": " + slots.length));
            slotInfos = new CK_SLOT_INFO[slots.length];
            tokenInfos = new CK_TOKEN_INFO[slots.length];
            for (int i = 0; i < slots.length; ++i) {
                slotInfos[i] = p11i.getSlotInfo(slots[i]);
                log.info((Object)("slotInfos[" + i + "]:\n" + slotInfos[i]));
                String slotDesc = new String(slotInfos[i].slotDescription);
                if (!TKManagerFactory.acceptTokenDescription(type, slotDesc)) continue;
                log.info((Object)("aceptado " + slotDesc));
                tokenInfos[i] = p11i.getTokenInfo(slots[i]);
                log.info((Object)("tokenInfos[" + i + "]:\n" + tokenInfos[i]));
            }
        }
        catch (PKCS11Exception | IOException e) {
            log.error((Object)e);
        }
        if (slots != null) {
            mlist = new ArrayList<TKManagerLinuxST>(slots.length);
            for (int i = 0; i < slots.length; ++i) {
                long slot = slots[i];
                log.info((Object)slot);
                try {
                    CK_SLOT_INFO c_GetSlotInfo = slotInfos[i];
                    String slotDesc = new String(c_GetSlotInfo.slotDescription);
                    if (TKManagerFactory.acceptTokenDescription(type, slotDesc)) {
                        log.info((Object)("slot " + i + " con descripcion: " + slotDesc + " Aceptado para el tipo: " + type.name()));
                        CK_TOKEN_INFO c_GetTokenInfo = tokenInfos[i];
                        String serial = new String(c_GetTokenInfo.getSerialNumber());
                        if (serialLocked.contains(serial)) continue;
                        String str = slotDesc;
                        int id = str.indexOf("|id=");
                        if (id != -1) {
                            String sid = str.substring(id + 4);
                            log.info((Object)sid);
                        }
                        try {
                            char[] pin = null;
                            if (pinXSerial == null || (pin = pinXSerial.get(serial)) == null) {
                                pin = defaultPin;
                            }
                            if (pin != null) {
                                mlist.add(new TKManagerServerST(p11i, slot, pin));
                                continue;
                            }
                            if (!usePIN) {
                                mlist.add(new TKManagerLinuxST(p11i, slot));
                                continue;
                            }
                            log.info((Object)("no se ha indicado pin para el dispositivo ST " + serial));
                        }
                        catch (PINLOCKEDException e) {
                            log.error((Object)e);
                            serialLocked.add(serial);
                        }
                        catch (KeyStoreException e) {
                            log.error((Object)e);
                        }
                        continue;
                    }
                    log.info((Object)("no se acepta la descripcion " + slotDesc));
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        } else {
            log.info((Object)"slotList=null");
        }
        if (mlist != null) {
            m = new TKManagerLinuxST[mlist.size()];
            mlist.toArray(m);
        }
        return m;
    }

    public TKManagerRemote getTrayIconInstance() {
        return this.updateTrayIconInstance(null, this.centralServerController);
    }

    public TKManagerRemote updateTrayIconInstance(TKManagerRemote previous, CentralServerController controller) {
        TKManagerRemote instance = previous;
        TrayIconUserLogin login = TrayIconClient.loginToLocalAuthServer();
        if (login != null && login.isResult() && login.isLogin() && login.getUserId() != null && login.getUserPassword() != null && !login.getUserId().isEmpty() && !login.getUserPassword().isEmpty()) {
            String user = login.getUserId();
            String pass = login.getUserPassword();
            if (!(user == null || pass == null || previous != null && pass.equals(previous.getPass()) && user.equals(previous.getUserId()))) {
                try {
                    controller.setUser(user);
                    controller.setPassword(pass);
                    instance = new TKManagerRemote(controller, true);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        } else {
            return null;
        }
        return instance;
    }

    public static Locker getLocker(ManagerType type) {
        switch (type) {
            case P11_VAULT: {
                return TKManagerPKCS11.getLocker(PKCS11Type.VAULT_HSM);
            }
            case P11_ANF: {
                return TKManagerPKCS11.getLocker(PKCS11Type.ANFP11);
            }
            case P11_BIT4ID: {
                return TKManagerPKCS11.getLocker(PKCS11Type.Bit4id);
            }
            case P11_SAFENET: {
                return TKManagerPKCS11.getLocker(PKCS11Type.SafeNet);
            }
            case P11_ST: {
                return TKManagerPKCS11.getLocker(PKCS11Type.ST);
            }
            case PLUGSIGN: {
                return LockerImpl.get((String)"p&s");
            }
            case SMI: {
                return LockerImpl.get((String)"smi");
            }
            case WINDOWS: {
                return LockerImpl.get((String)"windows");
            }
        }
        return LockerImpl.get((String)"othertype");
    }
}

