/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.api.tkmanager.exception.PKCS11RuntimeException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.AuthInfoImpl;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManagerAbstract;
import com.anf.cryptotoken.tkmanager.TKManagerPKCS11;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.controller.impl.AuthHandlerImpl;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.USBFactory;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.P11Manager;
import com.anf.pkcs11.jna.PKCS11Exception;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class TKManagerANFP11
extends TKManagerPKCS11 {
    private static final Logger log = Logger.getLogger(TKManagerANFP11.class);

    protected TKManagerANFP11(P11Manager p11, long slot) throws KeyStoreException, IOException {
        super(p11, slot);
        String sd = new String(p11.getSlotInfo((long)slot).slotDescription);
        int ind = sd.indexOf("|u=");
        String unit = sd.substring(ind + 3, ind + 6);
        this.usb = USBFactory.newUSB((String)unit, (String)this.getSerialNumberToken());
        this.MAX_PUK = 5;
        this.MAX_PIN = 5;
        this.onIncorrectPIN = new WrongANFP11PINAction(true);
    }

    @Override
    protected PKCS11Type getType() {
        return PKCS11Type.ANFP11;
    }

    @Override
    protected String deviceType() {
        return "";
    }

    @Override
    protected int getStartCounter() {
        try {
            AuthInfoImpl auth = this.getCounterInfo(this.slot);
            return auth.getPinCounter() >= this.MAX_PIN ? auth.getPukCounter() : auth.getPinCounter();
        }
        catch (Throwable e) {
            log.error((Object)e);
            return super.getStartCounter();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthInfoImpl getCounterInfo(long slot) {
        try (Locker locker = this.getLocker().acquireLock();){
            String[] split;
            CK_SLOT_INFO slotInfo = this.getToken().getSlotInfo();
            if (slotInfo != null && slotInfo.slotDescription != null && (split = new String(slotInfo.slotDescription).split("\\|")) != null && split.length > 3) {
                String[] pinSplit = split[2].split("=");
                String[] pukSplit = split[3].split("=");
                if (pinSplit.length == 2 && pukSplit.length == 2) {
                    int pinCounter = Integer.parseInt(pinSplit[1]);
                    int pukCounter = Integer.parseInt(pukSplit[1]);
                    AuthInfoImpl authInfoImpl2 = new AuthInfoImpl(pinCounter, pukCounter, null, null, this.MAX_PIN, this.MAX_PUK);
                    return authInfoImpl2;
                }
            }
            AuthInfoImpl authInfoImpl = null;
            return authInfoImpl;
        }
        catch (Throwable e) {
            throw new PKCS11RuntimeException(e);
        }
    }

    protected void importChain(String alias, X509Certificate[] certs) throws Exception {
        this.initUserToken();
        KeyStore keyStore = this.getKeyStore();
        PrivateKey key = (PrivateKey)keyStore.getKey(alias, null);
        keyStore = this.getKeyStore();
        try {
            Certificate[] certificateArray;
            if (certs.length == 3) {
                X509Certificate[] x509CertificateArray = new X509Certificate[3];
                x509CertificateArray[0] = certs[CertUtils.getFinalCert((X509Certificate[])certs)];
                x509CertificateArray[1] = certs[CertUtils.getCACert((X509Certificate[])certs)];
                certificateArray = x509CertificateArray;
                x509CertificateArray[2] = certs[CertUtils.getRootCert((X509Certificate[])certs)];
            } else {
                Certificate[] certificateArray2 = new X509Certificate[1];
                certificateArray = certificateArray2;
                certificateArray2[0] = certs[CertUtils.getFinalCert((X509Certificate[])certs)];
            }
            Certificate[] chain = certificateArray;
            keyStore.setKeyEntry(alias, key, null, chain);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e);
        }
    }

    @Override
    public AuthHandler getAuthHandler(Object ... data) {
        String alias = null;
        if (data != null && data.length > 0) {
            alias = data[0].toString();
        }
        return new AuthHandlerImpl(this, alias);
    }

    @Override
    protected String getLockString() {
        return "anfp11";
    }

    @Override
    public USB getUSB() {
        return this.usb;
    }

    @Override
    protected boolean supportPUK() {
        return true;
    }

    private final class WrongANFP11PINAction
    extends TKManagerAbstract.AbstractPINAction<Integer, Integer> {
        public WrongANFP11PINAction(boolean showMessages) {
            super(showMessages);
        }

        @Override
        public Integer apply(Integer iteration) {
            AuthInfoImpl auth = TKManagerANFP11.this.getCounterInfo(TKManagerANFP11.this.slot);
            if (auth != null && auth.getPinCounter() >= TKManagerANFP11.this.MAX_PIN) {
                if (auth.getPukCounter() >= TKManagerANFP11.this.MAX_PUK) {
                    if (this.showMessages) {
                        String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                        KeyBoardHandler.msg(Confis.get().getString("pukBloqued", new Object[0]), errorTitle, 0);
                    }
                    throw new PINLOCKEDException(false);
                }
                if (auth.getPinCounter() == 0 && auth.getPukCounter() == 0) {
                    TKManagerANFP11.this.initChecked = false;
                    try (Locker locker = TKManagerANFP11.this.getLocker().acquireLock();){
                        TKManagerANFP11.this.getP11().unlockPIN(TKManagerANFP11.this.slot, TKManagerANFP11.this.token.getPINSODefault(), new String(TKManagerANFP11.this.getInitPIN()));
                        log.info((Object)"initUserToken finish with initChecked = true");
                        TKManagerANFP11.this.initChecked = true;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                return TKManagerANFP11.this.onPINLocked(auth, null);
            }
            return auth.getPinCounter();
        }
    }
}

