/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.AuthInfo;
import com.anf.cryptotoken.api.tkmanager.TokenManager;
import com.anf.cryptotoken.api.tkmanager.params.UnlockPINParams;
import com.anf.cryptotoken.api.token.TokenInfo;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.usb.USB;
import com.anf.pkcs10.PKCS10Creator;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;

public interface TKManager
extends TokenManager {
    public static final String KEY_ALG = "RSA";
    public static final String RSA = "NONEwithRSA";
    public static final String SHA1 = "SHA1withRSA";
    public static final String SHA224 = "SHA224withRSA";
    public static final String SHA256 = "SHA256withRSA";
    public static final String SHA384 = "SHA384withRSA";
    public static final String SHA512 = "SHA512withRSA";
    public static final String[] SIGN_ALG = new String[]{"SHA1withRSA", "SHA224withRSA", "SHA256withRSA", "SHA384withRSA", "SHA512withRSA"};
    public static final String[] HASH_ALG = new String[]{"SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
    public static final String CIPHER_ALG = "RSA/ECB/PKCS1Padding";
    public static final byte[] SHA1Header = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    public static final byte[] SHA224Header = new byte[]{48, 45, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 5, 0, 4, 28};
    public static final byte[] SHA256Header = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    public static final byte[] SHA384Header = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    public static final byte[] SHA512Header = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
    public static final byte[][] HEADERS = new byte[][]{SHA1Header, SHA224Header, SHA256Header, SHA384Header, SHA512Header};

    public void reloadToken();

    public void resetToken();

    public boolean changePIN(String var1);

    public boolean changePIN(String var1, char[] var2, char[] var3, char[] var4);

    public String getSerialNumberToken();

    public byte[] generateRequest(String var1, X500Name var2, BigInteger var3, Date var4, Date var5, int var6, ASN1Set var7, String var8);

    public void importCertificate(String var1, X509Certificate[] var2);

    public void removeCertificate(String var1) throws Throwable;

    public Enumeration<String> getAlias();

    public X509Certificate getCertificate(String var1);

    public X509Certificate[] getCertificateChain(String var1);

    public Provider getProvider();

    public KeyStore getKeyStore();

    public KeyPair getKeyPair(String var1);

    public KeyPair getKeyPair(String var1, char[] var2);

    public byte[] signData(String var1, byte[] var2, String var3);

    public byte[] signData(String var1, byte[] var2, String var3, char[] var4);

    public boolean verifyData(String var1, byte[] var2, byte[] var3, String var4);

    public byte[] encryptData(String var1, byte[] var2, String var3);

    public byte[] decryptData(String var1, byte[] var2, String var3);

    public byte[] decryptData(String var1, byte[] var2, String var3, char[] var4);

    public TokenInfo getTokenInfo();

    public int[] getCertificateCounts();

    public LinkedList<X509Certificate> getCertificates();

    public boolean canGenerateCertificateCount(int var1);

    public X509Certificate[] convertCertificateArraytoX509CertificateArray(Certificate[] var1);

    public boolean isAllItemInstanceOfX509Certificate(Certificate[] var1);

    public String getPrPath();

    public PrivateKey getPrivateKey2(String var1);

    public KeyPair _generateKeyPair(int var1) throws KeyStoreException;

    public SecretKey generateSecretKey(int var1);

    public X509Certificate createCertAndKeyPair(String var1, X500Name var2, BigInteger var3, Date var4, Date var5, int var6, char[] var7);

    public USB getUSB();

    public PrivateKey getPrivateKey(String var1);

    public PrivateKey getPrivateKey(String var1, char[] var2);

    public boolean containsAlias(String var1);

    public Locker getLocker();

    public char[] getPIN(String var1);

    public AuthInfo getCounterInfo(String var1);

    public String getName();

    public boolean unlockPIN(UnlockPINParams var1);

    public boolean initUserPIN(String var1, String var2, char[] var3, char[] var4);

    public String getNewValidAlias(X500Name var1);

    public List<String> importPFX(File var1, char[] var2);

    public boolean accept(ProfilePolicy var1);

    public Locker lock();

    public void unlock(Locker var1);

    public Signature getSignatureInstance(String var1);

    public boolean isSignatureStore();

    public void setPkcs10Creator(PKCS10Creator var1);

    public void saveStore();

    public void setCommonKeyBoardId(String var1);
}

