/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.pkcs11.jna.P11Manager;
import com.anf.utils.OSUtils;
import java.util.Map;
import java.util.TreeMap;

public class PKCS11ModuleFactory {
    private static boolean useCache = false;
    private static Map<String, P11Manager> cache = new TreeMap<String, P11Manager>();

    private PKCS11ModuleFactory() {
    }

    public static String getModule(PKCS11Type type) {
        switch (type) {
            case ANFP11: {
                return "PKCS11Libs/anfp11/anfpkcs11.dll";
            }
            case Bit4id: {
                return "PKCS11Libs/bit4id/bit4xpki.dll";
            }
            case DNI: {
                return "PKCS11Libs/DNI/DNIe_P11_x64.dll";
            }
            case SafeNet: {
                return "PKCS11Libs/SafeNet/eTPKCS11.dll";
            }
            case ST: {
                return OSUtils.isWindows() ? "PKCS11Libs/ST/stPKCS11.dll" : "PKCS11Libs/ST/stpkcs11.so";
            }
            case VAULT_HSM: {
                return "PKCS11Libs/PKCS11v0303_32b/VaultIC_PKCS11.dll";
            }
            case IDEMIA: {
                String os = OSUtils.getOsName();
                if (os.startsWith("Windows")) {
                    return "PKCS11Libs/IDEMIA/WINDOWS/idplug-pkcs11.dll";
                }
                if (os.startsWith("Linux")) {
                    return "PKCS11Libs/IDEMIA/LINUX/libidplug-pkcs11.so";
                }
                if (!os.startsWith("Mac")) break;
                return "PKCS11Libs/IDEMIA/MAC/libidplug-pkcs11.dylib";
            }
        }
        return null;
    }

    public static P11Manager getP11(PKCS11Type type) {
        String module = PKCS11ModuleFactory.getModule(type);
        if (!useCache) {
            return new P11Manager(module);
        }
        return cache.computeIfAbsent(module, m -> new P11Manager(module));
    }
}

