/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.server;

import com.anf.cryptotoken.api.tkmanager.exception.TrayIconException;
import com.anf.cryptotoken.json.TrayIconShowWindow;
import com.anf.cryptotoken.json.TrayIconUserLogin;
import com.anf.oauth.json.JSONFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrayIconClient {
    private static final Logger log = LogManager.getLogger(TrayIconClient.class);

    public static void main(String[] args) throws IOException {
        TrayIconClient.loginToLocalAuthServer();
    }

    public static TrayIconUserLogin loginToLocalAuthServer() {
        TrayIconUserLogin login = null;
        login = TrayIconClient.connect(TrayIconUserLogin.class, "{\"Type\":\"IsUserLogin\"}");
        if (login != null && !login.isResult()) {
            throw new TrayIconException("ERR_BAD_RESPONSE_LOCAL_SERVER");
        }
        return login;
    }

    public static TrayIconShowWindow openTrayIconWindows() throws IOException {
        TrayIconShowWindow login = null;
        login = TrayIconClient.connect(TrayIconShowWindow.class, "{\"Type\":\"ShowWindow\"}");
        return login;
    }

    public static <E> E connect(Class<E> clazz, String message) {
        Object result = null;
        try (Socket socket = new Socket("127.0.0.1", 6425);
             PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
             BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));){
            if (!socket.isConnected()) {
                throw new Exception("NO TRAY ICON SERVER RUNNING");
            }
            socket.setSoTimeout((int)TimeUnit.MINUTES.toMillis(1L));
            writer.print(message);
            writer.flush();
            String resp = reader.readLine();
            result = JSONFactory.buildObject((String)resp, clazz);
        }
        catch (ConnectException e) {
            log.warn("NO TRAY ICON SERVER RUNNING");
        }
        catch (IOException e) {
            throw new TrayIconException((Throwable)e);
        }
        catch (Exception e) {
            log.info((Object)e);
            throw new TrayIconException("ERR_LOCAL_SERVER", (Throwable)e);
        }
        return (E)result;
    }
}

