/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ocsp.impl;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.ocsp.ANFOCSPClient;
import com.anf.cryptotoken.api.ocsp.CertStatus;
import com.anf.cryptotoken.api.ocsp.OCSPValidationResult;
import com.anf.cryptotoken.api.ocsp.model.RevocationSerialInfo;
import com.anf.cryptotoken.api.sign.exception.OCSPException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ocsp.OCSPHandler;
import com.anf.cryptotoken.ocsp.impl.ANFOCSPClientImpl;
import com.anf.cryptotoken.ocsp.impl.CertStatusImpl;
import com.anf.cryptotoken.ocsp.impl.OCSPValidationResultImpl;
import com.anf.cryptotoken.utils.CertURLUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;

public class OCSPHandlerImpl
implements OCSPHandler {
    private static final Logger log = Logger.getLogger(OCSPHandlerImpl.class);
    private ANFOCSPClient ocspClient = new ANFOCSPClientImpl();
    private String defaultOCSPUrl = "https://ocsp.anf.es/spain/AV";
    public static final String GOOD = "Good";
    public static final String REVOKED = "Revoked";
    public static final String UNKNOWN = "Unknown";
    private Map<String, BasicOCSPResp> responseCache = new TreeMap<String, BasicOCSPResp>();

    @Override
    public BasicOCSPResp getOCSPResponse(X509Certificate certificate, X509Certificate issuerCertificate) {
        String cacheKey = Base64.getEncoder().encodeToString(certificate.getSignature()) + "-" + Base64.getEncoder().encodeToString(issuerCertificate.getSignature());
        BasicOCSPResp cachedResp = this.responseCache.get(cacheKey);
        if (cachedResp != null) {
            Calendar cal = Calendar.getInstance();
            cal.add(12, -5);
            if (cachedResp.getProducedAt().after(cal.getTime())) {
                return cachedResp;
            }
        }
        long time = System.nanoTime();
        log.info((Object)"CALLING getOCSPResponse()");
        BasicOCSPResp respuestaOCSP = null;
        String url = null;
        url = CertURLUtils.getOCSPURL((X509Certificate)certificate);
        if (url == null) {
            url = this.defaultOCSPUrl;
        }
        if (url != null) {
            log.info((Object)("PROBANDO CON URL OCSP DEL CERTIFICADO: " + url));
            respuestaOCSP = this.connectOCSP(this.ocspClient, certificate, issuerCertificate, url);
        } else {
            log.info((Object)"OCSP URL DEL CERTIFICADO NULL");
        }
        time = (long)((double)(System.nanoTime() - time) / 1000000.0);
        log.info((Object)("RETURNING getOCSPResponse(" + (respuestaOCSP != null ? "OK" : "NULL") + ") IN " + time + " MS"));
        this.responseCache.put(cacheKey, respuestaOCSP);
        return respuestaOCSP;
    }

    @Override
    public BasicOCSPResp connectOCSP(ANFOCSPClient client, X509Certificate certificate, X509Certificate issuerCertificate, String url) {
        log.info((Object)("CONECTANDO OCSP: " + url));
        long time = System.nanoTime();
        BasicOCSPResp respuestaOCSP = client.getBasicOCSPResp(certificate, issuerCertificate, url);
        time = (long)((double)(System.nanoTime() - time) / 1000000.0);
        log.info((Object)("OCSP RESPONSE: " + (respuestaOCSP != null ? "OK" : "NULL") + " IN " + time + " MS FOR URL: " + url));
        return respuestaOCSP;
    }

    @Override
    public String getStatus(BasicOCSPResp respuestaOCSP) {
        SingleResp[] responses = respuestaOCSP.getResponses();
        if (responses.length == 1) {
            SingleResp resp = responses[0];
            CertificateStatus certStatus = resp.getCertStatus();
            return this.checkStatusFromOcspResponse(certStatus);
        }
        return null;
    }

    @Override
    public String checkStatusFromOcspResponse(Object certStatus) {
        if (certStatus == null) {
            return GOOD;
        }
        if (certStatus instanceof RevokedStatus) {
            return REVOKED;
        }
        if (certStatus instanceof RevokedStatus) {
            return REVOKED;
        }
        if (certStatus instanceof UnknownStatus) {
            return UNKNOWN;
        }
        if (certStatus instanceof UnknownStatus) {
            return UNKNOWN;
        }
        return Confis.get().getString("333", new Object[0]);
    }

    @Override
    public void validateOCSP(X509Certificate[] chain) {
        log.info((Object)("validando OCSP para cadena de tamano " + chain.length));
        int cert = CertUtils.getFinalCert((X509Certificate[])chain);
        if (cert != -1) {
            X509Certificate userCert = chain[cert];
            X509Certificate issuer = CertUtils.getIssuerCertificate((X509Certificate[])chain, (X509Certificate)userCert);
            try {
                log.info((Object)("se va a intentar 3 veces obtener el status OCSP del certificado " + userCert.getSubjectX500Principal()));
                BasicOCSPResp resp = null;
                for (int i = 0; i < 3 && resp == null; ++i) {
                    log.info((Object)("Intentando realizar solicitud OCSP, intento " + (i + 1)));
                    resp = this.getOCSPResponse(userCert, issuer);
                }
                String status = null;
                if (resp != null) {
                    status = this.getStatus(resp);
                }
                if (status != null) {
                    if (!status.equals(GOOD)) {
                        throw new OCSPException("El Status OCSP devuelto es " + status);
                    }
                } else {
                    throw new OCSPException("ERR_STATUS_OCSP_NULL:No se ha obtenido el Status OCSP");
                }
                log.info((Object)("status OCSP is GOOD for " + userCert.getSubjectX500Principal()));
            }
            catch (OCSPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OCSPException("No se ha podido conectar con los servidores OCSP. ha ocurrido un error", (Throwable)e);
            }
        } else {
            log.info((Object)"validateOCSP return by final cert = -1");
        }
    }

    @Override
    public List<CertStatus> validateOCSPCertificateChain(X509Certificate[] chain) {
        ArrayList<CertStatus> status = new ArrayList<CertStatus>();
        if (chain.length == 0) {
            return status;
        }
        for (int i = 0; i < chain.length - 1; ++i) {
            X509Certificate cur = chain[i];
            CertStatusImpl crtSts = null;
            try {
                X509Certificate issuer = CertUtils.getIssuerCertificate((X509Certificate[])chain, (X509Certificate)cur);
                if (issuer == null) {
                    crtSts = new CertStatusImpl(cur, null, UNKNOWN);
                    status.add(crtSts);
                    continue;
                }
                BasicOCSPResp ocspResponse = this.getOCSPResponse(cur, issuer);
                if (ocspResponse == null) {
                    crtSts = new CertStatusImpl(cur, ocspResponse, null);
                    status.add(crtSts);
                    continue;
                }
                String statusOCSP = this.getStatus(ocspResponse);
                crtSts = new CertStatusImpl(cur, ocspResponse, statusOCSP);
                status.add(crtSts);
                continue;
            }
            catch (Exception e) {
                if (crtSts != null) {
                    status.remove(status.size() - 1);
                }
                status.add(new CertStatusImpl(cur, e));
            }
        }
        return status;
    }

    @Override
    public OCSPValidationResult getValidationResult(BasicOCSPResp basicOCSPResp) {
        return new OCSPValidationResultImpl(basicOCSPResp);
    }

    @Override
    public OCSPValidationResult getValidationResult(BasicOCSPResponse basicOCSPResp) {
        return new OCSPValidationResultImpl(basicOCSPResp);
    }

    @Override
    public ANFOCSPClient ocspClient() {
        return new ANFOCSPClientImpl();
    }

    @Override
    public List<CertStatus> verifyCertificateChain(X509Certificate[] chain) {
        ArrayList<CertStatus> status = new ArrayList<CertStatus>(chain.length);
        for (int i = 0; i < chain.length - 1; ++i) {
            X509Certificate cur = chain[i];
            try {
                if (CertUtils.isSelfSigned((X509Certificate)cur)) {
                    this.verifyCertificate(cur, cur, status);
                    continue;
                }
                X509Certificate issuer = CertUtils.getIssuerCertificate((X509Certificate[])chain, (X509Certificate)cur);
                this.verifyCertificate(cur, issuer, status);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return status;
    }

    private void verifyCertificate(X509Certificate cert, X509Certificate issuer, ArrayList<CertStatus> status) {
        try {
            if (issuer == null) {
                throw new CertificateException("ERR_ISSUER_NOT_FOUND_FOR_CERT:" + cert.getSerialNumber());
            }
            cert.verify(issuer.getPublicKey());
            status.add(new CertStatusImpl(cert, true));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            log.error((Object)e);
            status.add(new CertStatusImpl(cert, e));
        }
    }

    @Override
    public Map<String, RevocationSerialInfo> getSerialNumbersRevocationStatus(List<String> serials) {
        return this.ocspClient.getSerialNumbersRevocationStatus(serials);
    }
}

