/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.json;

import com.anf.cert.utils.CertUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;

public class TSLCertificateValidationRequest {
    private List<String> certificateChain;
    private Date signDate;
    @JsonIgnore
    private X509Certificate[] chain;

    public TSLCertificateValidationRequest(X509Certificate certificate, Date signDate) {
        this.chain = new X509Certificate[]{certificate};
        this.signDate = signDate;
    }

    public TSLCertificateValidationRequest(List<String> chain, Date signDate) throws IOException {
        this.certificateChain = chain;
        this.signDate = signDate;
        this.chain = new X509Certificate[chain.size()];
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i] = this.getX509Cert(this.certificateChain.get(i));
        }
    }

    public X509Certificate getX509Cert(String certString) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(Hex.decode((byte[])certString.getBytes()));){
            X509Certificate x509Certificate = CertUtils.getCert((InputStream)in);
            return x509Certificate;
        }
    }

    @Generated
    public List<String> getCertificateChain() {
        return this.certificateChain;
    }

    @Generated
    public Date getSignDate() {
        return this.signDate;
    }

    @Generated
    public X509Certificate[] getChain() {
        return this.chain;
    }

    @Generated
    public void setCertificateChain(List<String> certificateChain) {
        this.certificateChain = certificateChain;
    }

    @Generated
    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    @JsonIgnore
    @Generated
    public void setChain(X509Certificate[] chain) {
        this.chain = chain;
    }
}

