/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.json;

import com.anf.cryptotoken.json.AbstractResponse;
import com.anf.cryptotoken.json.ServiceStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TSLCertificateValidation
extends AbstractResponse {
    private boolean issuedQualified;
    private boolean qualifiedService;
    private String serviceType;
    private boolean serviceSignatureQualified;
    private boolean rootCertificateService;
    private String tslURL;
    private String tslVersionIdentifier;
    private String tslSequenceNumber;
    private String tslType;
    private String tslName;
    private Calendar issueDate;
    private Calendar issueDateTSL;
    private Calendar nextUpdateTSL;
    private ServiceStatus signDateStatus;
    private ServiceStatus certIssueDateStatus;
    private ServiceStatus currentServiceStatus;
    private List<String> infoURIs = new ArrayList<String>();
    private boolean rootCertMatch;
    private String tslIdCert;
    private boolean serviceSealQualified;
    private int sequenceNumber;
    private int versionId;
    private String sid;
    private String skiX509;
    private String entity;
    private String id;
    private boolean qcCompliance;
    private List<String> policyOids;
    private String conclusion;
    private boolean qscd;
    private String test;
    private boolean matchTSPName = true;
    private boolean matchOne = true;

    public void init(boolean issuedQualified, boolean qualifiedService, String serviceType, boolean serviceSignatureQualified, boolean serviceSealQualified, boolean rootCertificateService, String tslURL, Calendar issueDateTSL, ServiceStatus signDateStatus, ServiceStatus certIssueDateStatus, ServiceStatus currentServiceStatus, List<String> infoURIs, boolean rootCertMatch, String tslIdCert, int sequenceNumber, int versionId) {
        this.issuedQualified = issuedQualified;
        this.qualifiedService = qualifiedService;
        this.serviceType = serviceType;
        this.serviceSignatureQualified = serviceSignatureQualified;
        this.rootCertificateService = rootCertificateService;
        this.tslURL = tslURL;
        this.issueDateTSL = issueDateTSL;
        this.signDateStatus = signDateStatus;
        this.certIssueDateStatus = certIssueDateStatus;
        this.currentServiceStatus = currentServiceStatus;
        this.infoURIs = infoURIs;
        this.rootCertMatch = rootCertMatch;
        this.tslIdCert = tslIdCert;
        this.serviceSealQualified = serviceSealQualified;
        this.sequenceNumber = sequenceNumber;
        this.versionId = versionId;
    }

    public void copy(TSLCertificateValidation response) {
        this.init(response.issuedQualified, response.qualifiedService, response.serviceType, response.serviceSignatureQualified, response.serviceSealQualified, response.rootCertificateService, response.tslURL, response.issueDateTSL, response.signDateStatus, response.certIssueDateStatus, response.currentServiceStatus, response.infoURIs, response.rootCertMatch, response.tslIdCert, response.sequenceNumber, response.versionId);
    }

    public void setDigitalIdCertificate(X509Certificate tslIdCertificate) throws CertificateEncodingException {
        this.tslIdCert = new String(Hex.encode((byte[])tslIdCertificate.getEncoded()));
    }

    @JsonIgnore
    public X509Certificate getX509Cert(String certString) throws IOException, CertificateException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(Hex.decode((byte[])certString.getBytes()));){
            Certificate cert = CertificateFactory.getInstance("x509").generateCertificate(in);
            X509Certificate x509Certificate = (X509Certificate)cert;
            return x509Certificate;
        }
    }

    @JsonIgnore
    public X509Certificate getTslIdCertificate() throws CertificateException, IOException {
        return this.getX509Cert(this.tslIdCert);
    }

    @Generated
    public boolean isIssuedQualified() {
        return this.issuedQualified;
    }

    @Generated
    public boolean isQualifiedService() {
        return this.qualifiedService;
    }

    @Generated
    public String getServiceType() {
        return this.serviceType;
    }

    @Generated
    public boolean isServiceSignatureQualified() {
        return this.serviceSignatureQualified;
    }

    @Generated
    public boolean isRootCertificateService() {
        return this.rootCertificateService;
    }

    @Generated
    public String getTslURL() {
        return this.tslURL;
    }

    @Generated
    public String getTslVersionIdentifier() {
        return this.tslVersionIdentifier;
    }

    @Generated
    public String getTslSequenceNumber() {
        return this.tslSequenceNumber;
    }

    @Generated
    public String getTslType() {
        return this.tslType;
    }

    @Generated
    public String getTslName() {
        return this.tslName;
    }

    @Generated
    public Calendar getIssueDate() {
        return this.issueDate;
    }

    @Generated
    public Calendar getIssueDateTSL() {
        return this.issueDateTSL;
    }

    @Generated
    public Calendar getNextUpdateTSL() {
        return this.nextUpdateTSL;
    }

    @Generated
    public ServiceStatus getSignDateStatus() {
        return this.signDateStatus;
    }

    @Generated
    public ServiceStatus getCertIssueDateStatus() {
        return this.certIssueDateStatus;
    }

    @Generated
    public ServiceStatus getCurrentServiceStatus() {
        return this.currentServiceStatus;
    }

    @Generated
    public List<String> getInfoURIs() {
        return this.infoURIs;
    }

    @Generated
    public boolean isRootCertMatch() {
        return this.rootCertMatch;
    }

    @Generated
    public String getTslIdCert() {
        return this.tslIdCert;
    }

    @Generated
    public boolean isServiceSealQualified() {
        return this.serviceSealQualified;
    }

    @Generated
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public int getVersionId() {
        return this.versionId;
    }

    @Generated
    public String getSid() {
        return this.sid;
    }

    @Generated
    public String getSkiX509() {
        return this.skiX509;
    }

    @Generated
    public String getEntity() {
        return this.entity;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean isQcCompliance() {
        return this.qcCompliance;
    }

    @Generated
    public List<String> getPolicyOids() {
        return this.policyOids;
    }

    @Generated
    public String getConclusion() {
        return this.conclusion;
    }

    @Generated
    public boolean isQscd() {
        return this.qscd;
    }

    @Generated
    public String getTest() {
        return this.test;
    }

    @Generated
    public boolean isMatchTSPName() {
        return this.matchTSPName;
    }

    @Generated
    public boolean isMatchOne() {
        return this.matchOne;
    }

    @Generated
    public void setIssuedQualified(boolean issuedQualified) {
        this.issuedQualified = issuedQualified;
    }

    @Generated
    public void setQualifiedService(boolean qualifiedService) {
        this.qualifiedService = qualifiedService;
    }

    @Generated
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    @Generated
    public void setServiceSignatureQualified(boolean serviceSignatureQualified) {
        this.serviceSignatureQualified = serviceSignatureQualified;
    }

    @Generated
    public void setRootCertificateService(boolean rootCertificateService) {
        this.rootCertificateService = rootCertificateService;
    }

    @Generated
    public void setTslURL(String tslURL) {
        this.tslURL = tslURL;
    }

    @Generated
    public void setTslVersionIdentifier(String tslVersionIdentifier) {
        this.tslVersionIdentifier = tslVersionIdentifier;
    }

    @Generated
    public void setTslSequenceNumber(String tslSequenceNumber) {
        this.tslSequenceNumber = tslSequenceNumber;
    }

    @Generated
    public void setTslType(String tslType) {
        this.tslType = tslType;
    }

    @Generated
    public void setTslName(String tslName) {
        this.tslName = tslName;
    }

    @Generated
    public void setIssueDate(Calendar issueDate) {
        this.issueDate = issueDate;
    }

    @Generated
    public void setIssueDateTSL(Calendar issueDateTSL) {
        this.issueDateTSL = issueDateTSL;
    }

    @Generated
    public void setNextUpdateTSL(Calendar nextUpdateTSL) {
        this.nextUpdateTSL = nextUpdateTSL;
    }

    @Generated
    public void setSignDateStatus(ServiceStatus signDateStatus) {
        this.signDateStatus = signDateStatus;
    }

    @Generated
    public void setCertIssueDateStatus(ServiceStatus certIssueDateStatus) {
        this.certIssueDateStatus = certIssueDateStatus;
    }

    @Generated
    public void setCurrentServiceStatus(ServiceStatus currentServiceStatus) {
        this.currentServiceStatus = currentServiceStatus;
    }

    @Generated
    public void setInfoURIs(List<String> infoURIs) {
        this.infoURIs = infoURIs;
    }

    @Generated
    public void setRootCertMatch(boolean rootCertMatch) {
        this.rootCertMatch = rootCertMatch;
    }

    @Generated
    public void setTslIdCert(String tslIdCert) {
        this.tslIdCert = tslIdCert;
    }

    @Generated
    public void setServiceSealQualified(boolean serviceSealQualified) {
        this.serviceSealQualified = serviceSealQualified;
    }

    @Generated
    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Generated
    public void setVersionId(int versionId) {
        this.versionId = versionId;
    }

    @Generated
    public void setSid(String sid) {
        this.sid = sid;
    }

    @Generated
    public void setSkiX509(String skiX509) {
        this.skiX509 = skiX509;
    }

    @Generated
    public void setEntity(String entity) {
        this.entity = entity;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setQcCompliance(boolean qcCompliance) {
        this.qcCompliance = qcCompliance;
    }

    @Generated
    public void setPolicyOids(List<String> policyOids) {
        this.policyOids = policyOids;
    }

    @Generated
    public void setConclusion(String conclusion) {
        this.conclusion = conclusion;
    }

    @Generated
    public void setQscd(boolean qscd) {
        this.qscd = qscd;
    }

    @Generated
    public void setTest(String test) {
        this.test = test;
    }

    @Generated
    public void setMatchTSPName(boolean matchTSPName) {
        this.matchTSPName = matchTSPName;
    }

    @Generated
    public void setMatchOne(boolean matchOne) {
        this.matchOne = matchOne;
    }

    @Generated
    public TSLCertificateValidation() {
    }
}

