/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.impl;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.ANFCryptoTokenFactory;
import com.anf.cryptotoken.DeviceManager;
import com.anf.cryptotoken.device.CertificateInfo;
import com.anf.cryptotoken.device.DeviceInfo;
import com.anf.cryptotoken.device.StoreInfo;
import com.anf.cryptotoken.device.impl.CertificateInfoImpl;
import com.anf.cryptotoken.device.impl.DeviceInfoImpl;
import com.anf.cryptotoken.device.impl.LinkedStoreInfoImpl;
import com.anf.cryptotoken.device.impl.StoreInfoImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.ManagerType;
import com.anf.cryptotoken.usb.USB;
import com.anf.utils.CertFilter;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class DeviceManagerImpl
implements DeviceManager {
    private static final Logger log = Logger.getLogger(DeviceManagerImpl.class);
    private ANFCryptoTokenFactory factory;

    public DeviceManagerImpl(ANFCryptoTokenFactory factory) {
        this.factory = factory;
    }

    @Override
    public List<CertificateInfo> getCertificates() {
        return this.getCertificates(null, true, new ManagerType[0]);
    }

    @Override
    public List<CertificateInfo> getCertificatesExcluding(ManagerType ... types) {
        return this.getCertificates(null, false, types);
    }

    @Override
    public List<CertificateInfo> getCertificatesIncluding(ManagerType ... types) {
        return this.getCertificates(null, true, types);
    }

    @Override
    public List<CertificateInfo> getCertificates(CertFilter filter, boolean include, ManagerType ... types) {
        TreeSet<ManagerType> typesSet = new TreeSet<ManagerType>();
        if (types != null && types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                typesSet.add(types[i]);
            }
        }
        ManagerType[] allTypes = ManagerType.values();
        ArrayList<CertificateInfo> certs = new ArrayList<CertificateInfo>();
        for (int i = 0; i < allTypes.length; ++i) {
            ManagerType type = allTypes[i];
            if (!this.factory.isActiveType(type) || (!typesSet.isEmpty() || !include) && include != typesSet.contains((Object)type)) continue;
            certs.addAll(this.getCertificates(type, null, filter));
        }
        return certs;
    }

    @Override
    public List<CertificateInfo> getCertificates(DeviceInfo dev, CertFilter filter) {
        List<StoreInfo> stores = dev.getStores();
        ArrayList<CertificateInfo> certs = new ArrayList<CertificateInfo>();
        for (StoreInfo st : stores) {
            certs.addAll(this.getCertificates(st.getType(), st.getSerial(), filter));
        }
        return certs;
    }

    public List<CertificateInfo> getCertificates(ManagerType type, String serial, CertFilter filter) {
        List<Object> certs = null;
        if (this.factory.isActiveType(type)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(type);
                certs = this.getCertificates(ins, serial, filter);
            }
            catch (Throwable e) {
                log.error((Object)e);
                certs = new ArrayList();
            }
        }
        return certs;
    }

    @Override
    public List<CertificateInfo> getCertificatesAllDevices() {
        List<DeviceInfo> devices = this.getDevices();
        return this.getCertificatesDevices(devices);
    }

    @Override
    public List<CertificateInfo> getCertificatesDevices(List<DeviceInfo> devices) {
        ArrayList<CertificateInfo> certs = new ArrayList<CertificateInfo>();
        for (DeviceInfo deviceInfo : devices) {
            certs.addAll(this.getCertificates(deviceInfo));
        }
        return certs;
    }

    @Override
    public List<CertificateInfo> getCertificates(DeviceInfo device) {
        ArrayList<CertificateInfo> certs = new ArrayList<CertificateInfo>();
        List<StoreInfo> stores = device.getStores();
        for (StoreInfo storeInfo : stores) {
            certs.addAll(this.getCertificates(storeInfo.getToken()));
        }
        return certs;
    }

    @Override
    public List<CertificateInfo> getCertificates(StoreInfo store) {
        return this.getCertificates(store.getToken());
    }

    @Override
    public List<CertificateInfo> getCertificates(ANFCryptoToken ins) {
        return this.getCertificates(ins, null, null);
    }

    private List<CertificateInfo> getCertificates(ANFCryptoToken ins, String serial, CertFilter filter) {
        ArrayList<CertificateInfo> certs = new ArrayList<CertificateInfo>();
        if (ins != null) {
            for (int j = 0; j < ins.getTokenCount(); ++j) {
                try {
                    String sn = ins.getSerialNumberToken(j);
                    if (serial != null && !serial.equals(sn)) continue;
                    Enumeration<String> aliases = ins.getAlias(sn);
                    while (aliases.hasMoreElements()) {
                        int ci;
                        String alias = aliases.nextElement();
                        X509Certificate[] chain = ins.getCertificateChain(sn, alias);
                        if (chain == null || (ci = CertUtils.getFinalCert((X509Certificate[])chain)) == -1) continue;
                        X509Certificate cert = chain[ci];
                        if (filter != null && !filter.accept(cert)) continue;
                        CertificateInfoImpl cinfo = new CertificateInfoImpl(ins.getType(), ins.getUSB(sn), ins.getStoreName(sn), sn, alias, chain, cert, ins);
                        certs.add(cinfo);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        return certs;
    }

    @Override
    public List<DeviceInfo> getDevices() {
        return this.getDevicesExcluding(new ManagerType[0]);
    }

    @Override
    public List<DeviceInfo> getDevicesExcluding(ManagerType ... ommited) {
        boolean add = false;
        return this.getDevices(add, ommited);
    }

    @Override
    public List<DeviceInfo> getDevicesIncluding(ManagerType ... ignored) {
        boolean add = true;
        return this.getDevices(add, ignored);
    }

    private ArrayList<DeviceInfo> getDevices(boolean add, ManagerType ... ignored) {
        TreeMap<String, DeviceInfo> devs = new TreeMap<String, DeviceInfo>();
        TreeSet<ManagerType> filterSet = new TreeSet<ManagerType>();
        for (int i = 0; i < ignored.length; ++i) {
            filterSet.add(ignored[i]);
        }
        this.addWindowsDevice(devs, filterSet, add);
        this.addServerDevice(devs, filterSet, add);
        ManagerType[] types = new ManagerType[]{ManagerType.P11_ANF, ManagerType.PLUGSIGN};
        for (int t = 0; t < types.length; ++t) {
            ManagerType usbType = types[t];
            this.addUsbDevice(devs, filterSet, add, usbType);
        }
        this.addSMIVaultDevice(devs, filterSet, add);
        this.addVaultOnlyDevice(devs, filterSet, add);
        this.addBit4Device(devs, filterSet, add);
        this.addSafeNetDevice(devs, filterSet, add);
        this.addSTDevice(devs, filterSet, add);
        this.addDNIDevice(devs, filterSet, add);
        this.addIDEMIADevice(devs, filterSet, add);
        return new ArrayList<DeviceInfo>(devs.values());
    }

    private void addSTDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.P11_ST, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.P11_ST);
                this.addNonUsbStores(ins, devs);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addBit4Device(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.P11_BIT4ID, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.P11_BIT4ID);
                this.addNonUsbStores(ins, devs);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addIDEMIADevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.P11_IDEMIA, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.P11_IDEMIA);
                this.addNonUsbStores(ins, devs);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addDNIDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.P11_DNI, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.P11_DNI);
                this.addNonUsbStores(ins, devs);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addSafeNetDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.P11_SAFENET, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.P11_SAFENET);
                this.addNonUsbStores(ins, devs);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addVaultOnlyDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.P11_VAULT, filterSet, add)) {
            try {
                ANFCryptoToken hsm = this.factory.getInstance(ManagerType.P11_VAULT);
                this.addNonUsbStores(hsm, devs);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addSMIVaultDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.SMI, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.SMI);
                if (ins.getTokenCount() > 0) {
                    if (!filterSet.contains((Object)ManagerType.P11_VAULT)) {
                        ANFCryptoToken hsm = this.factory.getInstance(ManagerType.P11_VAULT);
                        this.addLinkedStores(devs, ins, hsm);
                    } else {
                        this.addUSBStores(ins, devs);
                    }
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addUsbDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add, ManagerType usbType) {
        if (this.checkIfListDevice(usbType, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(usbType);
                this.addUSBStores(ins, devs);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addServerDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.SERVER, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.SERVER);
                if (ins.getTokenCount() == 1) {
                    String serial = ins.getSerialNumberToken(0);
                    this.addNonUsbStore(serial, ins, devs);
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void addWindowsDevice(TreeMap<String, DeviceInfo> devs, TreeSet<ManagerType> filterSet, boolean add) {
        if (this.checkIfListDevice(ManagerType.WINDOWS, filterSet, add)) {
            try {
                ANFCryptoToken ins = this.factory.getInstance(ManagerType.WINDOWS);
                if (ins.getTokenCount() == 1) {
                    String serial = ins.getSerialNumberToken(0);
                    this.addNonUsbStore(serial, ins, devs);
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private boolean checkIfListDevice(ManagerType type, TreeSet<ManagerType> filterSet, boolean add) {
        return this.factory.isActiveType(type) && add == filterSet.contains((Object)type);
    }

    private void addLinkedStores(TreeMap<String, DeviceInfo> devs, ANFCryptoToken ins, ANFCryptoToken hsm) {
        if (hsm.getTokenCount() == ins.getTokenCount()) {
            for (int i = 0; i < ins.getTokenCount(); ++i) {
                try {
                    String serial = ins.getSerialNumberToken(i);
                    String serialHSM = hsm.getSerialNumberToken(i);
                    this.addLinkedStore(devs, ins, hsm, serial, serialHSM);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    private void addLinkedStore(TreeMap<String, DeviceInfo> devs, ANFCryptoToken ins, ANFCryptoToken hsm, String serial, String serialHSM) {
        USB usb = ins.getUSB(serial);
        DeviceInfo dev = devs.get(usb.getMountPoint());
        if (dev == null) {
            dev = new DeviceInfoImpl(usb.getLetter());
            devs.put(usb.getMountPoint(), dev);
        }
        dev.getStores().add(new LinkedStoreInfoImpl(usb.getLetter(), ins.getType(), serial, ins, hsm, hsm.getType(), serialHSM, '\u0000'));
        devs.put(serialHSM, dev);
    }

    private void addNonUsbStores(ANFCryptoToken ins, TreeMap<String, DeviceInfo> devs) {
        for (int i = 0; i < ins.getTokenCount(); ++i) {
            try {
                String serial = ins.getSerialNumberToken(i);
                this.addNonUsbStore(serial, ins, devs);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private void addNonUsbStore(String serial, ANFCryptoToken ins, TreeMap<String, DeviceInfo> devs) {
        DeviceInfo dev = devs.get(serial);
        if (dev == null) {
            dev = new DeviceInfoImpl('\u0000');
            devs.put(serial, dev);
        }
        dev.getStores().add(new StoreInfoImpl('\u0000', ins.getType(), serial, ins));
    }

    private void addUSBStores(ANFCryptoToken ins, TreeMap<String, DeviceInfo> devs) {
        for (int i = 0; i < ins.getTokenCount(); ++i) {
            try {
                String serial = ins.getSerialNumberToken(i);
                this.addUSBStore(serial, ins, devs);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private void addUSBStore(String serial, ANFCryptoToken ins, TreeMap<String, DeviceInfo> registeredDevices) {
        USB usb = ins.getUSB(serial);
        String usbDeviceIdentifierd = usb.getMountPoint();
        DeviceInfo newDevice = registeredDevices.get(usbDeviceIdentifierd);
        if (newDevice == null) {
            newDevice = new DeviceInfoImpl(usb.getLetter());
            registeredDevices.put(usbDeviceIdentifierd, newDevice);
        }
        newDevice.getStores().add(new StoreInfoImpl(usb.getLetter(), ins.getType(), serial, ins));
    }

    @Override
    public byte[] sign(CertificateInfo certInfo, byte[] data, String algorithm) {
        ANFCryptoToken anf = certInfo.getToken();
        byte[] signData = anf.signData(certInfo.getDeviceSerialNumber(), certInfo.getAlias(), data, algorithm);
        return signData;
    }

    @Override
    public byte[] decrypt(CertificateInfo certInfo, byte[] data, String algorithm) {
        ANFCryptoToken anf = certInfo.getToken();
        byte[] decryptedData = anf.decryptData(certInfo.getDeviceSerialNumber(), certInfo.getAlias(), data, algorithm);
        return decryptedData;
    }
}

