/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.impl;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.AuthInfo;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.token.TokenInfo;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.ManagerType;
import com.anf.cryptotoken.tkmanager.TKManager;
import com.anf.cryptotoken.tkmanager.TKManagerAbstractStore;
import com.anf.cryptotoken.tkmanager.TKManagerFactory;
import com.anf.cryptotoken.tkmanager.TKManagerPFX;
import com.anf.cryptotoken.tkmanager.TKManagerPFXRemote;
import com.anf.cryptotoken.tkmanager.TKManagerRemote;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.ui.keyboard.handler.auth.PINConfig;
import com.anf.cryptotoken.usb.USB;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class ANFCryptoTokenImpl
implements ANFCryptoToken {
    private static final Logger log = Logger.getLogger(ANFCryptoTokenImpl.class);
    private TKManager[] tk;
    ManagerType type;
    private String name = "";
    private TKManagerFactory managerFactory;
    private boolean requireUpdate = true;

    @Override
    public void reloadToken(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        tkm.reloadToken();
    }

    public ANFCryptoTokenImpl() {
        this.type = null;
        this.tk = new TKManager[0];
        this.name = "";
    }

    public ANFCryptoTokenImpl(File pfx, char[] pass) {
        this.tk = new TKManager[1];
        this.tk[0] = new TKManagerPFX(pfx, pass);
        this.type = null;
        this.name = "PFX";
    }

    public ANFCryptoTokenImpl(TKManagerPFXRemote pfx) {
        this.tk = new TKManager[1];
        this.tk[0] = pfx;
        this.type = null;
        this.name = "PFX";
    }

    public <T extends TKManagerAbstractStore> ANFCryptoTokenImpl(T manager) {
        this.tk = new TKManager[1];
        this.tk[0] = manager;
        this.type = null;
        this.name = manager.getName();
    }

    public ANFCryptoTokenImpl(ManagerType type, TKManagerFactory managerFactory) {
        this.type = type;
        this.managerFactory = managerFactory;
        this.tk = managerFactory.getTKManagers(type);
        if (type != null) {
            this.name = type.name();
        }
    }

    public ANFCryptoTokenImpl(TKManagerRemote tkManagerRemote) {
        this.type = ManagerType.SERVER;
        this.tk = new TKManager[1];
        this.tk[0] = tkManagerRemote;
    }

    public ANFCryptoTokenImpl(TKManagerPFX tkManagerPfx) {
        this.type = ManagerType.SERVER;
        this.tk = new TKManager[1];
        this.tk[0] = tkManagerPfx;
        this.name = "PFX";
    }

    public ANFCryptoTokenImpl(InputStream pfxStream, char[] pass) {
        this.tk = new TKManager[1];
        this.tk[0] = new TKManagerPFX(pfxStream, pass);
        this.type = null;
        this.name = "PFX";
    }

    @Override
    public synchronized int getTokenCount() {
        int c = 0;
        if (this.tk != null) {
            for (int i = 0; i < this.tk.length; ++i) {
                if (this.tk[i] == null) continue;
                ++c;
            }
        }
        return c;
    }

    @Override
    public synchronized TKManager findTokenBySerialNumber(String serial) {
        for (int i = 0; i < this.tk.length; ++i) {
            if (!this.tk[i].getSerialNumberToken().equals(serial)) continue;
            return this.tk[i];
        }
        return null;
    }

    @Override
    public synchronized TKManager getTKManager(int token) {
        return token < this.getTokenCount() && token >= 0 ? this.tk[token] : null;
    }

    @Override
    public void resetToken(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        tkm.resetToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changePIN(String serial, String alias) {
        KeyBoardHandler.setPINConfig(PINConfig.ERASE_INMEDIATLY);
        TKManager tkm = this.findTokenBySerialNumber(serial);
        try {
            boolean bl = tkm.changePIN(alias);
            return bl;
        }
        finally {
            KeyBoardHandler.setPINConfig(PINConfig.ERASE_AFTER_SECS);
        }
    }

    @Override
    public byte[] generateRequest(String serial, X500Name x500Name, BigInteger serialCert, Date notBefore, Date notAfter, int keySize, ASN1Set attributes, String signAlg) {
        try {
            TKManager tkm = this.findTokenBySerialNumber(serial);
            return tkm.generateRequest(null, x500Name, serialCert, notBefore, notAfter, keySize, attributes, signAlg);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public void importCertificate(String serial, String alias, X509Certificate[] certChain) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        tkm.importCertificate(alias, certChain);
    }

    @Override
    public Enumeration<String> getAlias(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getAlias();
    }

    public Enumeration<String> getSignAlias(String serial) {
        return this.getAlias(serial);
    }

    @Override
    public X509Certificate getCertificate(String serial, String alias) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getCertificate(alias);
    }

    public X509Certificate getSignCertificate(String serial, String alias) {
        return this.getCertificate(serial, alias);
    }

    @Override
    public char[] getPIN(String serial, String alias) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getPIN(alias);
    }

    @Override
    public X509Certificate[] getCertificateChain(String serial, String alias) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getCertificateChain(alias);
    }

    public X509Certificate[] getSignCertificateChain(String serial, String alias) {
        return this.getCertificateChain(serial, alias);
    }

    @Override
    public Provider getProvider(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getProvider();
    }

    public Provider getSignProvider(String serial) {
        return this.getProvider(serial);
    }

    @Override
    public KeyStore getKeyStore(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getKeyStore();
    }

    @Override
    public PrivateKey getPrivateKey(String serial, String alias) {
        return this.getKeyPair(serial, alias).getPrivate();
    }

    @Override
    public KeyPair getKeyPair(String serial, String alias) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getKeyPair(alias);
    }

    @Override
    public KeyPair getKeyPair(String serial, String alias, char[] pin) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getKeyPair(alias, pin);
    }

    public byte[] signData(String serial, String alias, byte[] data, String signAlgorithm) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.signData(alias, data, signAlgorithm);
    }

    public byte[] signData(String serial, String alias, byte[] data, String signAlgorithm, char[] pin) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.signData(alias, data, signAlgorithm, pin);
    }

    public boolean verifyData(String serial, String alias, byte[] data, byte[] signedData, String signAlgorithm) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.verifyData(alias, data, signedData, signAlgorithm);
    }

    @Override
    public byte[] encryptData(String serial, String alias, byte[] data, String algorithm) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.encryptData(alias, data, algorithm);
    }

    @Override
    public byte[] decryptData(String serial, String alias, byte[] encryptData, String algorithm) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.decryptData(alias, encryptData, algorithm);
    }

    @Override
    public byte[] decryptData(String serial, String alias, byte[] encryptData, String algorithm, char[] pin) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.decryptData(alias, encryptData, algorithm, pin);
    }

    @Override
    public synchronized String getSerialNumberToken(int i) {
        if (i >= 0 && i < this.tk.length) {
            return this.tk[i].getSerialNumberToken();
        }
        return null;
    }

    @Override
    public void removeCertificate(String serial, String alias) throws Throwable {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        tkm.removeCertificate(alias);
    }

    @Override
    public synchronized void reuseToken() {
        this.tk = null;
    }

    @Override
    public String getPKCS11Pr(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getPrPath();
    }

    @Override
    public KeyPair _generateKeyPair(String serial, int keySize) throws KeyStoreException {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm._generateKeyPair(keySize);
    }

    @Override
    public LinkedList<X509Certificate> getX509Certificates(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return this.getCertificates(tkm);
    }

    public int[] getCertificateCounts(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getCertificateCounts();
    }

    public int getCertificateCount(String serial, int keyLength) {
        LinkedList<X509Certificate> certs = this.getX509Certificates(serial);
        int c = 0;
        for (X509Certificate cert : certs) {
            if (!(cert.getPublicKey() instanceof RSAPublicKey) || keyLength != 0 && ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength() != keyLength) continue;
            ++c;
        }
        return c;
    }

    @Override
    public boolean canGenerateCertificateCount(String serial, int count2048) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.canGenerateCertificateCount(count2048);
    }

    @Override
    public X509Certificate createCertAndKeyPair(String serial, String alias, int keyLength, String signAlg, String serialNumber, Date dateAfter, Date dateBefore, HashMap<String, String> datos, String name, char[] pass) {
        try {
            TKManager tkm = this.findTokenBySerialNumber(serial);
            if (tkm != null) {
                if (alias == null) {
                    Random randomGenerator = new Random();
                    int randomInt = randomGenerator.nextInt(1000000);
                    alias = String.valueOf(randomInt);
                }
                BouncyCastleProvider BC = new BouncyCastleProvider();
                Security.addProvider((Provider)BC);
                X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
                builder.addRDN(BCStyle.CN, "Aramis");
                Date notBefore = new Date(System.currentTimeMillis() - 86400000L);
                Date notAfter = new Date(System.currentTimeMillis() + 1827387392L);
                BigInteger serialCert = BigInteger.valueOf(System.currentTimeMillis());
                X500Name x500name = builder.build();
                return tkm.createCertAndKeyPair(alias, x500name, serialCert, notBefore, notAfter, keyLength, pass);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return null;
    }

    @Override
    public String createCertificate(String serial, int keyLength, String outPutFile, String signAlg, String serialNumber, Date dateAfter, Date dateBefore, HashMap<String, String> datos, String name, String signAlias) {
        return null;
    }

    @Override
    public LinkedList<X509Certificate> getCertificates(TKManager tm) {
        return tm.getCertificates();
    }

    @Override
    public TokenInfo getTokenInfo(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getTokenInfo();
    }

    @Override
    public ManagerType getType() {
        return this.type;
    }

    public String typeName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        TKManager[] update = null;
        try {
            ANFCryptoTokenImpl aNFCryptoTokenImpl = this;
            synchronized (aNFCryptoTokenImpl) {
                boolean updateDone;
                update = this.managerFactory.updateTKManagers(this.tk, this.type);
                boolean bl = updateDone = update != null && this.tk != null && this.tk.length != update.length;
                if (update != null) {
                    this.tk = update;
                    this.requireUpdate = false;
                }
                return updateDone;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean alwaysUpdate() {
        return this.type == ManagerType.WINDOWS;
    }

    @Override
    public synchronized USB getUSB(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.getUSB();
    }

    @Override
    public X509Certificate getCertificadoFirmante(String serial, String alias) {
        try {
            X509Certificate[] chain = this.getCertificateChain(serial, alias);
            if (chain != null) {
                int f;
                if (this.getType() == ManagerType.P11_VAULT && chain.length == 1) {
                    return chain[0];
                }
                if (chain.length == 3 && (f = CertUtils.getFinalCert((X509Certificate[])chain)) != -1) {
                    return chain[f];
                }
            }
        }
        catch (Throwable e) {
            throw new ANFCertificateException();
        }
        return null;
    }

    @Override
    public SecretKey generateSecretKey(String serial, int byteLength) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        return tkm.generateSecretKey(byteLength);
    }

    public String toString() {
        return "ANF-" + this.type + " count=" + this.getTokenCount();
    }

    @Override
    public boolean isHSM() {
        return this.type != null && (this.type == ManagerType.P11_SAFENET || this.type == ManagerType.P11_ST || this.type == ManagerType.P11_BIT4ID || this.type == ManagerType.P11_VAULT);
    }

    @Override
    public boolean login(String serialNumber, String alias) {
        TKManager tm = this.findTokenBySerialNumber(serialNumber);
        if (tm == null) {
            return false;
        }
        X509Certificate cert = tm.getCertificate(alias);
        if (cert == null) {
            return false;
        }
        KeyPair kp = tm.getKeyPair(alias);
        byte[] buffer = cert.getPublicKey().getEncoded();
        Provider prov = tm.getProvider();
        byte[] signData = UtilsPki.signData(buffer, kp.getPrivate(), "SHA256withRSA", prov);
        return UtilsPki.verifyData(buffer, signData, kp.getPublic(), "SHA256withRSA", prov);
    }

    @Override
    public AuthInfo getCounterInfo(String serial, String alias) {
        TKManager tm = this.findTokenBySerialNumber(serial);
        if (tm == null) {
            return null;
        }
        return tm.getCounterInfo(alias);
    }

    @Override
    public String getStoreName(String serial) {
        TKManager tm = this.findTokenBySerialNumber(serial);
        if (tm == null) {
            return null;
        }
        return tm.getName();
    }

    @Override
    public List<String> importPFX(String serial, File pfx, char[] password) {
        TKManager tm = this.findTokenBySerialNumber(serial);
        if (tm == null) {
            return null;
        }
        return tm.importPFX(pfx, password);
    }

    public Signature getSignatureInstance(String serial, String signAlg) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        if (tkm != null) {
            return tkm.getSignatureInstance(signAlg);
        }
        return null;
    }

    public boolean isSignatureDevice(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        if (tkm != null) {
            return tkm.isSignatureStore();
        }
        return false;
    }

    public Locker getLocker(String serial) {
        TKManager tkm = this.findTokenBySerialNumber(serial);
        if (tkm != null) {
            return tkm.getLocker();
        }
        return LockerImpl.get((String)serial);
    }

    @Override
    public void setUpdateRequired(boolean requireUpdate) {
        this.requireUpdate = requireUpdate;
    }

    @Override
    public boolean isRequireUpdate() {
        return this.requireUpdate;
    }
}

