/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.filecert;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.utils.DatosPersonales;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class FileCertUtils {
    private static final Logger log = Logger.getLogger(FileCertUtils.class);

    public static void exportToPEM(X509Certificate[] chain, PrivateKey pkey, File outFile) throws IOException {
        try (FileWriter file = new FileWriter(outFile);
             JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)file);){
            pemWriter.writeObject((Object)pkey);
            for (int i = 0; i < chain.length; ++i) {
                pemWriter.writeObject((Object)chain[i]);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int exportKeyStoreToPEM(KeyStore store, char[] pass, File outFile) throws IOException {
        try (FileWriter file = new FileWriter(outFile);){
            int n;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)file);){
                int c = 0;
                Enumeration<String> aliases = store.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    try {
                        Certificate[] chain = store.getCertificateChain(alias);
                        X509Certificate[] x509 = CertUtils.toX509((Certificate[])chain);
                        Key key = store.getKey(alias, pass);
                        pemWriter.writeObject((Object)key);
                        for (int i = 0; i < x509.length; ++i) {
                            pemWriter.writeObject((Object)x509[i]);
                        }
                        ++c;
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                        log.error((Object)e);
                    }
                }
                n = c;
            }
            return n;
        }
        catch (KeyStoreException e) {
            log.error((Object)e);
            return -1;
        }
    }

    public static void exportP7BToPEM(File p7b, File outFile) throws IOException, CertificateException, CMSException {
        try (FileWriter file = new FileWriter(outFile);
             JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)file);){
            X509Certificate[] chain = FileCertUtils.getCertificatesP7B(p7b);
            for (int i = 0; i < chain.length; ++i) {
                pemWriter.writeObject((Object)chain[i]);
            }
        }
    }

    public static void exportPEMToP7B(File pem, File p7b) throws CertificateEncodingException, IOException, CMSException {
        X509Certificate[] chain = FileCertUtils.getCertificatesPEM(pem);
        FileCertUtils.exportCertsToP7B(p7b, chain);
    }

    public static void exportCertChainToPEM(X509Certificate[] chain, File outFile) throws IOException {
        try (FileWriter file = new FileWriter(outFile);
             JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)file);){
            for (int i = 0; i < chain.length; ++i) {
                pemWriter.writeObject((Object)chain[i]);
            }
        }
    }

    public static void exportCertToPEM(X509Certificate cert, File outFile) throws IOException {
        try (FileWriter file = new FileWriter(outFile);
             JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)file);){
            pemWriter.writeObject((Object)cert);
        }
    }

    public static void exportCertsToPEM(File outFile, X509Certificate ... certs) throws IOException {
        if (certs != null && certs.length > 0) {
            try (FileOutputStream out = new FileOutputStream(outFile);
                 JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(out));){
                for (X509Certificate cert : certs) {
                    jcaPEMWriter.writeObject((Object)cert);
                }
            }
        }
    }

    public static void exportCertToDER(File outFile, X509Certificate cert) throws IOException, CertificateEncodingException {
        FileOutputStream out = new FileOutputStream(outFile);
        IOUtils.write((byte[])cert.getEncoded(), (OutputStream)out);
        out.close();
    }

    public static CMSSignedData exportCertsToP7B(X509Certificate ... certs) throws IOException, CertificateEncodingException, CMSException {
        return FileCertUtils.exportCertsToP7B((OutputStream)null, certs);
    }

    public static CMSSignedData exportCertsToP7B(File outFile, X509Certificate ... certs) throws IOException, CertificateEncodingException, CMSException {
        try (FileOutputStream fout = new FileOutputStream(outFile);){
            CMSSignedData cMSSignedData = FileCertUtils.exportCertsToP7B(fout, certs);
            return cMSSignedData;
        }
    }

    public static CMSSignedData exportCertsToP7B(OutputStream output, X509Certificate ... certs) throws IOException, CertificateEncodingException, CMSException {
        CMSSignedDataGenerator cmsg = new CMSSignedDataGenerator();
        if (certs != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < certs.length; ++i) {
                cmsg.addCertificate(new X509CertificateHolder(certs[i].getEncoded()));
                out.write(certs[i].getEncoded());
            }
            CMSProcessableByteArray msgFile = new CMSProcessableByteArray(new byte[0]);
            CMSSignedData sigData = cmsg.generate((CMSTypedData)msgFile, false);
            if (output != null) {
                IOUtils.write((byte[])sigData.getEncoded(), (OutputStream)output);
            }
            return sigData;
        }
        return null;
    }

    public static CMSSignedData exportCertsToP7BSigned(InputStream signedContent, File outFile, Provider prov, PrivateKey pkey, X509Certificate ... certs) throws IOException, CertificateEncodingException, CMSException, OperatorCreationException {
        CMSSignedDataGenerator cmsg = new CMSSignedDataGenerator();
        if (certs != null && certs.length > 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < certs.length; ++i) {
                cmsg.addCertificate(new X509CertificateHolder(certs[i].getEncoded()));
                out.write(certs[i].getEncoded());
            }
            JcaSignerInfoGeneratorBuilder generador = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build());
            ContentSigner sha256Signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(prov).build(pkey);
            SignerInfoGenerator sigInfogenerator = generador.build(sha256Signer, certs[0]);
            cmsg.addSignerInfoGenerator(sigInfogenerator);
            CMSProcessableByteArray msgFile = new CMSProcessableByteArray(IOUtils.toByteArray((InputStream)signedContent));
            CMSSignedData sigData = cmsg.generate((CMSTypedData)msgFile, false);
            FileOutputStream fout = new FileOutputStream(outFile);
            IOUtils.write((byte[])sigData.getEncoded(), (OutputStream)fout);
            fout.close();
            return sigData;
        }
        return null;
    }

    public static boolean verifyP7B(X509Certificate certificate, Provider provider, File p7b) throws CMSException, IOException {
        FileInputStream fin = new FileInputStream(p7b);
        CMSSignedData cms = new CMSSignedData(IOUtils.toByteArray((InputStream)fin));
        fin.close();
        return FileCertUtils.verifyIntegrity(certificate, provider, cms);
    }

    public static boolean verifyIntegrity(final X509Certificate certificate, Provider provider, CMSSignedData firmado) throws CMSException {
        final JcaSimpleSignerInfoVerifierBuilder sigVerifBuilder = new JcaSimpleSignerInfoVerifierBuilder();
        SignerInformationVerifierProvider verifierProvider = new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                SignerInformationVerifier build = sigVerifBuilder.setProvider("BC").build(certificate);
                return build;
            }
        };
        boolean verify = firmado.verifySignatures(verifierProvider);
        return verify;
    }

    public static String getCertificateFormat(File crt) {
        X509Certificate[] chain;
        String format = null;
        try {
            byte[] content;
            X509Certificate user = FileCertUtils.loadCertificate(crt);
            if (user != null && Arrays.equals(content = IOUtils.toByteArray((InputStream)new FileInputStream(crt)), user.getEncoded())) {
                format = "DER";
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        if (format == null) {
            try {
                chain = FileCertUtils.getCertificatesPEM(crt);
                if (chain != null && chain.length > 0) {
                    format = "PEM";
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (format == null) {
            try {
                chain = FileCertUtils.getCertificatesP7B(crt);
                if (chain != null && chain.length > 0) {
                    format = "P7B";
                }
            }
            catch (IOException | CertificateException | CMSException e) {
                log.error((Object)e);
            }
        }
        if (format == null) {
            format = "NONE";
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(File file) {
        block23: {
            AgregarProveedor.agregarBouncyCastleProvider();
            PemReader r = null;
            try {
                X509Certificate x509Certificate;
                r = new PemReader((Reader)new FileReader(file));
                PemObject pemObj = r.readPemObject();
                if (pemObj != null) {
                    while (pemObj != null && !pemObj.getType().equals("CERTIFICATE") && !pemObj.getType().equals("X509 CERTIFICATE")) {
                        pemObj = r.readPemObject();
                    }
                    if (pemObj != null) {
                        X509Certificate cert;
                        byte[] content = pemObj.getContent();
                        X509CertificateHolder certHolder = new X509CertificateHolder(content);
                        X509Certificate x509Certificate2 = cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                        return x509Certificate2;
                    }
                    break block23;
                }
                FileInputStream ci = null;
                try {
                    ci = new FileInputStream(file);
                    x509Certificate = CertUtils.getCert((InputStream)ci);
                }
                catch (Throwable throwable) {
                    try {
                        ci.close();
                        throw throwable;
                    }
                    catch (IOException | CertificateException e) {
                        log.error((Object)e);
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                ci.close();
                return x509Certificate;
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadP7BtoKeyStore(File pem, char[] pass) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException, CertificateException {
        KeyStore store = KeyStore.getInstance("BKS");
        store.load(null, null);
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(pem));){
            Object obj = null;
            PrivateKey priv = null;
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            int serial = 1;
            while ((obj = pemParser.readObject()) != null) {
                if (obj instanceof PEMKeyPair) {
                    PEMKeyPair kp = (PEMKeyPair)obj;
                    PrivateKeyInfo privateKeyInfo = kp.getPrivateKeyInfo();
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    priv = kf.generatePrivate(spec);
                    System.out.println(priv);
                    if (certs.isEmpty()) continue;
                    Certificate[] chain = new X509Certificate[certs.size()];
                    certs.toArray(chain);
                    chain = CertUtils.sortChain((X509Certificate[])chain);
                    chain = CertUtils.buildChain((X509Certificate[])chain);
                    certs.clear();
                    store.setKeyEntry("" + serial, priv, pass, chain);
                    priv = null;
                    continue;
                }
                if (!(obj instanceof X509CertificateHolder)) continue;
                X509CertificateHolder certHolder = (X509CertificateHolder)obj;
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                boolean f = false;
                for (int i = 0; !f && i < certs.size(); ++i) {
                    f = ((X509Certificate)certs.get(i)).getSerialNumber().equals(cert.getSerialNumber());
                }
                if (f) continue;
                certs.add(cert);
            }
            if (!certs.isEmpty() && priv != null) {
                Certificate[] chain = new X509Certificate[certs.size()];
                certs.toArray(chain);
                chain = CertUtils.sortChain((X509Certificate[])chain);
                chain = CertUtils.buildChain((X509Certificate[])chain);
                certs.clear();
                store.setKeyEntry("" + serial, priv, pass, chain);
            }
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadPEMtoKeyStore(File pem, char[] pass) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException, CertificateException {
        KeyStore store = KeyStore.getInstance("BKS");
        store.load(null, null);
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(pem));){
            Object obj = null;
            PrivateKey priv = null;
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            int serial = 1;
            while ((obj = pemParser.readObject()) != null) {
                if (obj instanceof PEMKeyPair) {
                    PEMKeyPair kp = (PEMKeyPair)obj;
                    PrivateKeyInfo privateKeyInfo = kp.getPrivateKeyInfo();
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    priv = kf.generatePrivate(spec);
                    System.out.println(priv);
                    if (certs.isEmpty()) continue;
                    Certificate[] chain = new X509Certificate[certs.size()];
                    certs.toArray(chain);
                    chain = CertUtils.sortChain((X509Certificate[])chain);
                    chain = CertUtils.buildChain((X509Certificate[])chain);
                    certs.clear();
                    store.setKeyEntry("" + serial, priv, pass, chain);
                    priv = null;
                    continue;
                }
                if (!(obj instanceof X509CertificateHolder)) continue;
                X509CertificateHolder certHolder = (X509CertificateHolder)obj;
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                boolean f = false;
                for (int i = 0; !f && i < certs.size(); ++i) {
                    f = ((X509Certificate)certs.get(i)).getSerialNumber().equals(cert.getSerialNumber());
                }
                if (f) continue;
                certs.add(cert);
            }
            if (!certs.isEmpty() && priv != null) {
                Certificate[] chain = new X509Certificate[certs.size()];
                certs.toArray(chain);
                chain = CertUtils.sortChain((X509Certificate[])chain);
                chain = CertUtils.buildChain((X509Certificate[])chain);
                certs.clear();
                store.setKeyEntry("" + serial, priv, pass, chain);
            }
        }
        return store;
    }

    public static boolean exportPEMToPFX(File pem, File pfx) throws IOException, NOPINException {
        try {
            char[] password = null;
            try {
                String id = pfx.getName() + "-export";
                password = KeyBoardHandler.getPassword(id, Confis.get().getString("171", new Object[0]), false, false, null);
            }
            catch (NOPINException e) {
                KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                throw e;
            }
            KeyStore pemStore = FileCertUtils.loadPEMtoKeyStore(pem, password);
            if (pemStore != null) {
                return FileCertUtils.exportKeyStoreToPFX(pfx, pemStore, password, password) > 0;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static int exportKeyStoreToPFX(File outFile, KeyStore input, char[] inpass, char[] outpass) throws IOException {
        try {
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(null, null);
            Enumeration<String> aliases = input.aliases();
            int c = 0;
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] chain = input.getCertificateChain(alias);
                X509Certificate[] x509 = CertUtils.toX509((Certificate[])chain);
                int userCert = CertUtils.getFinalCert((X509Certificate[])x509);
                if (userCert == -1) {
                    throw new IOException("ERR_USER_CERT_NOT_PRESENT");
                }
                X509Certificate cert = x509[userCert];
                try {
                    Key key = input.getKey(alias, inpass);
                    String cn = new DatosPersonales(cert.getSubjectX500Principal()).getCN();
                    cn = cn.replace(" ", "_");
                    store.setKeyEntry(cn, key, inpass, chain);
                    ++c;
                }
                catch (UnrecoverableKeyException e) {
                    log.error((Object)e);
                }
            }
            FileOutputStream out = new FileOutputStream(outFile);
            store.store(out, outpass);
            out.close();
            return c;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            log.error((Object)e);
            return -1;
        }
    }

    public static void exportCertToPFX(File outFile, PrivateKey key, X509Certificate ... chain) throws IOException, NOPINException {
        try {
            if (chain == null || chain.length == 0) {
                throw new IOException("ERR_CERT_NULL");
            }
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(null, null);
            Certificate[] c = new Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                c[i] = chain[i];
            }
            int userCert = CertUtils.getFinalCert((X509Certificate[])chain);
            if (userCert == -1) {
                throw new IOException("ERR_USER_CERT_NOT_PRESENT");
            }
            X509Certificate cert = chain[userCert];
            FileOutputStream out = new FileOutputStream(outFile);
            char[] password = null;
            try {
                String id = outFile.getName() + "-export";
                password = KeyBoardHandler.getPassword(id, Confis.get().getString("171", new Object[0]), false, false, null);
            }
            catch (NOPINException e) {
                KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                out.close();
                throw e;
            }
            String cn = new DatosPersonales(cert.getSubjectX500Principal()).getCN();
            cn = cn.replace(" ", "_");
            store.setKeyEntry(cn, key, password, c);
            store.store(out, password);
            out.close();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            log.error((Object)e);
        }
    }

    public static void exportCertsFromPfx(String name, String pass) {
        try {
            AgregarProveedor.agregarBouncyCastleProvider();
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(new FileInputStream(new File(name)), pass.toCharArray());
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] chain = store.getCertificateChain(alias);
                X509Certificate[] x509 = CertUtils.toX509((Certificate[])chain);
                int finalCert = CertUtils.getFinalCert((X509Certificate[])x509);
                FileCertUtils.exportCertToPEM(x509[finalCert], new File("[pfx=" + name + "] [alias=" + alias + "].cer"));
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    public static boolean exportPFXtoPEM(File pfx, File pem) throws NOPINException {
        try {
            char[] password = null;
            try {
                String id = pfx.getName() + "-export";
                password = KeyBoardHandler.getPassword(id, Confis.get().getString("PINPFX", new Object[0]), false, false, null);
            }
            catch (NOPINException e) {
                KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                throw e;
            }
            AgregarProveedor.agregarBouncyCastleProvider();
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(new FileInputStream(pfx), password);
            return FileCertUtils.exportKeyStoreToPEM(store, password, pem) > 0;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return false;
        }
    }

    public static TreeMap<String, X509Certificate[]> getCertificatesPFX(File pfx) throws NOPINException {
        TreeMap<String, X509Certificate[]> certs = new TreeMap<String, X509Certificate[]>();
        try {
            char[] password = null;
            try {
                String id = pfx.getName() + "-import";
                password = KeyBoardHandler.getPassword(id, Confis.get().getString("PINPFX", new Object[0]), false, false, null);
            }
            catch (NOPINException e) {
                KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                throw e;
            }
            AgregarProveedor.agregarBouncyCastleProvider();
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(new FileInputStream(pfx), password);
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] chain = store.getCertificateChain(alias);
                X509Certificate[] x509 = CertUtils.toX509((Certificate[])chain);
                certs.put(alias, CertUtils.sortChain((X509Certificate[])x509));
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return certs;
    }

    public static List<PrivateKey> getPrivateKeysPEM(File pem) {
        ArrayList<PrivateKey> keys = new ArrayList<PrivateKey>();
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(pem));){
            Object obj = null;
            while ((obj = pemParser.readObject()) != null) {
                PrivateKeyInfo pki = null;
                if (obj instanceof PEMKeyPair) {
                    PEMKeyPair kp = (PEMKeyPair)obj;
                    pki = kp.getPrivateKeyInfo();
                } else if (obj instanceof PrivateKeyInfo) {
                    pki = (PrivateKeyInfo)obj;
                }
                if (pki == null) continue;
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pki.getEncoded());
                KeyFactory kf = KeyFactory.getInstance("RSA");
                PrivateKey priv = kf.generatePrivate(spec);
                keys.add(priv);
            }
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error((Object)e);
        }
        return keys;
    }

    public static X509Certificate[] getCertificatesPEM(File file) {
        X509Certificate[] chain = null;
        AgregarProveedor.agregarBouncyCastleProvider();
        try (FileInputStream in = new FileInputStream(file);){
            chain = CertUtils.getCertificatesPEM((InputStream)in);
        }
        catch (IOException | CertificateException | CMSException e) {
            log.error((Object)e);
        }
        return chain;
    }

    public static X509Certificate[] getCertificatesP7B(File p7b) throws CMSException, CertificateException, IOException {
        try (FileInputStream in = new FileInputStream(p7b);){
            X509Certificate[] x509CertificateArray = CertUtils.getCertificates((InputStream)in);
            return x509CertificateArray;
        }
    }

    public static void exportPrivateKeyToPEM(PrivateKey privateKey, File outFile) throws IOException {
        FileWriter file = new FileWriter(outFile);
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)file);
        pemWriter.writeObject((Object)privateKey);
        pemWriter.close();
        file.close();
    }

    static {
        AgregarProveedor.agregarBouncyCastleProvider();
    }
}

