/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.device.impl;

import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.device.CertificateInfo;
import com.anf.cryptotoken.tkmanager.ManagerType;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.security.cert.X509Certificate;

public class CertificateInfoImpl
implements CertificateInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private ManagerType deviceType;
    private String deviceSerialNumber;
    private String alias;
    private String certSerialNumber;
    @JsonIgnore
    private DatosPersonales subject;
    @JsonIgnore
    private DatosPersonales issuer;
    private X509Certificate[] chain;
    private X509Certificate cert;
    private USB usb = null;
    private String storeName;
    @JsonIgnore
    private transient ANFCryptoToken instance;

    public CertificateInfoImpl() {
    }

    public CertificateInfoImpl(ManagerType type, USB usb, String name, String deviceSerialNumber, String alias, X509Certificate[] chain, X509Certificate cert, ANFCryptoToken ins) {
        this.instance = ins;
        this.deviceSerialNumber = deviceSerialNumber;
        this.alias = alias;
        this.chain = chain;
        this.cert = cert;
        this.deviceType = type;
        this.certSerialNumber = cert.getSerialNumber().toString();
        this.subject = new DatosPersonales(cert.getSubjectX500Principal());
        this.issuer = new DatosPersonales(cert.getIssuerX500Principal());
        this.usb = usb;
        this.storeName = name;
    }

    @Override
    public ManagerType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getCertSerialNumber() {
        return this.certSerialNumber;
    }

    @Override
    @JsonIgnore
    public DatosPersonales getSubject() {
        if (this.subject == null && this.cert != null) {
            this.subject = new DatosPersonales(this.cert.getSubjectX500Principal());
        }
        return this.subject;
    }

    @Override
    @JsonIgnore
    public DatosPersonales getIssuer() {
        if (this.issuer == null && this.cert != null) {
            this.issuer = new DatosPersonales(this.cert.getIssuerX500Principal());
        }
        return this.issuer;
    }

    @Override
    public X509Certificate getCert() {
        return this.cert;
    }

    @Override
    public USB getUSB() {
        return this.usb;
    }

    @Override
    public String getStoreName() {
        return this.storeName;
    }

    @Override
    @JsonIgnore
    public ANFCryptoToken getToken() {
        return this.instance;
    }

    @Override
    public X509Certificate[] getChain() {
        return this.chain;
    }

    public String toString() {
        return this.storeName + " alias:" + this.alias + " SN:" + this.certSerialNumber + " Cert:" + this.cert.getSubjectX500Principal();
    }
}

