/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.credentials.impl;

import com.anf.cryptotoken.api.sign.exception.CertificateCredentialException;
import com.anf.cryptotoken.auth.PasswordContainer;
import com.anf.cryptotoken.auth.PasswordContainerFactory;
import com.anf.cryptotoken.credentials.CredentialErrorTranslator;
import com.anf.cryptotoken.credentials.CredentialsHandler;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.ui.keyboard.KeyBoard;
import com.anf.cryptotoken.ui.keyboard.behaviour.impl.PasswordCounterBehaviour;
import com.anf.cryptotoken.ui.message.MessageController;
import com.anf.ws.credential.client.interfaces.IClient;
import com.anf.ws.credential.client.model.CertificateInfo;
import com.anf.ws.credential.client.model.CredentialResponse;
import com.anf.ws.credential.json.model.Response;

public class VisualCredentialsHandler
implements CredentialsHandler {
    private static final Logger log = Logger.getLogger(VisualCredentialsHandler.class);
    private MessageController msgController;

    public VisualCredentialsHandler(MessageController msgController) {
        this.msgController = msgController;
    }

    @Override
    public void onSmsConfirmationSent(IClient client, CertificateInfo certInfo) {
        try {
            String pass = this.getVerificationCode(client, certInfo);
            char[] password = pass.toCharArray();
            String code = new String(password);
            System.out.println(code);
            CredentialResponse resp = client.checkCode(Integer.valueOf(code).intValue(), certInfo.getSerialCert());
            if (resp.isSucceded()) {
                if (resp.getResult().getCause().name().equals("OUT_OF_CHECKING_TIME")) {
                    throw new CertificateCredentialException(resp.getResult().getCause().name());
                }
                if (resp.getResult().getValue().equals("KO")) {
                    throw new CertificateCredentialException("ERR_WRONG_CODE");
                }
                log.info((Object)("CODE SMS OK " + certInfo.getSerialCert()));
            } else {
                this.onFailedResponse(resp);
            }
        }
        catch (CertificateCredentialException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateCredentialException(e.getMessage());
        }
    }

    private String translateErrorCode(String errorCode) {
        return CredentialErrorTranslator.translateErrorMessage(errorCode);
    }

    @Override
    public void onFailedResponse(CredentialResponse resp) {
        Response result = resp.getResult();
        throw new CertificateCredentialException("ERR_CREDENTIAL_RESPONSE_FAILED", (Throwable)(result == null ? null : new Exception(result.getCause() + ":" + result.getType() + ":" + result.getServerError().name())));
    }

    @Override
    public void onError(Throwable error, String message) {
        this.msgController.showErrorMessage(message, "Error");
    }

    public String getVerificationCode(IClient client, CertificateInfo certInfo) {
        PasswordCounterBehaviour<Boolean> boardBehaviour;
        String title;
        KeyBoard board = new KeyBoard();
        PasswordContainer passwordContainer = PasswordContainerFactory.getContainer();
        LoginResult<Boolean> result = board.showSMSKeyBoard(passwordContainer, title = this.translateErrorCode("TITLE_SMS"), event -> {
            CredentialResponse response2 = client.sendCodeSms(certInfo.getSerialCert());
            if (response2.isSucceded() && response2.getResult().getValue().equals("OK")) {
                this.msgController.showErrorMessage(this.translateErrorCode("SMS_RESENT_OK"), "Error");
            } else {
                this.msgController.showErrorMessage(this.translateErrorCode("SMS_RESENT_FAILED"), "Error");
            }
        }, boardBehaviour = new PasswordCounterBehaviour<Boolean>(login -> new LoginResult<Boolean>(login.getPin() != null), null, 1, 0, title));
        if (!result.getResult().booleanValue()) {
            throw new CertificateCredentialException("ERR_NO_SMS_CODE");
        }
        return passwordContainer.getPassword();
    }
}

