/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.config;

import com.fasterxml.jackson.annotation.JsonAlias;
import org.bouncycastle.util.encoders.Hex;

public class AtrObject {
    private String name = "";
    private String producer = "";
    @JsonAlias(value={"atr_value"})
    private String atrValue = "";
    @JsonAlias(value={"atr_vmask"})
    private String atrMask = "";
    @JsonAlias(value={"pkcs11_lib"})
    private String pkcs11 = "";

    public AtrObject() {
    }

    public AtrObject(String name, String producer, String atrValue, String atrMask, String pkcs11) {
        this.name = name;
        this.producer = producer;
        this.atrValue = atrValue;
        this.atrMask = atrMask;
        this.pkcs11 = pkcs11;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setProducer(String p) {
        this.producer = p;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setPkcs11(String p) {
        this.pkcs11 = p;
    }

    public String getPkcs11() {
        return this.pkcs11;
    }

    public boolean compare(byte[] atr) {
        byte[] atrVal = Hex.decode((String)this.atrValue);
        byte[] atrMask = Hex.decode((String)this.atrMask);
        if (atr.length != atrVal.length) {
            return false;
        }
        if (atrVal.length == 0 || this.atrMask.length() == 0) {
            return false;
        }
        for (int i = 0; i < atr.length; ++i) {
            if ((atr[i] & atrMask[i]) == (atrVal[i] & atrMask[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Token Details - ");
        sb.append("Name:").append(this.getName()).append(", ");
        sb.append("Producer:").append(this.getProducer()).append(", ");
        sb.append("Atr:").append(this.atrValue).append(", ");
        sb.append("Atr Mask:").append(this.atrMask).append(", ");
        sb.append("PKCS11:").append(this.getPkcs11()).append(".");
        return sb.toString();
    }
}

