/*
 * Decompiled with CFR 0.152.
 */
package gui;

import iso.ISOGeneral;
import iso.PowerISO;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import link.SMILink;

public class ISOUI
extends JFrame
implements Runnable {
    static SMILink link = new SMILink();
    static ISOGeneral mkiso = new PowerISO();
    JProgressBar bar = new JProgressBar(0, 100);

    public ISOUI() {
        this.setContentPane(new Panel(this));
        this.setSize(650, 350);
        this.setMinimumSize(new Dimension(650, 300));
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(ss.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(ss.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        this.setDefaultCloseOperation(3);
        this.setTitle("Im?genes ISO");
    }

    private void startPainting() {
        new Thread(){

            @Override
            public void run() {
                while (!ISOUI.this.isVisible()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("painting");
                ISOUI.this.setSize(ISOUI.this.getWidth() + 1, ISOUI.this.getHeight() + 1);
                ISOUI.this.repaint();
            }
        }.start();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.mcwin.McWinLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ISOUI ac = new ISOUI();
        ac.setVisible(true);
    }

    @Override
    public void run() {
        this.waitForMKISO();
        this.waitForMKISO();
        this.waitForMKISO();
        while (true) {
            this.waitForMKISO();
            this.bar.setValue((int)mkiso.getPercent());
            if (this.bar.getValue() == 100) break;
            this.repaint();
        }
    }

    private synchronized void waitForMKISO() {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static class Panel
    extends JPanel {
        JComboBox comboDisk = new JComboBox();
        JLabel devices = new JLabel("Dispositivos instalados:");
        JLabel srcDirL = new JLabel("Directorio fuente");
        JLabel destDirL = new JLabel("Directorio destino");
        JLabel isoNameL = new JLabel("Nombre de la imagen");
        JLabel isoPathL = new JLabel("Direcci?n de la imagen");
        JButton refresher = new JButton("Refrescar");
        JButton extractor = new JButton("Extraer");
        JButton create = new JButton("Crear imagen ISO");
        JButton burn = new JButton("Grabar en disco");
        JButton browseSrc = new JButton("Examinar...");
        JButton browseDest = new JButton("Examinar...");
        JButton browseISO = new JButton("Examinar...");
        JTextField inputDir = new JTextField();
        JTextField outputDir = new JTextField();
        JTextField isoName = new JTextField();
        JTextField isoPath = new JTextField();
        JFileChooser open1 = new JFileChooser(".");
        JFileChooser open2 = new JFileChooser(".");
        JFileChooser open3 = new JFileChooser(".");
        ISOUI ac;
        char[] sysInfo = link.getSysInfo(null, null);
        boolean logged = this.sysInfo.length > 0 ? link.getLockStatus(this.sysInfo[0]) : false;

        public Panel(ISOUI ac) {
            this.ac = ac;
            this.setLayout(null);
            this.add(this.inputDir);
            this.add(this.outputDir);
            this.add(this.isoName);
            this.add(this.isoPath);
            this.add(this.isoPathL);
            this.add(this.browseISO);
            this.add(this.destDirL);
            this.add(this.srcDirL);
            this.add(this.isoNameL);
            this.add(this.browseSrc);
            this.add(this.browseDest);
            this.add(this.create);
            this.add(this.burn);
            this.burn.setEnabled(false);
            this.add(ac.bar);
            this.isoPath.setEditable(false);
            this.inputDir.setEditable(false);
            this.outputDir.setEditable(false);
            ac.bar.setString("Progreso en la creaci?n de la imagen ISO");
            ac.bar.setStringPainted(true);
            int w = this.getWidth();
            int h = this.getHeight();
            int tw = 100;
            int th = 20;
            this.comboDisk.setBounds(w / 2 - tw / 2, 40, tw, th);
            this.actions();
            this.enableAction();
            new Thread(){

                @Override
                public void run() {
                    while (!this.isVisible()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.refresh();
                }
            }.start();
        }

        private void actions() {
            this.comboDisk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int si = comboDisk.getSelectedIndex();
                    if (si < 0 || si < sysInfo.length) {
                        // empty if block
                    }
                }
            });
            this.browseISO.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    open3.setFileSelectionMode(0);
                    open3.setFileFilter(new FileNameExtensionFilter("Imagen ISO", "iso"));
                    open3.setAcceptAllFileFilterUsed(false);
                    open3.setMultiSelectionEnabled(false);
                    int val = open3.showOpenDialog(this);
                    if (val == 0) {
                        if (open3.getSelectedFile() != null) {
                            isoPath.setText(open3.getSelectedFile().getAbsolutePath());
                        }
                        this.enableAction();
                    }
                }
            });
            this.browseSrc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    open1.setFileSelectionMode(1);
                    open1.setMultiSelectionEnabled(false);
                    int val = open1.showOpenDialog(this);
                    if (val == 0) {
                        if (open1.getSelectedFile() != null) {
                            inputDir.setText(open1.getSelectedFile().getAbsolutePath());
                        }
                        this.enableAction();
                    }
                }
            });
            this.browseDest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    open2.setFileSelectionMode(1);
                    open2.setMultiSelectionEnabled(false);
                    int val = open2.showOpenDialog(this);
                    if (val == 0) {
                        if (open2.getSelectedFile() != null) {
                            outputDir.setText(open2.getSelectedFile().getAbsolutePath());
                        }
                        this.enableAction();
                    }
                }
            });
            this.refresher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.refresh();
                }
            });
            this.extractor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int si = comboDisk.getSelectedIndex();
                    if (si >= 0 && si < sysInfo.length) {
                        link.doSafeRemove(sysInfo[si]);
                        this.refresh();
                    }
                }
            });
            this.create.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            create.setEnabled(false);
                            burn.setEnabled(false);
                            int generateISO = mkiso.createISO(new File(inputDir.getText()), new File(outputDir.getText()), isoName.getText());
                            if (generateISO == 0) {
                                JOptionPane.showMessageDialog(this, "Se ha creado la imagen exitosamente", "Informaci?n", 1);
                            } else {
                                JOptionPane.showMessageDialog(this, "Ha ocurrido un error en la creaci?n de la imagen", "Error", 0);
                            }
                            ac.bar.setValue(0);
                            this.enableAction();
                            burn.setEnabled(true);
                        }
                    }.start();
                    new Thread(ac).start();
                }
            });
            this.burn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    burn.setEnabled(false);
                    create.setEnabled(false);
                    boolean writeToCDROM = link.writeToCDROM(outputDir.getText() + File.separator + isoName.getText() + ".iso", true, '\u0000');
                    if (writeToCDROM) {
                        JOptionPane.showMessageDialog(this, "Se ha grabado la imagen exitosamente\nPor favor, reinserte el disco para actualizar la informaci?n grabada", "Informaci?n", 1);
                    } else {
                        JOptionPane.showMessageDialog(this, "La imagen no ha podido ser grabada en el disco", "Error", 0);
                    }
                    this.enableAction();
                    burn.setEnabled(true);
                }
            });
            this.isoName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    File file;
                    if (!outputDir.getText().isEmpty() && new File(outputDir.getText()).exists() && (file = new File(outputDir.getText() + File.separator + isoName.getText() + ".iso")).exists()) {
                        isoPath.setText(file.getAbsolutePath());
                    }
                    this.enableAction();
                }
            });
        }

        private void refresh() {
            this.sysInfo = link.getSysInfo(null, null);
            this.comboDisk.removeAllItems();
            if (this.sysInfo.length > 0) {
                this.comboDisk.setEnabled(true);
                this.extractor.setEnabled(true);
                for (int i = 0; i < this.sysInfo.length; ++i) {
                    this.comboDisk.addItem(("" + this.sysInfo[i]).trim());
                }
                this.enableAction();
            } else {
                this.comboDisk.setEnabled(false);
                this.extractor.setEnabled(false);
            }
        }

        private void enableAction() {
            this.create.setEnabled(!this.outputDir.getText().isEmpty() && new File(this.outputDir.getText()).exists() && !this.inputDir.getText().isEmpty() && new File(this.inputDir.getText()).exists() && !this.isoName.getText().isEmpty());
            this.burn.setEnabled(!this.isoPath.getText().isEmpty());
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            int tw = 140;
            int th = 20;
            this.devices.setBounds(w / 2 - tw / 2, 15, tw, th);
            tw = 100;
            this.comboDisk.setBounds(w / 2 - tw / 2, 40, tw, th);
            this.refresher.setBounds(w / 2 - tw / 2, 70, tw, th);
            this.extractor.setBounds(w / 2 - tw / 2, 100, tw, th);
            tw = w - 300;
            this.inputDir.setBounds(w / 2 - tw / 2, 20, tw, th);
            this.outputDir.setBounds(w / 2 - tw / 2, 60, tw, th);
            this.isoName.setBounds(w / 2 - tw / 2, 100, tw, th);
            tw = 250;
            this.srcDirL.setBounds(this.inputDir.getX() - tw / 2, this.inputDir.getY(), tw, th);
            this.destDirL.setBounds(this.outputDir.getX() - tw / 2, this.outputDir.getY(), tw, th);
            this.isoNameL.setBounds(this.isoName.getX() - tw / 2, this.isoName.getY(), tw, th);
            tw = 100;
            this.browseSrc.setBounds(this.inputDir.getX() + this.inputDir.getWidth() + 10, this.inputDir.getY(), tw, th);
            this.browseDest.setBounds(this.outputDir.getX() + this.inputDir.getWidth() + 10, this.outputDir.getY(), tw, th);
            tw = 150;
            this.create.setBounds(w / 2 - tw / 2, this.isoName.getY() + this.isoName.getHeight() + 20, tw, th);
            tw = w - 300;
            this.isoPath.setBounds(w / 2 - tw / 2, this.burn.getY() + this.burn.getHeight() + 20, tw, th);
            tw = 270;
            this.isoPathL.setBounds(this.isoPath.getX() - tw / 2, this.burn.getY() + this.burn.getHeight() + 20, tw, th);
            tw = 100;
            this.browseISO.setBounds(this.isoPath.getX() + this.isoPath.getWidth() + 10, this.isoPath.getY(), tw, th);
            tw = w - 100;
            this.ac.bar.setBounds(w / 2 - tw / 2, this.create.getY() + this.create.getHeight() + 20, tw, th);
            tw = 150;
            this.burn.setBounds(w / 2 - tw / 2, this.ac.bar.getY() + this.ac.bar.getHeight() + 20, tw, th);
            if (this.logged) {
                // empty if block
            }
            super.paint(g);
        }
    }
}

