/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.JNIPanel;
import iso.ISOGeneral;
import iso.PowerISO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import link.SMILink;

public class FilesToISOPanel
extends JNIPanel {
    private static final long serialVersionUID = 1L;
    JPanel outputISOP = new JPanel(null);
    JPanel filesP = new JPanel(null);
    JTextField outputISOT = new JTextField(new File("").getAbsolutePath());
    JTextField outputISONameT = new JTextField();
    JLabel outputISONameL = new JLabel("Nombre de la imagen:");
    JButton browseFiles = new JButton("+ A?adir archivos...");
    JButton deleteFiles = new JButton("Eliminar selecci?n");
    JButton browseOutputISO = new JButton("Examinar...");
    JButton create = new JButton("Crear imagen ISO");
    JProgressBar bar = new JProgressBar(0, 100);
    DefaultTableModel model = new DefaultTableModel(null, new String[]{"Direcc??n del archivo"}){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    JTable filesT = new JTable(this.model);
    JScrollPane scroll = new JScrollPane(this.filesT);
    JPanel cont = new JPanel();
    SMILink link = new SMILink();
    ISOGeneral iso = new PowerISO();

    public FilesToISOPanel(boolean run, boolean start) {
        super(run, start);
        this.add(this.outputISOP);
        this.add(this.filesP);
        this.outputISOP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Direcci?n de la imagen a crear", 2, 2));
        this.filesP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Selecci?n de archivos", 2, 2));
        this.filesP.add(this.browseFiles);
        this.filesP.add(this.deleteFiles);
        this.outputISOP.add(this.outputISOT);
        this.outputISOP.add(this.browseOutputISO);
        this.outputISOP.add(this.outputISONameL);
        this.outputISOP.add(this.outputISONameT);
        this.add(this.create);
        this.add(this.bar);
        this.bar.setString("Progreso");
        this.bar.setStringPainted(true);
        this.outputISOT.setEditable(false);
        GroupLayout layout = new GroupLayout(this.cont);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 10, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 10, Short.MAX_VALUE));
        this.cont.setLayout(layout);
        this.filesP.add(this.cont);
        this.actions();
        this.enableAction();
    }

    @Override
    protected void actions() {
        this.outputISONameT.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FilesToISOPanel.this.enableAction();
            }
        });
        this.filesT.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    FilesToISOPanel.this.deleteFiles();
                }
                FilesToISOPanel.this.enableAction();
            }
        });
        this.filesT.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FilesToISOPanel.this.enableAction();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FilesToISOPanel.this.enableAction();
            }
        });
        this.deleteFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilesToISOPanel.this.deleteFiles();
            }
        });
        this.browseFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser opener = new JFileChooser(".");
                opener.setFileSelectionMode(2);
                opener.setMultiSelectionEnabled(true);
                int v = opener.showOpenDialog(FilesToISOPanel.this);
                if (v == 0 && opener.getSelectedFiles() != null && opener.getSelectedFiles().length > 0) {
                    File[] listFiles = opener.getSelectedFiles();
                    if (listFiles == null || listFiles.length == 0) {
                        JOptionPane.showMessageDialog(FilesToISOPanel.this, "Debe seleccionar al menos un archivo", "Error", 0);
                    } else {
                        FilesToISOPanel.this.fill(listFiles);
                    }
                }
            }
        });
        this.browseOutputISO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v;
                JFileChooser opener = new JFileChooser(".");
                opener.setFileSelectionMode(1);
                opener.setMultiSelectionEnabled(false);
                opener.setAcceptAllFileFilterUsed(false);
                File dir = new File(FilesToISOPanel.this.outputISOT.getText());
                if (dir.exists()) {
                    opener.setCurrentDirectory(dir);
                }
                if ((v = opener.showOpenDialog(FilesToISOPanel.this)) == 0) {
                    if (opener.getSelectedFile() != null && opener.getSelectedFile().exists() && opener.getSelectedFile().isDirectory()) {
                        FilesToISOPanel.this.outputISOT.setText(opener.getSelectedFile().getAbsolutePath());
                    } else {
                        JOptionPane.showMessageDialog(FilesToISOPanel.this, "El directorio no existe", "Error", 0);
                    }
                }
            }
        });
        this.create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        String isoName = null;
                        isoName = FilesToISOPanel.this.outputISONameT.getText();
                        String iso = FilesToISOPanel.this.outputISOT.getText();
                        Set<String> tableSet = FilesToISOPanel.this.getTableSet();
                        File[] list = new File[tableSet.size()];
                        int i = 0;
                        for (String fn : tableSet) {
                            list[i++] = new File(fn);
                        }
                        File outputDir = new File(iso);
                        if (outputDir.exists() && outputDir.isDirectory()) {
                            FilesToISOPanel.this.iso.setPercent(0.0);
                            FilesToISOPanel.this.iso.setMessage("Creando imagen ISO");
                            FilesToISOPanel.this.iso.setEndProccess(false);
                            new Thread(FilesToISOPanel.this).start();
                            int createISO = FilesToISOPanel.this.iso.createISO(list, outputDir, isoName);
                            FilesToISOPanel.this.iso.setEndProccess(true);
                            FilesToISOPanel.this.bar.setString("Progreso");
                            if (createISO == 0) {
                                JOptionPane.showMessageDialog(FilesToISOPanel.this, "Se ha creado la imagen ISO exitosamente", "Actualizaci?n completada", 1);
                            } else {
                                JOptionPane.showMessageDialog(FilesToISOPanel.this, "No se creado la imagen ISO", "Error", 0);
                            }
                        }
                    }
                }.start();
            }
        });
    }

    private void deleteFiles() {
        if (this.filesT.getSelectedRowCount() > 0) {
            int[] selectedRows = this.filesT.getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                this.model.removeRow(selectedRows[i]);
            }
        }
    }

    protected void fill(File[] listFiles) {
        Set<String> set = this.getTableSet();
        for (int i = 0; i < listFiles.length; ++i) {
            File file = listFiles[i];
            if (!set.add(file.toString())) continue;
            this.model.addRow(new Object[]{file});
        }
        this.enableAction();
    }

    private Set<String> getTableSet() {
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            set.add(this.model.getValueAt(i, 0).toString());
        }
        return set;
    }

    @Override
    protected void enableAction() {
        this.deleteFiles.setEnabled(this.filesT.getSelectedRowCount() > 0);
        this.create.setEnabled(this.model.getRowCount() > 0 && !this.outputISONameT.getText().isEmpty());
    }

    @Override
    protected void init() {
        this.setMinimumSize(new Dimension(400, 400));
        this.title = "Crear imagen ISO desde archivos";
        this.setSize(500, 400);
        super.init();
    }

    @Override
    protected void updateBounds() {
        int w = this.getWidth();
        int h = this.getHeight();
        int w2 = w / 2;
        int ww = w - 20;
        int fh = h - 200;
        this.filesP.setBounds(w2 - ww / 2, 20, ww, fh);
        this.cont.setBounds(20, 20, ww - 40, fh - 60);
        ww = 140;
        this.browseFiles.setBounds(w2 - ww - 10, fh - 30, ww, 20);
        this.deleteFiles.setBounds(w2 + 10, fh - 30, ww, 20);
        ww = w - 20;
        this.outputISOP.setBounds(w2 - ww / 2, h - 150, ww, 80);
        ww = w - 180;
        this.outputISOT.setBounds(20, 20, ww, 20);
        this.outputISONameL.setBounds(this.outputISOT.getX(), this.outputISOT.getY() + this.outputISOT.getHeight() + 5, 130, 20);
        this.outputISONameT.setBounds(this.outputISONameL.getX() + this.outputISONameL.getWidth(), this.outputISONameL.getY(), this.outputISOT.getWidth() - this.outputISONameL.getWidth(), 20);
        this.browseOutputISO.setBounds(this.outputISOT.getX() + this.outputISOT.getWidth() + 10, this.outputISOT.getY(), 100, 20);
        ww = 150;
        this.create.setBounds(w / 2 - ww / 2, this.outputISOP.getY() + this.outputISOP.getHeight() + 10, ww, 20);
        ww = w - 20;
        this.bar.setBounds(w / 2 - ww / 2, this.create.getY() + this.create.getHeight() + 10, ww, 20);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateDir(String text) {
        File dir = new File(text);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] listFiles = dir.listFiles();
                if (listFiles != null && listFiles.length != 0) return dir.getAbsolutePath();
                JOptionPane.showMessageDialog(this, "El directorio est? vac?o", "Error", 0);
                return null;
            } else {
                JOptionPane.showMessageDialog(this, "El archivo seleccionado no es un directorio", "Error", 0);
            }
            return null;
        } else {
            JOptionPane.showMessageDialog(this, "El directorio no existe", "Error", 0);
        }
        return null;
    }

    @Override
    public void run() {
        this.sleep();
        this.sleep();
        this.sleep();
        do {
            this.sleep();
            System.out.println("bar=" + this.iso.getPercent());
            this.bar.setValue((int)this.iso.getPercent());
            this.bar.setString(this.iso.getMessage());
            this.repaint();
        } while (!this.iso.endProccess());
        this.iso.setPercent(0.0);
        this.bar.setString("Progreso");
        this.bar.setValue(0);
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.mcwin.McWinLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FilesToISOPanel.showFrame(new FilesToISOPanel(true, false));
    }

    private static void copyFile() {
        String name = "Presentaci?n(1).mpg";
        File f = new File("h:" + File.separator + name);
        if (f.exists()) {
            try {
                RandomAccessFile r = new RandomAccessFile(f, "r");
                File file = new File("c:" + File.separator + name);
                RandomAccessFile r2 = new RandomAccessFile(file, "rw");
                long l = 1000000L;
                long o = r2.length();
                r2.seek(o);
                byte[] b = new byte[(int)l];
                long fl = r.length();
                if (o < fl) {
                    int i = 0;
                    while ((long)i <= fl / l) {
                        r.seek(o);
                        r.read(b, 0, (int)l);
                        r2.write(b);
                        l = Math.min(fl - (o += l), l);
                        Thread.sleep(2000L);
                        System.out.println("escritos " + o / 1024L / 1024L + " megabytes");
                        ++i;
                    }
                }
                r.close();
                r2.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println();
        }
    }
}

