/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import link.SMILink;

public class AccesControl
extends JFrame {
    static SMILink link = new SMILink();

    public AccesControl() {
        this.setContentPane(new Panel(this));
        this.setSize(400, 300);
        this.setMinimumSize(new Dimension(400, 300));
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(ss.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(ss.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        this.setDefaultCloseOperation(3);
        this.setTitle("Control de acceso");
    }

    private void startPainting() {
        new Thread(){

            @Override
            public void run() {
                while (!AccesControl.this.isVisible()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("painting");
                AccesControl.this.setSize(AccesControl.this.getWidth() + 1, AccesControl.this.getHeight() + 1);
                AccesControl.this.repaint();
            }
        }.start();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.mcwin.McWinLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AccesControl ac = new AccesControl();
        ac.setVisible(true);
    }

    static class Panel
    extends JPanel {
        JComboBox comboDisk = new JComboBox();
        JLabel devices = new JLabel("Dispositivos instalados:");
        JLabel passL = new JLabel("Contrasena para ingresar:");
        JButton refresher = new JButton("Refrescar");
        JButton extractor = new JButton("Extraer");
        JButton login = new JButton("Entrar");
        JButton logout = new JButton("Salir");
        JTextField pass = new JTextField();
        AccesControl ac;
        char[] sysInfo = link.getSysInfo(null, null);
        boolean logged = this.sysInfo.length > 0 ? link.getLockStatus(this.sysInfo[0]) : false;

        public Panel(AccesControl ac) {
            this.ac = ac;
            this.setLayout(null);
            this.add(this.devices);
            this.add(this.comboDisk);
            this.add(this.refresher);
            this.add(this.extractor);
            this.add(this.pass);
            this.add(this.passL);
            this.add(this.login);
            this.add(this.logout);
            int w = this.getWidth();
            int h = this.getHeight();
            int tw = 100;
            int th = 20;
            this.comboDisk.setBounds(w / 2 - tw / 2, 40, tw, th);
            this.actions();
            new Thread(){

                @Override
                public void run() {
                    while (!this.isVisible()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.refresh();
                }
            }.start();
        }

        private void actions() {
            this.comboDisk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int si = comboDisk.getSelectedIndex();
                    if (si >= 0 && si < sysInfo.length) {
                        ac.setTitle("Control de acceso a: " + sysInfo[si]);
                        this.enableAction();
                    }
                }
            });
            this.refresher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.refresh();
                }
            });
            this.extractor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int si = comboDisk.getSelectedIndex();
                    if (si >= 0 && si < sysInfo.length) {
                        link.doSafeRemove(sysInfo[si]);
                        this.refresh();
                    }
                }
            });
            this.login.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int si = comboDisk.getSelectedIndex();
                    if (si >= 0 && si < sysInfo.length) {
                        if (link.login(pass.getText(), sysInfo[si])) {
                            JOptionPane.showMessageDialog(ac, "Ha entrado exitosamente", "Confirmaci?n", 1);
                            this.refresh();
                        } else {
                            JOptionPane.showMessageDialog(ac, "Contrase?a incorrecta", "Error", 0);
                        }
                    }
                }
            });
            this.logout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int si = comboDisk.getSelectedIndex();
                    if (si >= 0 && si < sysInfo.length) {
                        if (link.logout(sysInfo[si])) {
                            JOptionPane.showMessageDialog(ac, "Ha salido exitosamente", "Confirmaci?n", 1);
                            this.refresh();
                        } else {
                            JOptionPane.showMessageDialog(ac, "No se ha podido salir", "Error", 0);
                        }
                    }
                }
            });
        }

        private void refresh() {
            this.sysInfo = link.getSysInfo(null, null);
            this.comboDisk.removeAllItems();
            if (this.sysInfo.length > 0) {
                this.comboDisk.setEnabled(true);
                this.extractor.setEnabled(true);
                for (int i = 0; i < this.sysInfo.length; ++i) {
                    this.comboDisk.addItem(("" + this.sysInfo[i]).trim());
                }
                this.ac.setTitle("Control de acceso a: " + this.sysInfo[0]);
                this.enableAction();
            } else {
                this.comboDisk.setEnabled(false);
                this.extractor.setEnabled(false);
            }
        }

        private void enableAction() {
            int si = this.comboDisk.getSelectedIndex();
            if (si >= 0 && si < this.sysInfo.length) {
                this.logged = link.getLockStatus(this.sysInfo[si]);
                this.login.setEnabled(!this.logged);
                this.logout.setEnabled(this.logged);
                this.pass.setEnabled(!this.logged);
            }
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            int tw = 140;
            int th = 20;
            this.devices.setBounds(w / 2 - tw / 2, 15, tw, th);
            tw = 100;
            this.comboDisk.setBounds(w / 2 - tw / 2, 40, tw, th);
            this.refresher.setBounds(w / 2 - tw / 2, 70, tw, th);
            this.extractor.setBounds(w / 2 - tw / 2, 100, tw, th);
            tw = 150;
            this.passL.setBounds(w / 2 - tw / 2, h - 130, tw, th);
            tw = 200;
            this.pass.setBounds(w / 2 - tw / 2, h - 110, tw, th);
            tw = 100;
            this.login.setBounds(w / 2 - tw / 2, h - 70, tw, th);
            this.logout.setBounds(w / 2 - tw / 2, h - 40, tw, th);
            if (this.logged) {
                // empty if block
            }
            super.paint(g);
        }
    }
}

