/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.verifier.key.impl;

import com.anf.oauth.verifier.key.KeyDownloader;
import com.anf.oauth.verifier.key.KeyProvider;
import com.anf.oauth.verifier.key.impl.WellKnownKeyDownloader;
import java.security.PublicKey;
import java.util.Map;
import java.util.TreeMap;

public class CachedMapKeyProvider
implements KeyProvider {
    private final String defaultIssuer = "restapi";
    private Map<String, KeyDownloader> map = new TreeMap<String, KeyDownloader>();

    public CachedMapKeyProvider(KeyDownloader defaultDownloader) {
        this.map.put("restapi", defaultDownloader);
    }

    public CachedMapKeyProvider() {
    }

    @Override
    public PublicKey getKey(String keyId, String issuer) {
        KeyDownloader keyProvider;
        if (issuer == null) {
            issuer = "restapi";
        }
        if ((keyProvider = this.map.get(issuer)) == null) {
            keyProvider = new WellKnownKeyDownloader(issuer);
            this.map.put(issuer, keyProvider);
        }
        PublicKey publicKey = keyProvider.downloadKey(keyId);
        return publicKey;
    }
}

