/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiDateDeserializer
extends StdDeserializer<Date> {
    private static final Logger log = LogManager.getLogger(MultiDateDeserializer.class);
    private static final long serialVersionUID = 1L;
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.S z", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH-mm-ss", "yyyy:MM:dd HH:mm:ss", "yyyy-MM-dd", "yyyy:MM:dd", "dd-MM-yyyy HH:mm:ss"};

    public MultiDateDeserializer() {
        this(null);
    }

    public MultiDateDeserializer(Class<?> vc) {
        super(vc);
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return this.deserialize(jp, ctxt, node);
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt, JsonNode node) throws JsonParseException {
        String date = node.textValue();
        if (date != null && date.isBlank()) {
            return null;
        }
        if (date == null && node.canConvertToLong()) {
            return new Date(node.asLong());
        }
        DateFormat dateFormat = ctxt.getConfig().getDateFormat();
        try {
            if (dateFormat != null) {
                return ((DateFormat)dateFormat.clone()).parse(date);
            }
        }
        catch (Exception e1) {
            log.debug("no se pudo parsear la fecha {} con el formato por defecto: {}. el error es: {}", (Object)date, (Object)dateFormat, (Object)e1.getMessage());
        }
        for (String DATE_FORMAT : DATE_FORMATS) {
            try {
                return new SimpleDateFormat(DATE_FORMAT).parse(date);
            }
            catch (Exception e) {
                log.debug("no se pudo parsear la fecha {} con el formato: {}. el error es: {}", (Object)date, (Object)DATE_FORMAT, (Object)e.getMessage());
            }
        }
        throw new JsonParseException(jp, "Unparseable date: \"" + date + "\". Supported formats: " + Arrays.toString(DATE_FORMATS));
    }
}

