/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.json;

import com.anf.oauth.json.MultiDateDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarDeserializer
extends JsonDeserializer<Calendar> {
    MultiDateDeserializer dateDeserializer = new MultiDateDeserializer();

    public Calendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        try {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            JsonNode timeField = node.get("time");
            JsonNode zoneField = node.get("timezone");
            if (timeField != null) {
                Date date = new Date(timeField.asLong());
                String timezone = zoneField != null ? zoneField.textValue() : TimeZone.getDefault().getID();
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(timezone));
                calendar.setTime(date);
                return calendar;
            }
            Date date = this.dateDeserializer.deserialize(jsonParser, deserializationContext, node);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

