/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.client.impl;

import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.client.PublicKeyClient;
import com.anf.oauth.client.exception.OauthClientException;
import com.anf.oauth.json.CredentialRequest;
import com.anf.oauth.json.JSONFactory;
import com.anf.oauth.json.PublicKeyResponse;
import com.anf.oauth.verifier.key.impl.PublicKeyUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Base64;

public class PublicKeyClientRestApiImpl
extends AbstractClient
implements PublicKeyClient {
    public PublicKeyClientRestApiImpl(String url, long timeout) {
        super(url, timeout);
    }

    @Override
    public PublicKey getPublicKey(CredentialRequest request) throws Throwable {
        URL urlConn = new URL(this.url + "api/oauth/public-key");
        HttpURLConnection httpConn = (HttpURLConnection)urlConn.openConnection();
        httpConn.setConnectTimeout((int)this.timeout);
        httpConn.setReadTimeout((int)this.timeout);
        httpConn.setDoInput(true);
        httpConn.setDoOutput(true);
        httpConn.setRequestProperty("Content-type", "application/json");
        httpConn.setRequestMethod("POST");
        String json = JSONFactory.buildJSON(request);
        OutputStream os = httpConn.getOutputStream();
        os.write(json.getBytes());
        os.flush();
        byte[] content = IOUtils.toByteArray((InputStream)httpConn.getInputStream());
        httpConn.disconnect();
        PublicKeyResponse resp = JSONFactory.buildObject(content, PublicKeyResponse.class);
        if (resp.isSuccess()) {
            RSAPublicKey key = (RSAPublicKey)PublicKeyUtils.getPublicKey(new ByteArrayInputStream(Base64.decode((String)resp.getKey())));
            if (key != null) {
                return key;
            }
        } else {
            throw new OauthClientException(resp.getError());
        }
        return null;
    }
}

