/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pdf.PdfMemoryUsageSetting;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxScreenshotBuilder;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Objects;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public final class PdfBoxUtils {
    private PdfBoxUtils() {
    }

    @Deprecated
    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, int page) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, (char[])null, page);
    }

    @Deprecated
    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, String passwordProtection, int page) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, passwordProtection, page, PAdESUtils.initializeDSSResourcesHandler());
    }

    @Deprecated
    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, char[] passwordProtection, int page) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, passwordProtection, page, PAdESUtils.initializeDSSResourcesHandler());
    }

    @Deprecated
    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, String passwordProtection, int page, DSSResourcesHandler dssResourcesHandler) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, passwordProtection != null ? passwordProtection.toCharArray() : null, page, dssResourcesHandler);
    }

    @Deprecated
    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, char[] passwordProtection, int page, DSSResourcesHandler dssResourcesHandler) {
        return PdfBoxScreenshotBuilder.fromDocument(pdfDocument, passwordProtection).generateScreenshot(page, dssResourcesHandler);
    }

    @Deprecated
    public static BufferedImage generateBufferedImageScreenshot(DSSDocument pdfDocument, String passwordProtection, int page) {
        return PdfBoxUtils.generateBufferedImageScreenshot(pdfDocument, passwordProtection != null ? passwordProtection.toCharArray() : null, page);
    }

    @Deprecated
    public static BufferedImage generateBufferedImageScreenshot(DSSDocument pdfDocument, char[] passwordProtection, int page) {
        return PdfBoxScreenshotBuilder.fromDocument(pdfDocument, passwordProtection).generateBufferedImageScreenshot(page);
    }

    @Deprecated
    public static DSSDocument generateSubtractionImage(DSSDocument document1, DSSDocument document2, int page) {
        return PdfBoxUtils.generateSubtractionImage(document1, (char[])null, page, document2, (char[])null, page);
    }

    @Deprecated
    public static DSSDocument generateSubtractionImage(DSSDocument document1, String passwordDocument1, int pageDocument1, DSSDocument document2, String passwordDocument2, int pageDocument2) {
        return PdfBoxUtils.generateSubtractionImage(document1, passwordDocument1, pageDocument1, document2, passwordDocument2, pageDocument2, PAdESUtils.initializeDSSResourcesHandler());
    }

    @Deprecated
    public static DSSDocument generateSubtractionImage(DSSDocument document1, char[] passwordDocument1, int pageDocument1, DSSDocument document2, char[] passwordDocument2, int pageDocument2) {
        return PdfBoxUtils.generateSubtractionImage(document1, passwordDocument1, pageDocument1, document2, passwordDocument2, pageDocument2, PAdESUtils.initializeDSSResourcesHandler());
    }

    @Deprecated
    public static DSSDocument generateSubtractionImage(DSSDocument document1, String passwordDocument1, int pageDocument1, DSSDocument document2, String passwordDocument2, int pageDocument2, DSSResourcesHandler dssResourcesHandler) {
        return PdfBoxUtils.generateSubtractionImage(document1, passwordDocument1 != null ? passwordDocument1.toCharArray() : null, pageDocument1, document2, passwordDocument2 != null ? passwordDocument2.toCharArray() : null, pageDocument2, dssResourcesHandler);
    }

    @Deprecated
    public static DSSDocument generateSubtractionImage(DSSDocument document1, char[] passwordDocument1, int pageDocument1, DSSDocument document2, char[] passwordDocument2, int pageDocument2, DSSResourcesHandler dssResourcesHandler) {
        BufferedImage screenshotDoc1 = PdfBoxUtils.generateBufferedImageScreenshot(document1, passwordDocument1, pageDocument1);
        BufferedImage screenshotDoc2 = PdfBoxUtils.generateBufferedImageScreenshot(document2, passwordDocument2, pageDocument2);
        int width = Math.max(screenshotDoc1.getWidth(), screenshotDoc2.getWidth());
        int height = Math.max(screenshotDoc1.getHeight(), screenshotDoc2.getHeight());
        BufferedImage outputImage = PdfBoxUtils.getOutputImage(width, height);
        ImageUtils.drawSubtractionImage((BufferedImage)screenshotDoc1, (BufferedImage)screenshotDoc2, (BufferedImage)outputImage);
        return ImageUtils.toDSSDocument((BufferedImage)outputImage, (DSSResourcesHandler)dssResourcesHandler);
    }

    public static DSSDocument generateSubtractionImage(BufferedImage screenshotDoc1, BufferedImage screenshotDoc2) {
        return PdfBoxUtils.generateSubtractionImage(screenshotDoc1, screenshotDoc2, PAdESUtils.initializeDSSResourcesHandler());
    }

    public static DSSDocument generateSubtractionImage(BufferedImage screenshotDoc1, BufferedImage screenshotDoc2, DSSResourcesHandler dssResourcesHandler) {
        int width = Math.max(screenshotDoc1.getWidth(), screenshotDoc2.getWidth());
        int height = Math.max(screenshotDoc1.getHeight(), screenshotDoc2.getHeight());
        BufferedImage outputImage = PdfBoxUtils.getOutputImage(width, height);
        ImageUtils.drawSubtractionImage((BufferedImage)screenshotDoc1, (BufferedImage)screenshotDoc2, (BufferedImage)outputImage);
        return ImageUtils.toDSSDocument((BufferedImage)outputImage, (DSSResourcesHandler)dssResourcesHandler);
    }

    private static BufferedImage getOutputImage(int width, int height) {
        BufferedImage outputImage = new BufferedImage(width, height, 1);
        Graphics2D drawer = outputImage.createGraphics();
        drawer.setBackground(Color.WHITE);
        drawer.clearRect(0, 0, width, height);
        return outputImage;
    }

    public static PDAppearanceDictionary createSignatureAppearanceDictionary(PDDocument pdDocument, PDRectangle pdRectangle) {
        Objects.requireNonNull(pdDocument, "PDDocument cannot be null!");
        Objects.requireNonNull(pdRectangle, "PDRectangle cannot be null!");
        PDStream stream = new PDStream(pdDocument);
        PDFormXObject form = new PDFormXObject(stream);
        PDResources res = new PDResources();
        form.setResources(res);
        form.setFormType(1);
        form.setBBox(new PDRectangle(pdRectangle.getWidth(), pdRectangle.getHeight()));
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
        appearance.setNormalAppearance(appearanceStream);
        return appearance;
    }

    public static MemoryUsageSetting getMemoryUsageSetting(PdfMemoryUsageSetting pdfMemoryUsageSetting) {
        switch (pdfMemoryUsageSetting.getMode()) {
            case MEMORY_FULL: {
                return MemoryUsageSetting.setupMainMemoryOnly();
            }
            case MEMORY_BUFFERED: {
                return MemoryUsageSetting.setupMainMemoryOnly((long)pdfMemoryUsageSetting.getMaxMemoryBytes());
            }
            case FILE: {
                return MemoryUsageSetting.setupTempFileOnly((long)pdfMemoryUsageSetting.getMaxStorageBytes());
            }
            case MIXED: {
                return MemoryUsageSetting.setupMixed((long)pdfMemoryUsageSetting.getMaxMemoryBytes(), (long)pdfMemoryUsageSetting.getMaxStorageBytes());
            }
        }
        throw new UnsupportedOperationException(String.format("The MemoryUsageSetting mode '%s' is not supported!", pdfMemoryUsageSetting.getMode()));
    }
}

