/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pdf.PdfMemoryUsageSetting;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDocumentReader;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;

public class PdfBoxScreenshotBuilder {
    private final DSSDocument pdfDocument;
    private final char[] passwordProtection;
    private DSSResourcesHandlerBuilder dssResourcesHandlerBuilder;
    private PdfMemoryUsageSetting memoryUsageSetting;

    protected PdfBoxScreenshotBuilder(DSSDocument pdfDocument) {
        this(pdfDocument, null);
    }

    protected PdfBoxScreenshotBuilder(DSSDocument pdfDocument, char[] passwordProtection) {
        Objects.requireNonNull(pdfDocument, "PDF Document shall be defined!");
        this.pdfDocument = pdfDocument;
        this.passwordProtection = passwordProtection;
    }

    public PdfBoxScreenshotBuilder setDSSResourcesHandlerBuilder(DSSResourcesHandlerBuilder dssResourcesHandlerBuilder) {
        this.dssResourcesHandlerBuilder = dssResourcesHandlerBuilder;
        return this;
    }

    protected PdfMemoryUsageSetting getMemoryUsageSetting() {
        if (this.memoryUsageSetting == null) {
            this.memoryUsageSetting = PAdESUtils.DEFAULT_PDF_MEMORY_USAGE_SETTING;
        }
        return this.memoryUsageSetting;
    }

    public PdfBoxScreenshotBuilder setMemoryUsageSetting(PdfMemoryUsageSetting memoryUsageSetting) {
        this.memoryUsageSetting = memoryUsageSetting;
        return this;
    }

    public static PdfBoxScreenshotBuilder fromDocument(DSSDocument pdfDocument) {
        return new PdfBoxScreenshotBuilder(pdfDocument);
    }

    public static PdfBoxScreenshotBuilder fromDocument(DSSDocument pdfDocument, char[] passwordProtection) {
        return new PdfBoxScreenshotBuilder(pdfDocument, passwordProtection);
    }

    public DSSDocument generateScreenshot(int page) {
        BufferedImage bufferedImage = this.generateBufferedImageScreenshot(page);
        return ImageUtils.toDSSDocument((BufferedImage)bufferedImage, (DSSResourcesHandler)this.initDssResourcesHandler());
    }

    @Deprecated
    public DSSDocument generateScreenshot(int page, DSSResourcesHandler dssResourcesHandler) {
        BufferedImage bufferedImage = this.generateBufferedImageScreenshot(page);
        return ImageUtils.toDSSDocument((BufferedImage)bufferedImage, (DSSResourcesHandler)dssResourcesHandler);
    }

    public BufferedImage generateBufferedImageScreenshot(int page) {
        BufferedImage bufferedImage;
        PdfBoxDocumentReader reader = new PdfBoxDocumentReader(this.pdfDocument, this.passwordProtection != null ? new String(this.passwordProtection) : null, this.getMemoryUsageSetting());
        try {
            bufferedImage = reader.generateImageScreenshot(page);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to generate a screenshot for the document with name '%s' for the page number '%s'. Reason : %s", this.pdfDocument.getName(), page, e.getMessage()), (Throwable)e);
            }
        }
        reader.close();
        return bufferedImage;
    }

    protected DSSResourcesHandler initDssResourcesHandler() {
        if (this.dssResourcesHandlerBuilder == null) {
            this.dssResourcesHandlerBuilder = PAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;
        }
        return this.dssResourcesHandlerBuilder.createResourcesHandler();
    }
}

