/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.PdfSimpleObject;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxArray;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxObjectKey;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfBoxDict
implements PdfDict {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxDict.class);
    private final COSDictionary wrapped;
    private final PDDocument document;
    private final PdfObject parent;

    public PdfBoxDict(PDDocument document) {
        this(new COSDictionary(), document);
    }

    public PdfBoxDict(COSDictionary wrapped, PDDocument document) {
        this(wrapped, document, null);
    }

    public PdfBoxDict(COSDictionary wrapped, PDDocument document, PdfObject parent) {
        Objects.requireNonNull(wrapped, "Pdf dictionary shall be provided!");
        Objects.requireNonNull(document, "Pdf document shall be provided!");
        this.wrapped = wrapped;
        this.document = document;
        this.parent = parent;
    }

    public COSDictionary getValue() {
        return this.wrapped;
    }

    public PdfObject getParent() {
        return this.parent;
    }

    public PdfDict getAsDict(String name) {
        COSDictionary cosDictionary;
        COSBase cosBaseObject = this.wrapped.getDictionaryObject(name);
        if (cosBaseObject == null) {
            return null;
        }
        if (cosBaseObject instanceof COSDictionary) {
            cosDictionary = (COSDictionary)cosBaseObject;
        } else if (cosBaseObject instanceof COSObject) {
            COSObject cosObject = (COSObject)cosBaseObject;
            cosDictionary = (COSDictionary)cosObject.getObject();
        } else {
            LOG.warn("Unable to extract entry with name '{}' as dictionary!", (Object)name);
            return null;
        }
        return new PdfBoxDict(cosDictionary, this.document, (PdfObject)this);
    }

    public PdfArray getAsArray(String name) {
        COSBase val = this.wrapped.getDictionaryObject(name);
        if (val instanceof COSArray) {
            return new PdfBoxArray((COSArray)val, this.document, (PdfObject)this);
        }
        return null;
    }

    public byte[] getBinariesValue(String name) throws IOException {
        COSBase val = this.wrapped.getDictionaryObject(name);
        if (val instanceof COSString) {
            return ((COSString)val).getBytes();
        }
        throw new IOException(name + " was expected to be a COSString element but was : " + val);
    }

    public String[] list() {
        Set cosNames = this.wrapped.keySet();
        ArrayList<String> result = new ArrayList<String>(cosNames.size());
        for (COSName cosName : cosNames) {
            String name = cosName.getName();
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getStringValue(String name) {
        return this.wrapped.getString(name);
    }

    public String getNameValue(String name) {
        return this.wrapped.getNameAsString(name);
    }

    public Date getDateValue(String name) {
        Calendar cal = this.wrapped.getDate(name);
        if (cal != null) {
            return cal.getTime();
        }
        return null;
    }

    public Number getNumberValue(String name) {
        COSBase val = this.wrapped.getDictionaryObject(name);
        if (val != null) {
            if (val instanceof COSFloat) {
                return Float.valueOf(((COSFloat)val).floatValue());
            }
            if (val instanceof COSNumber) {
                return ((COSNumber)val).longValue();
            }
        }
        return null;
    }

    public PdfObject getObject(String name) {
        COSBase dictionaryObject = this.wrapped.getDictionaryObject(name);
        if (dictionaryObject == null) {
            return null;
        }
        if (dictionaryObject instanceof COSDictionary || dictionaryObject instanceof COSObject) {
            return this.getAsDict(name);
        }
        if (dictionaryObject instanceof COSArray) {
            return this.getAsArray(name);
        }
        if (dictionaryObject instanceof COSString) {
            return new PdfSimpleObject((Object)this.getStringValue(name), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSName) {
            return new PdfSimpleObject((Object)this.getNameValue(name), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSNumber) {
            return new PdfSimpleObject((Object)this.getNumberValue(name), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSBoolean) {
            return new PdfSimpleObject((Object)((COSBoolean)dictionaryObject).getValueAsObject(), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSNull) {
            return null;
        }
        LOG.warn("Unable to process an entry with name '{}' of type '{}'.", (Object)name, dictionaryObject.getClass());
        return null;
    }

    @Deprecated
    public Long getObjectNumber(String name) {
        PdfBoxObjectKey objectKey = this.getObjectKey(name);
        if (objectKey != null) {
            return objectKey.getNumber();
        }
        return null;
    }

    public PdfBoxObjectKey getObjectKey(String name) {
        COSBase dictionaryObject = this.wrapped.getItem(name);
        if (dictionaryObject instanceof COSObject) {
            return new PdfBoxObjectKey(dictionaryObject.getKey());
        }
        return null;
    }

    public byte[] getStreamBytes() throws IOException {
        if (this.wrapped instanceof COSStream) {
            try (COSInputStream is = ((COSStream)this.wrapped).createInputStream();){
                byte[] byArray = Utils.toByteArray((InputStream)is);
                return byArray;
            }
        }
        return null;
    }

    public InputStream createRawInputStream() throws IOException {
        if (this.wrapped instanceof COSStream) {
            return ((COSStream)this.wrapped).createRawInputStream();
        }
        return null;
    }

    public long getRawStreamSize() throws IOException {
        try (InputStream is = this.createRawInputStream();){
            if (is != null) {
                long l = Utils.getInputStreamSize((InputStream)is);
                return l;
            }
        }
        return -1L;
    }

    public void setPdfObjectValue(String key, PdfObject pdfObject) {
        Object value = pdfObject.getValue();
        if (!(value instanceof COSBase)) {
            throw new UnsupportedOperationException("pdfObject argument shall be of COSBase type!");
        }
        this.wrapped.setItem(key, (COSBase)value);
    }

    public void setNameValue(String key, String value) {
        this.wrapped.setName(key, value);
    }

    public void setStringValue(String key, String value) {
        this.wrapped.setString(key, value);
    }

    public void setIntegerValue(String key, Integer value) {
        this.wrapped.setInt(key, value.intValue());
    }

    public void setDirect(boolean direct) {
        this.wrapped.setDirect(direct);
    }

    public boolean match(PdfDict pdfDict) {
        if (!(pdfDict instanceof PdfBoxDict)) {
            throw new UnsupportedOperationException("pdfDict argument shall be of PdfBoxDict type!");
        }
        PdfBoxDict pdfBoxDict = (PdfBoxDict)pdfDict;
        for (COSName key : pdfBoxDict.wrapped.keySet()) {
            COSBase targetObject = pdfBoxDict.wrapped.getDictionaryObject(key);
            COSBase currentObject = this.wrapped.getDictionaryObject(key);
            if (targetObject == null || targetObject.equals(currentObject)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

