/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.simplereport;

import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.simplereport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.simplereport.jaxb.XmlEvidenceRecords;
import eu.europa.esig.dss.simplereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplereport.jaxb.XmlPDFAInfo;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamps;
import eu.europa.esig.dss.simplereport.jaxb.XmlToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleReport {
    private final XmlSimpleReport wrapped;

    public SimpleReport(XmlSimpleReport wrapped) {
        this.wrapped = wrapped;
    }

    public Date getValidationTime() {
        return this.wrapped.getValidationTime();
    }

    public Indication getIndication(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null) {
            return token.getIndication();
        }
        return null;
    }

    public SubIndication getSubIndication(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null) {
            return token.getSubIndication();
        }
        return null;
    }

    public boolean isValid(String tokenId) {
        Indication indicationValue = this.getIndication(tokenId);
        return Indication.TOTAL_PASSED.equals((Object)indicationValue) || Indication.PASSED.equals((Object)indicationValue);
    }

    public List<String> getSignatureIdList() {
        ArrayList<String> signatureIdList = new ArrayList<String>();
        List<XmlToken> tokens = this.wrapped.getSignatureOrTimestampOrEvidenceRecord();
        if (tokens != null) {
            for (XmlToken token : tokens) {
                if (!(token instanceof XmlSignature)) continue;
                signatureIdList.add(token.getId());
            }
        }
        return signatureIdList;
    }

    public List<String> getTimestampIdList() {
        ArrayList<String> timestampIdList = new ArrayList<String>();
        List<XmlToken> tokens = this.wrapped.getSignatureOrTimestampOrEvidenceRecord();
        if (tokens != null) {
            for (XmlToken token : tokens) {
                if (!(token instanceof XmlTimestamp)) continue;
                timestampIdList.add(token.getId());
            }
        }
        return timestampIdList;
    }

    public List<String> getEvidenceRecordIdList() {
        ArrayList<String> erIdList = new ArrayList<String>();
        List<XmlToken> tokens = this.wrapped.getSignatureOrTimestampOrEvidenceRecord();
        if (tokens != null) {
            for (XmlToken token : tokens) {
                if (!(token instanceof XmlEvidenceRecord)) continue;
                erIdList.add(token.getId());
            }
        }
        return erIdList;
    }

    public String getFirstSignatureId() {
        List<String> signatureIdList = this.getSignatureIdList();
        if (!signatureIdList.isEmpty()) {
            return signatureIdList.get(0);
        }
        return null;
    }

    public String getFirstTimestampId() {
        List<String> timestampIdList = this.getTimestampIdList();
        if (!timestampIdList.isEmpty()) {
            return timestampIdList.get(0);
        }
        return null;
    }

    public String getFirstEvidenceRecordId() {
        List<String> evidenceRecordIdList = this.getEvidenceRecordIdList();
        if (!evidenceRecordIdList.isEmpty()) {
            return evidenceRecordIdList.get(0);
        }
        return null;
    }

    public String getDocumentFilename() {
        return this.wrapped.getDocumentName();
    }

    public String getTokenFilename(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null) {
            return token.getFilename();
        }
        return null;
    }

    public XmlCertificateChain getCertificateChain(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null) {
            return token.getCertificateChain();
        }
        return null;
    }

    public List<Message> getAdESValidationErrors(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null && token.getAdESValidationDetails() != null) {
            return this.convert(token.getAdESValidationDetails().getError());
        }
        return Collections.emptyList();
    }

    public List<Message> getAdESValidationWarnings(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null && token.getAdESValidationDetails() != null) {
            return this.convert(token.getAdESValidationDetails().getWarning());
        }
        return Collections.emptyList();
    }

    public List<Message> getAdESValidationInfo(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null && token.getAdESValidationDetails() != null) {
            return this.convert(token.getAdESValidationDetails().getInfo());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationErrors(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null && token.getQualificationDetails() != null) {
            return this.convert(token.getQualificationDetails().getError());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationWarnings(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null && token.getQualificationDetails() != null) {
            return this.convert(token.getQualificationDetails().getWarning());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationInfo(String tokenId) {
        XmlToken token = this.getTokenById(tokenId);
        if (token != null && token.getQualificationDetails() != null) {
            return this.convert(token.getQualificationDetails().getInfo());
        }
        return Collections.emptyList();
    }

    private Message convert(XmlMessage v) {
        if (v != null) {
            return new Message(v.getKey(), v.getValue());
        }
        return null;
    }

    private List<Message> convert(Collection<XmlMessage> messages) {
        if (messages != null) {
            return messages.stream().map(this::convert).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public SignatureQualification getSignatureQualification(String signatureId) {
        SignatureQualification qualif = SignatureQualification.NA;
        XmlSignature signature = this.getSignatureById(signatureId);
        if (signature != null && signature.getSignatureLevel() != null) {
            qualif = signature.getSignatureLevel().getValue();
        }
        return qualif;
    }

    public SignatureLevel getSignatureFormat(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSignatureFormat();
        }
        return null;
    }

    public Date getBestSignatureTime(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getBestSignatureTime();
        }
        return null;
    }

    public Date getSigningTime(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSigningTime();
        }
        return null;
    }

    public Date getSignatureExtensionPeriodMin(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getExtensionPeriodMin();
        }
        return null;
    }

    public Date getSignatureExtensionPeriodMax(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getExtensionPeriodMax();
        }
        return null;
    }

    public String getSignedBy(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null) {
            return xmlSignature.getSignedBy();
        }
        return "";
    }

    public int getSignaturesCount() {
        return this.wrapped.getSignaturesCount();
    }

    public int getValidSignaturesCount() {
        return this.wrapped.getValidSignaturesCount();
    }

    public Date getProductionTime(String timestampId) {
        XmlTimestamp xmlTimestamp = this.getTimestampById(timestampId);
        if (xmlTimestamp != null) {
            return xmlTimestamp.getProductionTime();
        }
        return null;
    }

    public String getProducedBy(String timestampId) {
        XmlTimestamp xmlTimestamp = this.getTimestampById(timestampId);
        if (xmlTimestamp != null) {
            return xmlTimestamp.getProducedBy();
        }
        return "";
    }

    public TimestampQualification getTimestampQualification(String timestampId) {
        XmlTimestamp xmlTimestamp = this.getTimestampById(timestampId);
        if (xmlTimestamp != null && xmlTimestamp.getTimestampLevel() != null) {
            return xmlTimestamp.getTimestampLevel().getValue();
        }
        return null;
    }

    private XmlToken getTokenById(String tokenId) {
        List<XmlToken> tokens = this.wrapped.getSignatureOrTimestampOrEvidenceRecord();
        return this.getEmbeddedTokenById(tokens, tokenId);
    }

    private XmlToken getEmbeddedTokenById(List<? extends XmlToken> tokens, String tokenId) {
        if (tokens != null) {
            for (XmlToken xmlToken : tokens) {
                XmlToken timestampById;
                if (tokenId.equals(xmlToken.getId())) {
                    return xmlToken;
                }
                if (xmlToken instanceof XmlSignature) {
                    timestampById = this.getSignatureTimestampById((XmlSignature)xmlToken, tokenId);
                    if (timestampById != null) {
                        return timestampById;
                    }
                    XmlToken evidenceRecordById = this.getSignatureEvidenceRecordById((XmlSignature)xmlToken, tokenId);
                    if (evidenceRecordById == null) continue;
                    return evidenceRecordById;
                }
                if (xmlToken instanceof XmlTimestamp) {
                    XmlToken evidenceRecordById = this.getTimestampEvidenceRecordById((XmlTimestamp)xmlToken, tokenId);
                    if (evidenceRecordById == null) continue;
                    return evidenceRecordById;
                }
                if (!(xmlToken instanceof XmlEvidenceRecord) || (timestampById = this.getEvidenceRecordTimestampById((XmlEvidenceRecord)xmlToken, tokenId)) == null) continue;
                return timestampById;
            }
        }
        return null;
    }

    private XmlToken getSignatureTimestampById(XmlSignature signature, String tokenId) {
        XmlTimestamps timestamps = signature.getTimestamps();
        if (timestamps != null) {
            return this.getEmbeddedTokenById(timestamps.getTimestamp(), tokenId);
        }
        return null;
    }

    private XmlToken getSignatureEvidenceRecordById(XmlSignature signature, String tokenId) {
        XmlEvidenceRecords xmlEvidenceRecords = signature.getEvidenceRecords();
        if (xmlEvidenceRecords != null && xmlEvidenceRecords.getEvidenceRecord() != null) {
            return this.getEmbeddedTokenById(xmlEvidenceRecords.getEvidenceRecord(), tokenId);
        }
        return null;
    }

    private XmlToken getTimestampEvidenceRecordById(XmlTimestamp xmlTimestamp, String tokenId) {
        XmlEvidenceRecords xmlEvidenceRecords = xmlTimestamp.getEvidenceRecords();
        if (xmlEvidenceRecords != null && xmlEvidenceRecords.getEvidenceRecord() != null) {
            return this.getEmbeddedTokenById(xmlEvidenceRecords.getEvidenceRecord(), tokenId);
        }
        return null;
    }

    private XmlToken getEvidenceRecordTimestampById(XmlEvidenceRecord evidenceRecord, String tokenId) {
        XmlTimestamps timestamps = evidenceRecord.getTimestamps();
        if (timestamps != null && timestamps.getTimestamp() != null) {
            return this.getEmbeddedTokenById(timestamps.getTimestamp(), tokenId);
        }
        return null;
    }

    private XmlSignature getSignatureById(String signatureId) {
        XmlToken token = this.getTokenById(signatureId);
        if (token instanceof XmlSignature) {
            return (XmlSignature)token;
        }
        return null;
    }

    private XmlTimestamp getTimestampById(String timestampId) {
        XmlToken token = this.getTokenById(timestampId);
        if (token instanceof XmlTimestamp) {
            return (XmlTimestamp)token;
        }
        return null;
    }

    public XmlEvidenceRecord getEvidenceRecordById(String evidenceRecordId) {
        XmlToken token = this.getTokenById(evidenceRecordId);
        if (token instanceof XmlEvidenceRecord) {
            return (XmlEvidenceRecord)token;
        }
        return null;
    }

    public List<XmlTimestamp> getSignatureTimestamps(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null && xmlSignature.getTimestamps() != null) {
            return xmlSignature.getTimestamps().getTimestamp();
        }
        return Collections.emptyList();
    }

    public List<XmlEvidenceRecord> getSignatureEvidenceRecords(String signatureId) {
        XmlSignature xmlSignature = this.getSignatureById(signatureId);
        if (xmlSignature != null && xmlSignature.getEvidenceRecords() != null) {
            return xmlSignature.getEvidenceRecords().getEvidenceRecord();
        }
        return Collections.emptyList();
    }

    public List<XmlEvidenceRecord> getTimestampEvidenceRecords(String timestampId) {
        XmlTimestamp xmlTimestamp = this.getTimestampById(timestampId);
        if (xmlTimestamp != null && xmlTimestamp.getEvidenceRecords() != null) {
            return xmlTimestamp.getEvidenceRecords().getEvidenceRecord();
        }
        return Collections.emptyList();
    }

    public List<XmlTimestamp> getEvidenceRecordTimestamps(String evidenceRecordId) {
        XmlEvidenceRecord xmlEvidenceRecord = this.getEvidenceRecordById(evidenceRecordId);
        if (xmlEvidenceRecord != null && xmlEvidenceRecord.getTimestamps() != null) {
            return xmlEvidenceRecord.getTimestamps().getTimestamp();
        }
        return Collections.emptyList();
    }

    public Date getEvidenceRecordPOE(String evidenceRecordId) {
        XmlEvidenceRecord xmlEvidenceRecord = this.getEvidenceRecordById(evidenceRecordId);
        if (xmlEvidenceRecord != null) {
            return xmlEvidenceRecord.getPOETime();
        }
        return null;
    }

    public List<XmlSignatureScope> getSignatureScopes(String tokenId) {
        XmlToken tokenById = this.getTokenById(tokenId);
        if (tokenById != null) {
            if (tokenById instanceof XmlSignature) {
                return ((XmlSignature)tokenById).getSignatureScope();
            }
            if (tokenById instanceof XmlTimestamp) {
                return ((XmlTimestamp)tokenById).getTimestampScope();
            }
            if (tokenById instanceof XmlEvidenceRecord) {
                return ((XmlEvidenceRecord)tokenById).getEvidenceRecordScope();
            }
            throw new UnsupportedOperationException(String.format("Signature scope extraction is not supported for an object of class '%s'", tokenById.getClass()));
        }
        return Collections.emptyList();
    }

    public ASiCContainerType getContainerType() {
        return this.wrapped.getContainerType();
    }

    public String getPDFAProfile() {
        XmlPDFAInfo pdfaInfo = this.wrapped.getPDFAInfo();
        if (pdfaInfo != null) {
            return pdfaInfo.getPDFAProfile();
        }
        return null;
    }

    public boolean isPDFACompliant() {
        XmlPDFAInfo pdfaInfo = this.wrapped.getPDFAInfo();
        if (pdfaInfo != null) {
            return pdfaInfo.isValid();
        }
        return false;
    }

    public XmlSimpleReport getJaxbModel() {
        return this.wrapped;
    }
}

