/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.DataFXConfiguration;
import io.datafx.core.ExceptionHandler;
import io.datafx.core.concurrent.ThreadPoolExecutorFactory$2$2$$Lambda$1;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPoolExecutorFactory {
    private static final Logger LOGGER = Logger.getLogger(ThreadPoolExecutorFactory.class.getName());
    private static ThreadPoolExecutor defaultExecutor;

    private static void onUncaughtException(Thread thread, Throwable throwable) {
        if (!ExceptionHandler.isLogException()) {
            LOGGER.log(Level.SEVERE, "Uncaught throwable in " + thread.getName(), throwable);
        }
        ExceptionHandler.getDefaultInstance().setException(throwable);
    }

    public static synchronized ThreadPoolExecutor getThreadPoolExecutor() {
        if (defaultExecutor == null) {
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(){

                @Override
                public boolean offer(Runnable runnable) {
                    if (defaultExecutor.getPoolSize() < DataFXConfiguration.getInstance().getDefaultThreadMaxSize()) {
                        return false;
                    }
                    return super.offer(runnable);
                }
            };
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable run) {
                    final ThreadGroup threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                        @Override
                        public ThreadGroup run() {
                            return new ThreadGroup(DataFXConfiguration.getInstance().getThreadGroupName());
                        }
                    });
                    return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                        @Override
                        public Thread run() {
                            Thread th = new Thread(threadGroup, run);
                            th.setUncaughtExceptionHandler(ThreadPoolExecutorFactory$2$2$$Lambda$1.lambdaFactory$());
                            th.setPriority(1);
                            th.setDaemon(true);
                            return th;
                        }

                        private static /* synthetic */ void lambda$run$3(Thread t, Throwable e) {
                            ThreadPoolExecutorFactory.onUncaughtException(t, e);
                        }

                        static /* synthetic */ void access$lambda$0(Thread thread, Throwable throwable) {
                            2.lambda$run$3(thread, throwable);
                        }
                    });
                }
            };
            defaultExecutor = new ThreadPoolExecutor(DataFXConfiguration.getInstance().getDefaultThreadPoolStartSize(), DataFXConfiguration.getInstance().getDefaultThreadMaxSize(), DataFXConfiguration.getInstance().getDefaultThreadTimeout(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
            defaultExecutor.allowCoreThreadTimeOut(true);
        }
        return defaultExecutor;
    }
}

