/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.ExceptionHandler;
import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ObservableExecutor;
import io.datafx.core.concurrent.ProcessChain$$Lambda$1;
import io.datafx.core.concurrent.ProcessChain$$Lambda$10;
import io.datafx.core.concurrent.ProcessChain$$Lambda$11;
import io.datafx.core.concurrent.ProcessChain$$Lambda$2;
import io.datafx.core.concurrent.ProcessChain$$Lambda$3;
import io.datafx.core.concurrent.ProcessChain$$Lambda$4;
import io.datafx.core.concurrent.ProcessChain$$Lambda$5;
import io.datafx.core.concurrent.ProcessChain$$Lambda$6;
import io.datafx.core.concurrent.ProcessChain$$Lambda$7;
import io.datafx.core.concurrent.ProcessChain$$Lambda$8;
import io.datafx.core.concurrent.ProcessChain$$Lambda$9;
import io.datafx.core.concurrent.ProcessChain$1$$Lambda$1;
import io.datafx.core.concurrent.ProcessChain$1$$Lambda$2;
import io.datafx.core.concurrent.ProcessChain$1$$Lambda$3;
import io.datafx.core.concurrent.ProcessDescription;
import io.datafx.core.concurrent.Publisher;
import io.datafx.core.concurrent.ThreadType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.util.Duration;

public class ProcessChain<T> {
    private List<ProcessDescription<?, ?>> processes;
    private Executor executorService;
    private ExceptionHandler exceptionHandler;
    private Runnable finalRunnable;

    public ProcessChain() {
        this(ObservableExecutor.getDefaultInstance());
    }

    public ProcessChain(Executor executorService) {
        this(executorService, null, null, null);
    }

    private ProcessChain(Executor executorService, List<ProcessDescription<?, ?>> processes, ExceptionHandler exceptionHandler, Runnable finalRunnable) {
        this.executorService = executorService;
        this.processes = new ArrayList();
        if (processes != null) {
            this.processes.addAll(processes);
        }
    }

    public static ProcessChain<Void> create() {
        return new ProcessChain<Void>();
    }

    public static ProcessChain<Void> create(Executor executorService) {
        return new ProcessChain<Void>(executorService);
    }

    public <V> ProcessChain<V> addFunction(Function<T, V> function, ThreadType type) {
        return this.addProcessDescription(new ProcessDescription<T, V>(function, type));
    }

    public <V> ProcessChain<V> addProcessDescription(ProcessDescription<T, V> processDescription) {
        this.processes.add(processDescription);
        return new ProcessChain<T>(this.executorService, this.processes, this.exceptionHandler, this.finalRunnable);
    }

    public <V> ProcessChain<V> addFunctionInPlatformThread(Function<T, V> function) {
        return this.addFunction(function, ThreadType.PLATFORM);
    }

    public <V> ProcessChain<V> addFunctionInExecutor(Function<T, V> function) {
        return this.addFunction(function, ThreadType.EXECUTOR);
    }

    public ProcessChain<Void> addRunnable(Runnable runnable, ThreadType type) {
        return this.addFunction(ProcessChain$$Lambda$1.lambdaFactory$(runnable), type);
    }

    public ProcessChain<Void> addRunnableInPlatformThread(Runnable runnable) {
        return this.addRunnable(runnable, ThreadType.PLATFORM);
    }

    public ProcessChain<Void> addRunnableInExecutor(Runnable runnable) {
        return this.addRunnable(runnable, ThreadType.EXECUTOR);
    }

    public ProcessChain<Void> addConsumer(Consumer<T> consumer, ThreadType type) {
        return this.addFunction(ProcessChain$$Lambda$2.lambdaFactory$(consumer), type);
    }

    public ProcessChain<Void> addConsumerInPlatformThread(Consumer<T> consumer) {
        return this.addConsumer(consumer, ThreadType.PLATFORM);
    }

    public ProcessChain<Void> addConsumerInExecutor(Consumer<T> consumer) {
        return this.addConsumer(consumer, ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<V> addSupplierInPlatformThread(Supplier<V> supplier) {
        return this.addSupplier(supplier, ThreadType.PLATFORM);
    }

    public <V> ProcessChain<V> addSupplierInExecutor(Supplier<V> supplier) {
        return this.addSupplier(supplier, ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<V> addSupplier(Supplier<V> supplier, ThreadType type) {
        return this.addFunction(ProcessChain$$Lambda$3.lambdaFactory$(supplier), type);
    }

    public <V> ProcessChain<List<V>> addPublishingTask(Supplier<List<V>> supplier, Consumer<Publisher<V>> consumer) {
        return this.addFunction(ProcessChain$$Lambda$4.lambdaFactory$(supplier, consumer), ThreadType.EXECUTOR);
    }

    public <V> ProcessChain<List<V>> addPublishingTask(List<V> list, Consumer<Publisher<V>> consumer) {
        return this.addPublishingTask(ProcessChain$$Lambda$5.lambdaFactory$(list), consumer);
    }

    public <V> ProcessChain<List<V>> addPublishingTask(Consumer<Publisher<V>> consumer) {
        return this.addPublishingTask(ProcessChain$$Lambda$6.lambdaFactory$(), consumer);
    }

    public ProcessChain<T> onException(Consumer<Throwable> c) {
        this.exceptionHandler = new ExceptionHandler();
        this.exceptionHandler.exceptionProperty().addListener(ProcessChain$$Lambda$7.lambdaFactory$(this, c));
        return this;
    }

    public ProcessChain<T> onException(ExceptionHandler handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public ProcessChain<T> withFinal(Runnable finalRunnable) {
        this.finalRunnable = finalRunnable;
        return this;
    }

    public <V> ProcessChain<V> waitFor(Worker<V> worker) {
        return this.addSupplierInExecutor(ProcessChain$$Lambda$8.lambdaFactory$(worker));
    }

    private <U, V> V execute(U inputParameter, ProcessDescription<U, V> processDescription) throws InterruptedException, ExecutionException {
        if (processDescription.getThreadType().equals((Object)ThreadType.EXECUTOR)) {
            return processDescription.getFunction().apply(inputParameter);
        }
        return (V)ConcurrentUtils.runCallableAndWait(ProcessChain$$Lambda$9.lambdaFactory$(processDescription, inputParameter));
    }

    public Task<T> repeatInfinite() {
        return this.repeat(Integer.MAX_VALUE);
    }

    public Task<T> repeatInfinite(Duration pauseTime) {
        return this.repeat(Integer.MAX_VALUE, pauseTime);
    }

    public Task<T> repeat(int count) {
        return this.repeat(count, Duration.ZERO);
    }

    public Task<T> repeat(final int count, final Duration pauseTime) {
        Task task = new Task<T>(){

            protected T call() throws Exception {
                Object object;
                try {
                    Object lastResult = null;
                    if (count == Integer.MAX_VALUE) {
                        while (true) {
                            lastResult = null;
                            for (ProcessDescription processDescription : ProcessChain.this.processes) {
                                lastResult = ProcessChain.this.execute(lastResult, processDescription);
                            }
                            Thread.sleep((long)pauseTime.toMillis());
                        }
                    }
                    for (int i = 0; i < count; ++i) {
                        lastResult = null;
                        for (ProcessDescription processDescription : ProcessChain.this.processes) {
                            lastResult = ProcessChain.this.execute(lastResult, processDescription);
                        }
                        Thread.sleep((long)pauseTime.toMillis());
                    }
                    object = lastResult;
                }
                catch (Exception e) {
                    try {
                        if (ProcessChain.this.exceptionHandler != null) {
                            ConcurrentUtils.runAndWait(ProcessChain$1$$Lambda$2.lambdaFactory$(this, e));
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (ProcessChain.this.finalRunnable != null) {
                            ConcurrentUtils.runAndWait(ProcessChain$1$$Lambda$3.lambdaFactory$(this));
                        }
                        throw throwable;
                    }
                }
                if (ProcessChain.this.finalRunnable != null) {
                    ConcurrentUtils.runAndWait(ProcessChain$1$$Lambda$1.lambdaFactory$(this));
                }
                return object;
            }

            private /* synthetic */ void lambda$call$24() {
                ProcessChain.this.finalRunnable.run();
            }

            private /* synthetic */ void lambda$call$23(Exception exception) {
                ProcessChain.this.exceptionHandler.setException(exception);
            }

            static /* synthetic */ void access$lambda$0(1 var0) {
                var0.lambda$call$24();
            }

            static /* synthetic */ void access$lambda$1(1 var0, Exception exception) {
                var0.lambda$call$23(exception);
            }

            static /* synthetic */ void access$lambda$2(1 var0) {
                var0.lambda$call$24();
            }
        };
        this.executorService.execute((Runnable)task);
        return task;
    }

    public Task<T> run() {
        return this.repeat(1);
    }

    private static /* synthetic */ Object lambda$execute$22(ProcessDescription processDescription, Object object) throws Exception {
        return processDescription.getFunction().apply(object);
    }

    private static /* synthetic */ Object lambda$waitFor$21(Worker worker) {
        try {
            return ConcurrentUtils.waitFor(worker);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ void lambda$onException$20(Consumer consumer, Observable e) {
        consumer.accept(this.exceptionHandler.getException());
    }

    private static /* synthetic */ List lambda$addPublishingTask$19() {
        return FXCollections.observableArrayList();
    }

    private static /* synthetic */ List lambda$addPublishingTask$17(Supplier supplier, Consumer consumer, Object e) {
        List list = (List)supplier.get();
        Publisher publisher = ProcessChain$$Lambda$10.lambdaFactory$(list);
        consumer.accept(publisher);
        return list;
    }

    private static /* synthetic */ void lambda$null$16(List list, Object[] p) {
        try {
            ConcurrentUtils.runAndWait(ProcessChain$$Lambda$11.lambdaFactory$(list, p));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static /* synthetic */ Void lambda$addConsumer$13(Consumer consumer, Object e) {
        consumer.accept(e);
        return null;
    }

    private static /* synthetic */ Void lambda$addRunnable$12(Runnable runnable, Object e) {
        runnable.run();
        return null;
    }

    static /* synthetic */ Void access$lambda$0(Runnable runnable, Object object) {
        return ProcessChain.lambda$addRunnable$12(runnable, object);
    }

    static /* synthetic */ Void access$lambda$1(Consumer consumer, Object object) {
        return ProcessChain.lambda$addConsumer$13(consumer, object);
    }

    static /* synthetic */ Object access$lambda$2(Supplier supplier, Object object) {
        return supplier.get();
    }

    static /* synthetic */ List access$lambda$3(Supplier supplier, Consumer consumer, Object object) {
        return ProcessChain.lambda$addPublishingTask$17(supplier, consumer, object);
    }

    static /* synthetic */ List access$lambda$4(List list) {
        return list;
    }

    static /* synthetic */ List access$lambda$5() {
        return ProcessChain.lambda$addPublishingTask$19();
    }

    static /* synthetic */ void access$lambda$6(ProcessChain processChain, Consumer consumer, Observable observable) {
        processChain.lambda$onException$20(consumer, observable);
    }

    static /* synthetic */ Object access$lambda$7(Worker worker) {
        return ProcessChain.lambda$waitFor$21(worker);
    }

    static /* synthetic */ Object access$lambda$8(ProcessDescription processDescription, Object object) {
        return ProcessChain.lambda$execute$22(processDescription, object);
    }

    static /* synthetic */ void access$lambda$9(List list, Object[] objectArray) {
        ProcessChain.lambda$null$16(list, objectArray);
    }

    static /* synthetic */ void access$lambda$10(List list, Object[] objectArray) {
        list.addAll(Arrays.asList(objectArray));
    }
}

