/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.ExceptionHandler;
import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.ProcessChain;
import io.datafx.core.concurrent.ThreadPoolExecutorFactory;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;

public class ObservableExecutor
implements Executor {
    private Executor executor;
    private ListProperty<Service<?>> currentServices;
    private ExceptionHandler exceptionHandler;
    private static ObservableExecutor defaultInstance;

    public ObservableExecutor() {
        this(ThreadPoolExecutorFactory.getThreadPoolExecutor());
    }

    public ObservableExecutor(Executor executor) {
        this(executor, ExceptionHandler.getDefaultInstance());
    }

    public ObservableExecutor(ExceptionHandler exceptionHandler) {
        this(ThreadPoolExecutorFactory.getThreadPoolExecutor(), exceptionHandler);
    }

    public ObservableExecutor(Executor executor, ExceptionHandler exceptionHandler) {
        this.executor = executor;
        this.exceptionHandler = exceptionHandler;
        this.currentServices = new SimpleListProperty(FXCollections.observableArrayList());
        this.currentServices.addListener(new ListChangeListener<Service<?>>(){

            public void onChanged(ListChangeListener.Change<? extends Service<?>> change) {
                while (change.next()) {
                    if (!change.wasAdded()) continue;
                    List newServices = change.getAddedSubList();
                    for (final Service service : newServices) {
                        service.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State oldSate, Worker.State newState) {
                                if (newState != null && (newState.equals((Object)Worker.State.CANCELLED) || newState.equals((Object)Worker.State.SUCCEEDED) || newState.equals((Object)Worker.State.FAILED))) {
                                    ObservableExecutor.this.currentServices.remove((Object)service);
                                }
                            }
                        });
                        Worker.State currentState = service.getState();
                        if (currentState == null || !currentState.equals((Object)Worker.State.CANCELLED) && !currentState.equals((Object)Worker.State.SUCCEEDED) && !currentState.equals((Object)Worker.State.FAILED)) continue;
                        ObservableExecutor.this.currentServices.remove((Object)service);
                    }
                }
            }
        });
    }

    public ReadOnlyListProperty<Service<?>> currentServicesProperty() {
        return this.currentServices;
    }

    public <T> Worker<T> submit(Service<T> service) {
        service.setExecutor(this.executor);
        this.currentServices.add(service);
        if (this.exceptionHandler != null) {
            this.exceptionHandler.observeWorker(service);
        }
        service.start();
        return service;
    }

    public <T> Worker<T> submit(Task<T> task) {
        return this.submit(ConcurrentUtils.createService(task));
    }

    public <T> Worker<T> submit(Callable<T> callable) {
        return this.submit(ConcurrentUtils.createService(callable));
    }

    public Worker<Void> submit(Runnable runnable) {
        return this.submit(ConcurrentUtils.createService(runnable));
    }

    @Override
    public void execute(Runnable runnable) {
        this.submit(runnable);
    }

    public ProcessChain<Void> createProcessChain() {
        return new ProcessChain<Void>(this);
    }

    public static synchronized ObservableExecutor getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ObservableExecutor();
        }
        return defaultInstance;
    }
}

