/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.concurrent.DataFxTask;
import io.datafx.core.concurrent.ObservableExecutor;
import java.util.concurrent.Executor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

public abstract class DataFxService<V>
extends Service<V> {
    private BooleanProperty cancelable = new SimpleBooleanProperty(true);

    protected void executeTask(Task<V> task) {
        Executor e;
        this.cancelable.unbind();
        if (task instanceof DataFxTask) {
            this.cancelable.bind((ObservableValue)((DataFxTask)task).cancelableProperty());
        }
        if ((e = this.getExecutor()) != null) {
            e.execute((Runnable)task);
        } else {
            ObservableExecutor.getDefaultInstance().execute((Runnable)task);
        }
    }

    public ReadOnlyBooleanProperty cancelableProperty() {
        return this.cancelable;
    }

    public boolean isCancelable() {
        return this.cancelable.get();
    }
}

