/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.impl;

import com.anf.pkcs10.PKCS10Creator;
import com.anf.pkcs10.custom.CustomPKCS10CertificationRequest;
import com.anf.pkcs10.exception.PKCS10CreationException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class PKCS10CreatorV1
implements PKCS10Creator {
    @Override
    public byte[] createPKCS10(ASN1Set attributes, String signAlg, X500Principal subjectX500Principal, PublicKey publicKey, String provider, PrivateKey privateKey) {
        return this.createPKCS10(attributes, signAlg, subjectX500Principal, publicKey, Security.getProvider(provider), privateKey);
    }

    @Override
    public byte[] createPKCS10(ASN1Set attributes, String signAlg, X500Principal subjectX500Principal, PublicKey publicKey, Provider provider, PrivateKey privateKey) {
        try {
            System.out.println();
            CustomPKCS10CertificationRequest csr = null;
            X509Principal x509Principal = new X509Principal(subjectX500Principal.getEncoded());
            csr = new CustomPKCS10CertificationRequest(signAlg, (X509Name)x509Principal, publicKey, attributes, privateKey, provider);
            CustomPKCS10CertificationRequest rrr = new CustomPKCS10CertificationRequest(csr.getEncoded());
            rrr.verify();
            System.out.println();
            return csr.getEncoded();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new PKCS10CreationException(e);
        }
    }

    public static PublicKey extractPublicKey(PKCS10CertificationRequest pkcs10) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException {
        SubjectPublicKeyInfo publicKeyInfo = pkcs10.getSubjectPublicKeyInfo();
        KeyFactory factory = KeyFactory.getInstance("RSA", "BC");
        PublicKey publicKey = factory.generatePublic(new X509EncodedKeySpec(publicKeyInfo.getEncoded()));
        return publicKey;
    }
}

