/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs10.impl;

import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.custom.CustomPKCS10CertificationRequest;
import com.anf.pkcs10.exception.PKCS10PublicKeyException;
import com.anf.pkcs10.exception.PKCS10SignatureException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class PKCS10CertificateRequestOldImpl
implements PKCS10Request {
    private CustomPKCS10CertificationRequest request;

    public PKCS10CertificateRequestOldImpl(byte[] encoded) {
        this.request = new CustomPKCS10CertificationRequest(encoded);
    }

    @Override
    public X500Name getSubject() {
        return this.request.getCertificationRequestInfo().getSubject();
    }

    @Override
    public byte[] getEncoded() {
        return this.request.getEncoded();
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.request.getPublicKey();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new PKCS10PublicKeyException(e);
        }
    }

    @Override
    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.request.getCertificationRequestInfo().getSubjectPublicKeyInfo();
    }

    @Override
    public Attribute[] getAttributes() {
        ArrayList<Attribute> atrs = new ArrayList<Attribute>();
        ASN1Set set = this.request.getCertificationRequestInfo().getAttributes();
        Enumeration objects = set.getObjects();
        while (objects.hasMoreElements()) {
            Object object = objects.nextElement();
            try {
                Attribute atr = Attribute.getInstance(object);
                atrs.add(atr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Attribute[] arr = new Attribute[atrs.size()];
        atrs.toArray(arr);
        return arr;
    }

    @Override
    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.request.getSignatureAlgorithm();
    }

    @Override
    public ASN1Set getAttributesSet() {
        return this.request.getCertificationRequestInfo().getAttributes();
    }

    @Override
    public boolean verifySignature() {
        try {
            return this.request.verify();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new PKCS10SignatureException(e);
        }
    }

    @Override
    public Extensions getExtensions() {
        ASN1Set attributesSet = this.getAttributesSet();
        Enumeration objects = attributesSet.getObjects();
        if (attributesSet != null && objects.hasMoreElements()) {
            ArrayList<Extension> vector = new ArrayList<Extension>();
            while (objects.hasMoreElements()) {
                Object oidObj;
                ASN1Sequence seq;
                Enumeration extObjs;
                ASN1Encodable obj = (ASN1Encodable)objects.nextElement();
                if (!(obj instanceof ASN1Sequence) || !(extObjs = (seq = (ASN1Sequence)obj).getObjects()).hasMoreElements() || !((oidObj = extObjs.nextElement()) instanceof ASN1ObjectIdentifier) || !extObjs.hasMoreElements()) continue;
                try {
                    DEROctetString derOctetString = new DEROctetString((ASN1Encodable)extObjs.nextElement());
                    vector.add(new Extension((ASN1ObjectIdentifier)oidObj, ASN1Boolean.FALSE, (ASN1OctetString)derOctetString));
                }
                catch (IOException iOException) {}
            }
            Extension[] exts = new Extension[vector.size()];
            return new Extensions(vector.toArray(exts));
        }
        return null;
    }
}

