/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class JFXComboBoxListViewSkin<T>
extends ComboBoxListViewSkin<T> {
    private boolean invalid = true;
    private Text promptText;
    private ValidationPane<JFXComboBox> errorContainer;
    private PromptLinesWrapper<JFXComboBox> linesWrapper;
    protected final ObjectProperty<Paint> promptTextFill = new StyleableObjectProperty<Paint>((Paint)Color.GRAY){

        public Object getBean() {
            return JFXComboBoxListViewSkin.this;
        }

        public String getName() {
            return "promptTextFill";
        }

        public CssMetaData<JFXComboBox, Paint> getCssMetaData() {
            return StyleableProperties.PROMPT_TEXT_FILL;
        }
    };

    public JFXComboBoxListViewSkin(JFXComboBox<T> comboBox) {
        super(comboBox);
        this.linesWrapper = new PromptLinesWrapper<JFXComboBox<JFXComboBox>>((JFXComboBox<JFXComboBox>)comboBox, this.promptTextFill, (ObservableValue<?>)comboBox.valueProperty(), (ObservableValue<String>)comboBox.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), new Node[0]);
        Pane arrowButton = null;
        for (Node node : this.getChildren()) {
            if (!node.getId().equals("arrow-button")) continue;
            arrowButton = (Pane)node;
            break;
        }
        if (arrowButton != null) {
            this.linesWrapper.clip.widthProperty().bind((ObservableValue)this.linesWrapper.promptContainer.widthProperty().subtract((ObservableNumberValue)arrowButton.widthProperty()));
        }
        this.errorContainer = new ValidationPane<JFXComboBox<JFXComboBox>>(comboBox);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        if (comboBox.isEditable()) {
            comboBox.getEditor().setStyle("-fx-background-color:TRANSPARENT;-fx-padding: 0.333333em 0em;");
            comboBox.getEditor().promptTextProperty().unbind();
            comboBox.getEditor().setPromptText(null);
            comboBox.getEditor().textProperty().addListener((o, oldVal, newVal) -> this.linesWrapper.usePromptText.invalidate());
        }
        this.registerChangeListener((ObservableValue)comboBox.disableProperty(), obs -> this.linesWrapper.updateDisabled());
        this.registerChangeListener((ObservableValue)comboBox.focusColorProperty(), obs -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener((ObservableValue)comboBox.unFocusColorProperty(), obs -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener((ObservableValue)comboBox.disableAnimationProperty(), obs -> this.errorContainer.updateClip());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((ComboBoxBase)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(x, y, w, h, height, this.promptText == null ? 0.0 : this.snapPositionX(this.promptText.getBaselineOffset() + this.promptText.getLayoutBounds().getHeight() * 0.36));
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), w, h);
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.textProperty().bind((ObservableValue)((ComboBoxBase)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.getStyleClass().addAll((Object[])new String[]{"text"});
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.setTranslateX(1.0);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((ComboBoxBase)this.getSkinnable()).isFocused() && ((JFXComboBox)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-this.snapPositionY(this.promptText.getBaselineOffset() + this.promptText.getLayoutBounds().getHeight() * 0.36));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXComboBoxListViewSkin.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXComboBox, Paint> PROMPT_TEXT_FILL = new CssMetaData<JFXComboBox, Paint>("-fx-prompt-text-fill", PaintConverter.getInstance(), (Paint)Color.GRAY){

            public boolean isSettable(JFXComboBox n) {
                JFXComboBoxListViewSkin skin = (JFXComboBoxListViewSkin)n.getSkin();
                return skin.promptTextFill == null || !skin.promptTextFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXComboBox n) {
                JFXComboBoxListViewSkin skin = (JFXComboBoxListViewSkin)n.getSkin();
                return (StyleableProperty)skin.promptTextFill;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<JFXComboBox, Paint>> styleables = new ArrayList<CssMetaData<JFXComboBox, Paint>>(ComboBoxListViewSkin.getClassCssMetaData());
            styleables.add(PROMPT_TEXT_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

