/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

class JFXColorPickerUI
extends Pane {
    private CachedTransition selectorTransition;
    private int pickerSize = 400;
    private int selectorSize = 20;
    private double centerX;
    private double centerY;
    private double huesRadius;
    private double slRadius;
    private double currentHue = 0.0;
    private ImageView huesCircleView;
    private ImageView slCircleView;
    private Pane colorSelector;
    private Pane selector;
    private CurveTransition colorsTransition;
    private ObservableList<Node> colorNodes = FXCollections.observableArrayList();
    private boolean allowColorChange = true;
    private ParallelTransition pTrans;

    public JFXColorPickerUI(int pickerSize) {
        JFXDepthManager.setDepth((Node)this, 1);
        this.pickerSize = pickerSize;
        this.centerX = (double)pickerSize / 2.0;
        this.centerY = (double)pickerSize / 2.0;
        double pickerRadius = (double)pickerSize / 2.0;
        this.huesRadius = pickerRadius * 0.9;
        double huesSmallR = pickerRadius * 0.8;
        double huesLargeR = pickerRadius;
        this.slRadius = pickerRadius * 0.7;
        this.huesCircleView = new ImageView(this.getHuesCircle(pickerSize, pickerSize));
        Circle outterCircle = new Circle(this.centerX, this.centerY, huesLargeR - 2.0);
        Circle innterCircle = new Circle(this.centerX, this.centerY, huesSmallR + 2.0);
        this.huesCircleView.setClip((Node)Path.subtract((Shape)outterCircle, (Shape)innterCircle));
        this.getChildren().add((Object)this.huesCircleView);
        Circle r1 = new Circle(pickerRadius - huesSmallR);
        Circle r2 = new Circle(pickerRadius - this.huesRadius);
        this.colorSelector = new Pane();
        this.colorSelector.setStyle("-fx-border-color:#424242; -fx-border-width:1px; -fx-background-color:rgba(255, 255, 255, 0.87);");
        this.colorSelector.setPrefSize(pickerRadius - huesSmallR, pickerRadius - huesSmallR);
        this.colorSelector.setShape(Path.subtract((Shape)r1, (Shape)r2));
        this.colorSelector.setCache(true);
        this.colorSelector.setMouseTransparent(true);
        this.colorSelector.setPickOnBounds(false);
        this.getChildren().add((Object)this.colorSelector);
        this.huesCircleView.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            if (this.colorsTransition != null) {
                this.colorsTransition.stop();
            }
            double dx = event.getX() - this.centerX;
            double dy = event.getY() - this.centerY;
            double theta = Math.atan2(dy, dx);
            double x = this.centerX + this.huesRadius * Math.cos(theta);
            double y = this.centerY + this.huesRadius * Math.sin(theta);
            this.colorSelector.setRotate(90.0 + Math.toDegrees(Math.atan2(dy, dx)));
            this.colorSelector.setTranslateX(x - this.colorSelector.getPrefWidth() / 2.0);
            this.colorSelector.setTranslateY(y - this.colorSelector.getPrefHeight() / 2.0);
        });
        this.huesCircleView.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            double dx = event.getX() - this.centerX;
            double dy = event.getY() - this.centerY;
            double theta = Math.atan2(dy, dx);
            double x = this.centerX + this.huesRadius * Math.cos(theta);
            double y = this.centerY + this.huesRadius * Math.sin(theta);
            this.colorsTransition = new CurveTransition(new Point2D(this.colorSelector.getTranslateX() + this.colorSelector.getPrefWidth() / 2.0, this.colorSelector.getTranslateY() + this.colorSelector.getPrefHeight() / 2.0), new Point2D(x, y));
            this.colorsTransition.play();
        });
        this.colorSelector.translateXProperty().addListener((o, oldVal, newVal) -> this.updateHSLCircleColor((int)((double)newVal.intValue() + this.colorSelector.getPrefWidth() / 2.0), (int)(this.colorSelector.getTranslateY() + this.colorSelector.getPrefHeight() / 2.0)));
        this.colorSelector.translateYProperty().addListener((o, oldVal, newVal) -> this.updateHSLCircleColor((int)(this.colorSelector.getTranslateX() + this.colorSelector.getPrefWidth() / 2.0), (int)((double)newVal.intValue() + this.colorSelector.getPrefHeight() / 2.0)));
        this.slCircleView = new ImageView(this.getSLCricle(pickerSize, pickerSize));
        this.slCircleView.setClip((Node)new Circle(this.centerX, this.centerY, this.slRadius - 2.0));
        this.slCircleView.setPickOnBounds(false);
        this.getChildren().add((Object)this.slCircleView);
        this.selector = new Pane();
        Circle c1 = new Circle((double)(this.selectorSize / 2));
        Circle c2 = new Circle((double)(this.selectorSize / 2) * 0.5);
        this.selector.setShape(Path.subtract((Shape)c1, (Shape)c2));
        this.selector.setStyle("-fx-border-color:#424242; -fx-border-width:1px;-fx-background-color:rgba(255, 255, 255, 0.87);");
        this.selector.setPrefSize((double)this.selectorSize, (double)this.selectorSize);
        this.selector.setMinSize((double)this.selectorSize, (double)this.selectorSize);
        this.selector.setMaxSize((double)this.selectorSize, (double)this.selectorSize);
        this.selector.setCache(true);
        this.selector.setMouseTransparent(true);
        this.getChildren().add((Object)this.selector);
        this.slCircleView.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            if (this.selectorTransition != null) {
                this.selectorTransition.stop();
            }
            if (Math.pow(event.getX() - this.centerX, 2.0) + Math.pow(event.getY() - this.centerY, 2.0) < Math.pow(this.slRadius - 2.0, 2.0)) {
                this.selector.setTranslateX(event.getX() - this.selector.getPrefWidth() / 2.0);
                this.selector.setTranslateY(event.getY() - this.selector.getPrefHeight() / 2.0);
            } else {
                double dx = event.getX() - this.centerX;
                double dy = event.getY() - this.centerY;
                double theta = Math.atan2(dy, dx);
                double x = this.centerX + (this.slRadius - 2.0) * Math.cos(theta);
                double y = this.centerY + (this.slRadius - 2.0) * Math.sin(theta);
                this.selector.setTranslateX(x - this.selector.getPrefWidth() / 2.0);
                this.selector.setTranslateY(y - this.selector.getPrefHeight() / 2.0);
            }
        });
        this.slCircleView.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.selectorTransition = new CachedTransition((Node)this.selector, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.selector.translateXProperty(), (Object)(event.getX() - this.selector.getPrefWidth() / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selector.translateYProperty(), (Object)(event.getY() - this.selector.getPrefHeight() / 2.0), Interpolator.EASE_BOTH)})})){
                {
                    this.setCycleDuration(Duration.millis((double)160.0));
                    this.setDelay(Duration.seconds((double)0.0));
                }
            };
            this.selectorTransition.play();
        });
        this.selector.translateXProperty().addListener((o, oldVal, newVal) -> this.setColorAtLocation(newVal.intValue() + this.selectorSize / 2, (int)this.selector.getTranslateY() + this.selectorSize / 2));
        this.selector.translateYProperty().addListener((o, oldVal, newVal) -> this.setColorAtLocation((int)this.selector.getTranslateX() + this.selectorSize / 2, newVal.intValue() + this.selectorSize / 2));
        double dx = 20.0 - this.centerX;
        double dy = 20.0 - this.centerY;
        double theta = Math.atan2(dy, dx);
        double x = this.centerX + this.huesRadius * Math.cos(theta);
        double y = this.centerY + this.huesRadius * Math.sin(theta);
        this.colorSelector.setRotate(90.0 + Math.toDegrees(Math.atan2(dy, dx)));
        this.colorSelector.setTranslateX(x - this.colorSelector.getPrefWidth() / 2.0);
        this.colorSelector.setTranslateY(y - this.colorSelector.getPrefHeight() / 2.0);
        this.selector.setTranslateX(this.centerX - this.selector.getPrefWidth() / 2.0);
        this.selector.setTranslateY(this.centerY - this.selector.getPrefHeight() / 2.0);
    }

    public void addColorSelectionNode(Node ... nodes) {
        this.colorNodes.addAll((Object[])nodes);
    }

    public void removeColorSelectionNode(Node ... nodes) {
        this.colorNodes.removeAll((Object[])nodes);
    }

    private void updateHSLCircleColor(int x, int y) {
        Color color = this.huesCircleView.getImage().getPixelReader().getColor(x, y);
        double max = Math.max(color.getRed(), Math.max(color.getGreen(), color.getBlue()));
        double min = Math.min(color.getRed(), Math.min(color.getGreen(), color.getBlue()));
        double hue = 0.0;
        if (max != min) {
            double d = max - min;
            if (max == color.getRed()) {
                hue = (color.getGreen() - color.getBlue()) / d + (double)(color.getGreen() < color.getBlue() ? 6 : 0);
            } else if (max == color.getGreen()) {
                hue = (color.getBlue() - color.getRed()) / d + 2.0;
            } else if (max == color.getBlue()) {
                hue = (color.getRed() - color.getGreen()) / d + 4.0;
            }
            hue /= 6.0;
        }
        this.currentHue = this.map(hue, 0.0, 1.0, 0.0, 255.0);
        this.refreshHSLCircle();
    }

    private void refreshHSLCircle() {
        ColorAdjust colorAdjust = new ColorAdjust();
        colorAdjust.setHue(this.map(this.currentHue + (double)(this.currentHue < 127.5 ? 1 : -1) * 127.5, 0.0, 255.0, -1.0, 1.0));
        this.slCircleView.setEffect((Effect)colorAdjust);
        this.setColorAtLocation((int)this.selector.getTranslateX() + this.selectorSize / 2, (int)this.selector.getTranslateY() + this.selectorSize / 2);
    }

    public void moveToColor(Color color) {
        double endPointY;
        double endPointX;
        this.allowColorChange = false;
        double max = Math.max(color.getRed(), Math.max(color.getGreen(), color.getBlue()));
        double min = Math.min(color.getRed(), Math.min(color.getGreen(), color.getBlue()));
        double hue = 0.0;
        double l = (max + min) / 2.0;
        double s = 0.0;
        if (max == min) {
            s = 0.0;
            hue = 0.0;
        } else {
            double d = max - min;
            double d2 = s = l > 0.5 ? d / (2.0 - max - min) : d / (max + min);
            if (max == color.getRed()) {
                hue = (color.getGreen() - color.getBlue()) / d + (double)(color.getGreen() < color.getBlue() ? 6 : 0);
            } else if (max == color.getGreen()) {
                hue = (color.getBlue() - color.getRed()) / d + 2.0;
            } else if (max == color.getBlue()) {
                hue = (color.getRed() - color.getGreen()) / d + 4.0;
            }
            hue /= 6.0;
        }
        this.currentHue = this.map(hue, 0.0, 1.0, 0.0, 255.0);
        double theta = this.map(this.currentHue, 0.0, 255.0, -Math.PI, Math.PI);
        double x = this.centerX + this.huesRadius * Math.cos(theta);
        double y = this.centerY + this.huesRadius * Math.sin(theta);
        this.colorsTransition = new CurveTransition(new Point2D(this.colorSelector.getTranslateX() + this.colorSelector.getPrefWidth() / 2.0, this.colorSelector.getTranslateY() + this.colorSelector.getPrefHeight() / 2.0), new Point2D(x, y));
        s = this.map(s, 0.0, 1.0, 0.0, 255.0);
        l = this.map(l, 0.0, 1.0, 0.0, 255.0);
        Point2D point = this.getPointFromSL((int)s, (int)l, this.slRadius);
        double pX = this.centerX - point.getX();
        double pY = this.centerY - point.getY();
        if (Math.pow(pX - this.centerX, 2.0) + Math.pow(pY - this.centerY, 2.0) < Math.pow(this.slRadius - 2.0, 2.0)) {
            endPointX = pX - this.selector.getPrefWidth() / 2.0;
            endPointY = pY - this.selector.getPrefHeight() / 2.0;
        } else {
            double dx = pX - this.centerX;
            double dy = pY - this.centerY;
            theta = Math.atan2(dy, dx);
            x = this.centerX + (this.slRadius - 2.0) * Math.cos(theta);
            y = this.centerY + (this.slRadius - 2.0) * Math.sin(theta);
            endPointX = x - this.selector.getPrefWidth() / 2.0;
            endPointY = y - this.selector.getPrefHeight() / 2.0;
        }
        this.selectorTransition = new CachedTransition((Node)this.selector, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.selector.translateXProperty(), (Object)endPointX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selector.translateYProperty(), (Object)endPointY, Interpolator.EASE_BOTH)})})){
            {
                this.setCycleDuration(Duration.millis((double)160.0));
                this.setDelay(Duration.seconds((double)0.0));
            }
        };
        if (this.pTrans != null) {
            this.pTrans.stop();
        }
        this.pTrans = new ParallelTransition(new Animation[]{this.colorsTransition, this.selectorTransition});
        this.pTrans.setOnFinished(finish -> {
            if (this.pTrans.getStatus() == Animation.Status.STOPPED) {
                this.allowColorChange = true;
            }
        });
        this.pTrans.play();
        this.refreshHSLCircle();
    }

    private void setColorAtLocation(int x, int y) {
        if (this.allowColorChange) {
            Color color = this.getColorAtLocation(x, y);
            String colorString = "rgb(" + color.getRed() * 255.0 + "," + color.getGreen() * 255.0 + "," + color.getBlue() * 255.0 + ");";
            for (Node node : this.colorNodes) {
                node.setStyle("-fx-background-color:" + colorString + "; -fx-fill:" + colorString + ";");
            }
        }
    }

    private Color getColorAtLocation(double x, double y) {
        double dy = x - this.centerX;
        double dx = y - this.centerY;
        return this.getColor(dx, dy);
    }

    private Image getHuesCircle(int width, int height) {
        WritableImage raster = new WritableImage(width, height);
        PixelWriter pixelWriter = raster.getPixelWriter();
        Point2D center = new Point2D((double)width / 2.0, (double)height / 2.0);
        double rsmall = 0.8 * (double)width / 2.0;
        double rbig = (double)width / 2.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double dx = (double)x - center.getX();
                double dy = (double)y - center.getY();
                double distance = Math.sqrt(dx * dx + dy * dy);
                double o = Math.atan2(dy, dx);
                if (!(distance > rsmall) || !(distance < rbig)) continue;
                double H = this.map(o, -Math.PI, Math.PI, 0.0, 255.0);
                double S = 255.0;
                double L = 152.0;
                pixelWriter.setColor(x, y, this.HSL2RGB(H, S, L));
            }
        }
        return raster;
    }

    private Image getSLCricle(int width, int height) {
        WritableImage raster = new WritableImage(width, height);
        PixelWriter pixelWriter = raster.getPixelWriter();
        Point2D center = new Point2D((double)width / 2.0, (double)height / 2.0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double dy = (double)x - center.getX();
                double dx = (double)y - center.getY();
                pixelWriter.setColor(x, y, this.getColor(dx, dy));
            }
        }
        return raster;
    }

    private double clamp(double from, double small, double big) {
        return Math.min(Math.max(from, small), big);
    }

    private Color getColor(double dx, double dy) {
        double distance = Math.sqrt(dx * dx + dy * dy);
        double rverysmall = 0.65 * ((double)this.pickerSize / 2.0);
        Color pixelColor = Color.BLUE;
        if (distance <= rverysmall * 1.1) {
            double angle = -1.5707963267948966;
            double angle1 = angle + 2.0943951023931953;
            double angle2 = angle1 + 2.0943951023931953;
            double x1 = rverysmall * Math.sin(angle1);
            double y1 = rverysmall * Math.cos(angle1);
            double x2 = rverysmall * Math.sin(angle2);
            double y2 = rverysmall * Math.cos(angle2);
            double[] circle = this.circleFrom3Points(new Point2D(x1, y1), new Point2D(x2, y2), new Point2D(dx += 0.01, dy));
            double xArc = circle[0];
            double yArc = 0.0;
            double arcR = circle[2];
            double Arco = Math.atan2(dx - xArc, dy - yArc);
            double Arco1 = Math.atan2(x1 - xArc, y1 - yArc);
            double Arco2 = Math.atan2(x2 - xArc, y2 - yArc);
            double finalX = xArc > 0.0 ? xArc - arcR : xArc + arcR;
            double saturation = this.map(finalX, -rverysmall, rverysmall, 255.0, 0.0);
            double lightness = 255.0;
            double diffAngle = Arco2 - Arco1;
            double diffArco = Arco - Arco1;
            if (dx < x1) {
                diffAngle = diffAngle < 0.0 ? Math.PI * 2 + diffAngle : diffAngle;
                diffAngle = Math.abs(Math.PI * 2 - diffAngle);
                diffArco = diffArco < 0.0 ? Math.PI * 2 + diffArco : diffArco;
                diffArco = Math.abs(Math.PI * 2 - diffArco);
            }
            lightness = this.map(diffArco, 0.0, diffAngle, 0.0, 255.0);
            if (distance > rverysmall) {
                saturation = 255.0 - saturation;
                if (lightness < 0.0 && dy < 0.0) {
                    lightness = 255.0;
                }
            }
            lightness = this.clamp(lightness, 0.0, 255.0);
            if (saturation < 10.0 && dx < x1 || saturation > 240.0 && dx > x1) {
                saturation = 255.0 - saturation;
            }
            saturation = this.clamp(saturation, 0.0, 255.0);
            pixelColor = this.HSL2RGB(this.currentHue, saturation, lightness);
        }
        return pixelColor;
    }

    private double map(double val, double min1, double max1, double min2, double max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    private Color HSL2RGB(double hue, double sat, double lum) {
        hue = this.map(hue, 0.0, 255.0, 0.0, 359.0);
        sat = this.map(sat, 0.0, 255.0, 0.0, 1.0);
        double red = lum = this.map(lum, 0.0, 255.0, 0.0, 1.0);
        double green = lum;
        double blue = lum;
        double v = lum <= 0.5 ? lum * (1.0 + sat) : lum + sat - lum * sat;
        double m = lum + lum - v;
        double sv = (v - m) / v;
        int sextant = (int)Math.floor(hue /= 60.0);
        double fract = hue - (double)sextant;
        double vsf = v * sv * fract;
        double mid1 = m + vsf;
        double mid2 = v - vsf;
        if (v > 0.0) {
            switch (sextant) {
                case 0: {
                    red = v;
                    green = mid1;
                    blue = m;
                    break;
                }
                case 1: {
                    red = mid2;
                    green = v;
                    blue = m;
                    break;
                }
                case 2: {
                    red = m;
                    green = v;
                    blue = mid1;
                    break;
                }
                case 3: {
                    red = m;
                    green = mid2;
                    blue = v;
                    break;
                }
                case 4: {
                    red = mid1;
                    green = m;
                    blue = v;
                    break;
                }
                case 5: {
                    red = v;
                    green = m;
                    blue = mid2;
                }
            }
        }
        return new Color(red, green, blue, 1.0);
    }

    private double[] circleFrom3Points(Point2D a, Point2D b, Point2D c) {
        double ax = a.getX();
        double ay = a.getY();
        double bx = b.getX();
        double by = b.getY();
        double cx = c.getX();
        double cy = c.getY();
        double x1 = (bx + ax) / 2.0;
        double y11 = (by + ay) / 2.0;
        double dy1 = bx - ax;
        double dx1 = -(by - ay);
        double x2 = (cx + bx) / 2.0;
        double y2 = (cy + by) / 2.0;
        double dy2 = cx - bx;
        double dx2 = -(cy - by);
        double ox = (y11 * dx1 * dx2 + x2 * dx1 * dy2 - x1 * dy1 * dx2 - y2 * dx1 * dx2) / (dx1 * dy2 - dy1 * dx2);
        double oy = (ox - x1) * dy1 / dx1 + y11;
        double dx = ox - ax;
        double dy = oy - ay;
        double radius = Math.sqrt(dx * dx + dy * dy);
        return new double[]{ox, oy, radius};
    }

    private Point2D getPointFromSL(int saturation, int lightness, double radius) {
        double dy = this.map(saturation, 0.0, 255.0, -radius, radius);
        double angle = 0.0;
        double angle1 = angle + 2.0943951023931953;
        double angle2 = angle1 + 2.0943951023931953;
        double x1 = radius * Math.sin(angle1);
        double y1 = radius * Math.cos(angle1);
        double x2 = radius * Math.sin(angle2);
        double y2 = radius * Math.cos(angle2);
        double dx = 0.0;
        double[] circle = this.circleFrom3Points(new Point2D(x1, y1), new Point2D(dx, dy), new Point2D(x2, y2));
        double xArc = circle[0];
        double yArc = circle[1];
        double arcR = circle[2];
        double Arco1 = Math.atan2(x1 - xArc, y1 - yArc);
        double Arco2 = Math.atan2(x2 - xArc, y2 - yArc);
        double ArcoFinal = this.map(lightness, 0.0, 255.0, Arco2, Arco1);
        double finalX = xArc + arcR * Math.sin(ArcoFinal);
        double finalY = yArc + arcR * Math.cos(ArcoFinal);
        if (dy < y1) {
            ArcoFinal = this.map(lightness, 0.0, 255.0, Arco1, Arco2 + Math.PI * 2);
            finalX = -xArc - arcR * Math.sin(ArcoFinal);
            finalY = yArc + arcR * Math.cos(ArcoFinal);
        }
        return new Point2D(finalX, finalY);
    }

    private Point2D rotate(Point2D a, Point2D center, double angle) {
        double resultX = center.getX() + (a.getX() - center.getX()) * Math.cos(angle) - (a.getY() - center.getY()) * Math.sin(angle);
        double resultY = center.getY() + (a.getX() - center.getX()) * Math.sin(angle) + (a.getY() - center.getY()) * Math.cos(angle);
        return new Point2D(resultX, resultY);
    }

    private final class CurveTransition
    extends Transition {
        Point2D from;
        double fromTheta;
        double toTheta;

        public CurveTransition(Point2D from, Point2D to) {
            this.from = from;
            double fromDx = from.getX() - JFXColorPickerUI.this.centerX;
            double fromDy = from.getY() - JFXColorPickerUI.this.centerY;
            this.fromTheta = Math.atan2(fromDy, fromDx);
            double toDx = to.getX() - JFXColorPickerUI.this.centerX;
            double toDy = to.getY() - JFXColorPickerUI.this.centerY;
            this.toTheta = Math.atan2(toDy, toDx);
            this.setInterpolator(Interpolator.EASE_BOTH);
            this.setDelay(Duration.millis((double)0.0));
            this.setCycleDuration(Duration.millis((double)240.0));
        }

        protected void interpolate(double frac) {
            double dif = Math.min(Math.abs(this.toTheta - this.fromTheta), Math.PI * 2 - Math.abs(this.toTheta - this.fromTheta));
            if (dif == Math.PI * 2 - Math.abs(this.toTheta - this.fromTheta)) {
                int dir = -1;
                if (this.toTheta < this.fromTheta) {
                    dir = 1;
                }
                dif = (double)dir * dif;
            } else {
                dif = this.toTheta - this.fromTheta;
            }
            Point2D newP = JFXColorPickerUI.this.rotate(this.from, new Point2D(JFXColorPickerUI.this.centerX, JFXColorPickerUI.this.centerY), frac * dif);
            JFXColorPickerUI.this.colorSelector.setRotate(90.0 + Math.toDegrees(Math.atan2(newP.getY() - JFXColorPickerUI.this.centerY, newP.getX() - JFXColorPickerUI.this.centerX)));
            JFXColorPickerUI.this.colorSelector.setTranslateX(newP.getX() - JFXColorPickerUI.this.colorSelector.getPrefWidth() / 2.0);
            JFXColorPickerUI.this.colorSelector.setTranslateY(newP.getY() - JFXColorPickerUI.this.colorSelector.getPrefHeight() / 2.0);
        }
    }
}

