/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.skins.JFXCustomColorPickerDialog;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

class JFXColorPalette
extends Region {
    private static final int SQUARE_SIZE = 15;
    JFXColorGrid colorPickerGrid;
    final JFXButton customColorLink = new JFXButton("Custom Color");
    JFXCustomColorPickerDialog customColorDialog = null;
    private JFXColorPicker colorPicker;
    private final GridPane customColorGrid = new GridPane();
    private final Label customColorLabel = new Label("Recent Colors");
    private PopupControl popupControl;
    private ColorSquare focusedSquare;
    private Color mouseDragColor = null;
    private boolean dragDetected = false;
    private final ColorSquare hoverSquare = new ColorSquare();
    private static final int NUM_OF_COLUMNS = 10;
    private static double[] RAW_VALUES = new double[]{250.0, 250.0, 250.0, 245.0, 245.0, 245.0, 238.0, 238.0, 238.0, 224.0, 224.0, 224.0, 189.0, 189.0, 189.0, 158.0, 158.0, 158.0, 117.0, 117.0, 117.0, 97.0, 97.0, 97.0, 66.0, 66.0, 66.0, 33.0, 33.0, 33.0, 236.0, 239.0, 241.0, 207.0, 216.0, 220.0, 176.0, 190.0, 197.0, 144.0, 164.0, 174.0, 120.0, 144.0, 156.0, 96.0, 125.0, 139.0, 84.0, 110.0, 122.0, 69.0, 90.0, 100.0, 55.0, 71.0, 79.0, 38.0, 50.0, 56.0, 255.0, 235.0, 238.0, 255.0, 205.0, 210.0, 239.0, 154.0, 154.0, 229.0, 115.0, 115.0, 239.0, 83.0, 80.0, 244.0, 67.0, 54.0, 229.0, 57.0, 53.0, 211.0, 47.0, 47.0, 198.0, 40.0, 40.0, 183.0, 28.0, 28.0, 252.0, 228.0, 236.0, 248.0, 187.0, 208.0, 244.0, 143.0, 177.0, 240.0, 98.0, 146.0, 236.0, 64.0, 122.0, 233.0, 30.0, 99.0, 216.0, 27.0, 96.0, 194.0, 24.0, 91.0, 173.0, 20.0, 87.0, 136.0, 14.0, 79.0, 243.0, 229.0, 245.0, 225.0, 190.0, 231.0, 206.0, 147.0, 216.0, 186.0, 104.0, 200.0, 171.0, 71.0, 188.0, 156.0, 39.0, 176.0, 142.0, 36.0, 170.0, 123.0, 31.0, 162.0, 106.0, 27.0, 154.0, 74.0, 20.0, 140.0, 237.0, 231.0, 246.0, 209.0, 196.0, 233.0, 179.0, 157.0, 219.0, 149.0, 117.0, 205.0, 126.0, 87.0, 194.0, 103.0, 58.0, 183.0, 94.0, 53.0, 177.0, 81.0, 45.0, 168.0, 69.0, 39.0, 160.0, 49.0, 27.0, 146.0, 232.0, 234.0, 246.0, 197.0, 202.0, 233.0, 159.0, 168.0, 218.0, 121.0, 134.0, 203.0, 92.0, 107.0, 192.0, 63.0, 81.0, 181.0, 57.0, 73.0, 171.0, 48.0, 63.0, 159.0, 40.0, 53.0, 147.0, 26.0, 35.0, 126.0, 227.0, 242.0, 253.0, 187.0, 222.0, 251.0, 144.0, 202.0, 249.0, 100.0, 181.0, 246.0, 66.0, 165.0, 245.0, 33.0, 150.0, 243.0, 30.0, 136.0, 229.0, 25.0, 118.0, 210.0, 21.0, 101.0, 192.0, 13.0, 71.0, 161.0, 225.0, 245.0, 254.0, 179.0, 229.0, 252.0, 129.0, 212.0, 250.0, 79.0, 195.0, 247.0, 41.0, 182.0, 246.0, 3.0, 169.0, 244.0, 3.0, 155.0, 229.0, 2.0, 136.0, 209.0, 2.0, 119.0, 189.0, 1.0, 87.0, 155.0, 224.0, 247.0, 250.0, 178.0, 235.0, 242.0, 128.0, 222.0, 234.0, 77.0, 208.0, 225.0, 38.0, 198.0, 218.0, 0.0, 188.0, 212.0, 0.0, 172.0, 193.0, 0.0, 151.0, 167.0, 0.0, 131.0, 143.0, 0.0, 96.0, 100.0, 224.0, 242.0, 241.0, 178.0, 223.0, 219.0, 128.0, 203.0, 196.0, 77.0, 182.0, 172.0, 38.0, 166.0, 154.0, 0.0, 150.0, 136.0, 0.0, 137.0, 123.0, 0.0, 121.0, 107.0, 0.0, 105.0, 92.0, 0.0, 77.0, 64.0, 232.0, 245.0, 233.0, 200.0, 230.0, 201.0, 165.0, 214.0, 167.0, 129.0, 199.0, 132.0, 102.0, 187.0, 106.0, 76.0, 175.0, 80.0, 67.0, 160.0, 71.0, 56.0, 142.0, 60.0, 46.0, 125.0, 50.0, 27.0, 94.0, 32.0, 241.0, 248.0, 233.0, 220.0, 237.0, 200.0, 197.0, 225.0, 165.0, 174.0, 213.0, 129.0, 156.0, 204.0, 101.0, 139.0, 195.0, 74.0, 124.0, 179.0, 66.0, 104.0, 159.0, 56.0, 85.0, 139.0, 47.0, 51.0, 105.0, 30.0, 249.0, 251.0, 231.0, 240.0, 244.0, 195.0, 230.0, 238.0, 156.0, 220.0, 231.0, 117.0, 212.0, 225.0, 87.0, 205.0, 220.0, 57.0, 192.0, 202.0, 51.0, 175.0, 180.0, 43.0, 158.0, 157.0, 36.0, 130.0, 119.0, 23.0, 255.0, 253.0, 231.0, 255.0, 249.0, 196.0, 255.0, 245.0, 157.0, 255.0, 241.0, 118.0, 255.0, 238.0, 88.0, 255.0, 235.0, 59.0, 253.0, 216.0, 53.0, 251.0, 192.0, 45.0, 249.0, 168.0, 37.0, 245.0, 127.0, 23.0, 255.0, 248.0, 225.0, 255.0, 236.0, 179.0, 255.0, 224.0, 130.0, 255.0, 213.0, 79.0, 255.0, 202.0, 40.0, 255.0, 193.0, 7.0, 255.0, 179.0, 0.0, 255.0, 160.0, 0.0, 255.0, 143.0, 0.0, 255.0, 111.0, 0.0, 255.0, 243.0, 224.0, 255.0, 224.0, 178.0, 255.0, 204.0, 128.0, 255.0, 183.0, 77.0, 255.0, 167.0, 38.0, 255.0, 152.0, 0.0, 251.0, 140.0, 0.0, 245.0, 124.0, 0.0, 239.0, 108.0, 0.0, 230.0, 81.0, 0.0, 251.0, 233.0, 231.0, 255.0, 204.0, 188.0, 255.0, 171.0, 145.0, 255.0, 138.0, 101.0, 255.0, 112.0, 67.0, 255.0, 87.0, 34.0, 244.0, 81.0, 30.0, 230.0, 74.0, 25.0, 216.0, 67.0, 21.0, 191.0, 54.0, 12.0, 239.0, 235.0, 233.0, 215.0, 204.0, 200.0, 188.0, 170.0, 164.0, 161.0, 136.0, 127.0, 141.0, 110.0, 99.0, 121.0, 85.0, 72.0, 109.0, 76.0, 65.0, 93.0, 64.0, 55.0, 78.0, 52.0, 46.0, 62.0, 39.0, 35.0};

    public JFXColorPalette(JFXColorPicker colorPicker) {
        this.getStyleClass().add((Object)"color-palette-region");
        this.colorPicker = colorPicker;
        this.colorPickerGrid = new JFXColorGrid();
        ((Node)this.colorPickerGrid.getChildren().get(0)).requestFocus();
        this.customColorLabel.setAlignment(Pos.CENTER_LEFT);
        this.customColorLink.setPrefWidth(this.colorPickerGrid.prefWidth(-1.0));
        this.customColorLink.setAlignment(Pos.CENTER);
        this.customColorLink.setFocusTraversable(true);
        this.customColorLink.setOnAction(ev -> {
            if (this.customColorDialog == null) {
                this.customColorDialog = new JFXCustomColorPickerDialog((Window)this.popupControl);
                this.customColorDialog.customColorProperty().addListener((ov, t1, t2) -> colorPicker.setValue((Color)this.customColorDialog.customColorProperty().get()));
                this.customColorDialog.setOnSave(() -> {
                    Color customColor = (Color)this.customColorDialog.customColorProperty().get();
                    this.buildCustomColors();
                    colorPicker.getCustomColors().add((Object)customColor);
                    this.updateSelection(customColor);
                    Event.fireEvent((EventTarget)colorPicker, (Event)new ActionEvent());
                    colorPicker.hide();
                });
            }
            this.customColorDialog.setCurrentColor((Color)colorPicker.valueProperty().get());
            if (this.popupControl != null) {
                this.popupControl.setAutoHide(false);
            }
            this.customColorDialog.show();
            this.customColorDialog.setOnHidden((EventHandler<WindowEvent>)((EventHandler)event -> {
                if (this.popupControl != null) {
                    this.popupControl.setAutoHide(true);
                }
            }));
        });
        this.initNavigation();
        this.customColorGrid.getStyleClass().add((Object)"color-picker-grid");
        this.customColorGrid.setVisible(false);
        this.buildCustomColors();
        colorPicker.getCustomColors().addListener(change -> this.buildCustomColors());
        VBox paletteBox = new VBox();
        paletteBox.getStyleClass().add((Object)"color-palette");
        paletteBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        paletteBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.valueOf((String)"#9E9E9E"), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        paletteBox.getChildren().addAll((Object[])new Node[]{this.colorPickerGrid});
        if (colorPicker.getPreDefinedColors() == null) {
            paletteBox.getChildren().addAll((Object[])new Node[]{this.customColorLabel, this.customColorGrid, this.customColorLink});
        }
        this.hoverSquare.setMouseTransparent(true);
        this.hoverSquare.getStyleClass().addAll((Object[])new String[]{"hover-square"});
        this.setFocusedSquare(null);
        this.getChildren().addAll((Object[])new Node[]{paletteBox, this.hoverSquare});
    }

    private void setFocusedSquare(ColorSquare square) {
        double xAdjust;
        double scaleAdjust;
        this.hoverSquare.setVisible(square != null);
        if (square == this.focusedSquare) {
            return;
        }
        this.focusedSquare = square;
        this.hoverSquare.setVisible(this.focusedSquare != null);
        if (this.focusedSquare == null) {
            return;
        }
        if (!this.focusedSquare.isFocused()) {
            this.focusedSquare.requestFocus();
        }
        this.hoverSquare.rectangle.setFill(this.focusedSquare.rectangle.getFill());
        Bounds b = square.localToScene(square.getLayoutBounds());
        double x = b.getMinX();
        double y = b.getMinY();
        double d = scaleAdjust = this.hoverSquare.getScaleX() == 1.0 ? 0.0 : this.hoverSquare.getWidth() / 4.0;
        if (this.colorPicker.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            x = this.focusedSquare.getLayoutX();
            xAdjust = -this.focusedSquare.getWidth() + scaleAdjust;
        } else {
            xAdjust = this.focusedSquare.getWidth() / 2.0 + scaleAdjust;
        }
        this.hoverSquare.setLayoutX(this.snapPosition(x) - xAdjust);
        this.hoverSquare.setLayoutY(this.snapPosition(y) - this.focusedSquare.getHeight() / 2.0 + (this.hoverSquare.getScaleY() == 1.0 ? 0.0 : this.focusedSquare.getHeight() / 4.0));
    }

    private void buildCustomColors() {
        int i;
        ObservableList customColors = this.colorPicker.getCustomColors();
        this.customColorGrid.getChildren().clear();
        if (customColors.isEmpty()) {
            this.customColorLabel.setVisible(false);
            this.customColorLabel.setManaged(false);
            this.customColorGrid.setVisible(false);
            this.customColorGrid.setManaged(false);
            return;
        }
        this.customColorLabel.setVisible(true);
        this.customColorLabel.setManaged(true);
        this.customColorGrid.setVisible(true);
        this.customColorGrid.setManaged(true);
        int customColumnIndex = 0;
        int customRowIndex = 0;
        int remainingSquares = customColors.size() % 10;
        int numEmpty = remainingSquares == 0 ? 0 : 10 - remainingSquares;
        for (i = 0; i < customColors.size(); ++i) {
            Color c = (Color)customColors.get(i);
            ColorSquare square = new ColorSquare(c, i, true);
            this.customColorGrid.add((Node)square, customColumnIndex, customRowIndex);
            if (++customColumnIndex != 10) continue;
            customColumnIndex = 0;
            ++customRowIndex;
        }
        for (i = 0; i < numEmpty; ++i) {
            ColorSquare emptySquare = new ColorSquare();
            this.customColorGrid.add((Node)emptySquare, customColumnIndex, customRowIndex);
            ++customColumnIndex;
        }
        this.requestLayout();
    }

    private void initNavigation() {
        this.setOnKeyPressed(ke -> {
            switch (ke.getCode()) {
                case SPACE: 
                case ENTER: {
                    if (this.focusedSquare != null) {
                        this.focusedSquare.selectColor((KeyEvent)ke);
                    }
                    ke.consume();
                    break;
                }
            }
        });
    }

    public void setPopupControl(PopupControl pc) {
        this.popupControl = pc;
    }

    public JFXColorGrid getColorGrid() {
        return this.colorPickerGrid;
    }

    public boolean isCustomColorDialogShowing() {
        return this.customColorDialog != null && this.customColorDialog.isVisible();
    }

    public void updateSelection(Color color) {
        this.setFocusedSquare(null);
        for (ColorSquare c : this.colorPickerGrid.getSquares()) {
            if (!c.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(c);
            return;
        }
        for (Node n : this.customColorGrid.getChildren()) {
            ColorSquare c = (ColorSquare)n;
            if (!c.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(c);
            return;
        }
    }

    private static int clamp(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    class JFXColorGrid
    extends GridPane {
        private final List<ColorSquare> squares;
        final int NUM_OF_COLORS;
        final int NUM_OF_ROWS;

        public JFXColorGrid() {
            this.getStyleClass().add((Object)"color-picker-grid");
            this.setId("ColorCustomizerColorGrid");
            int columnIndex = 0;
            int rowIndex = 0;
            this.squares = FXCollections.observableArrayList();
            double[] limitedColors = JFXColorPalette.this.colorPicker.getPreDefinedColors();
            limitedColors = limitedColors == null ? RAW_VALUES : limitedColors;
            this.NUM_OF_COLORS = limitedColors.length / 3;
            this.NUM_OF_ROWS = (int)Math.ceil((double)this.NUM_OF_COLORS / 10.0);
            int numColors = limitedColors.length / 3;
            Color[] colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                colors[i] = new Color(limitedColors[i * 3] / 255.0, limitedColors[i * 3 + 1] / 255.0, limitedColors[i * 3 + 2] / 255.0, 1.0);
                ColorSquare cs = new ColorSquare(colors[i], i);
                this.squares.add(cs);
            }
            for (ColorSquare square : this.squares) {
                this.add((Node)square, columnIndex, rowIndex);
                if (++columnIndex != 10) continue;
                columnIndex = 0;
                ++rowIndex;
            }
            this.setOnMouseDragged(t -> {
                if (!JFXColorPalette.this.dragDetected) {
                    JFXColorPalette.this.dragDetected = true;
                    JFXColorPalette.this.mouseDragColor = (Color)JFXColorPalette.this.colorPicker.getValue();
                }
                int xIndex = JFXColorPalette.clamp(0, (int)t.getX() / 16, 9);
                int yIndex = JFXColorPalette.clamp(0, (int)t.getY() / 16, this.NUM_OF_ROWS - 1);
                int index = xIndex + yIndex * 10;
                JFXColorPalette.this.colorPicker.setValue((Color)this.squares.get((int)index).rectangle.getFill());
                JFXColorPalette.this.updateSelection((Color)JFXColorPalette.this.colorPicker.getValue());
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, t -> {
                if (JFXColorPalette.this.colorPickerGrid.getBoundsInLocal().contains(t.getX(), t.getY())) {
                    JFXColorPalette.this.updateSelection((Color)JFXColorPalette.this.colorPicker.getValue());
                    JFXColorPalette.this.colorPicker.fireEvent((Event)new ActionEvent());
                    JFXColorPalette.this.colorPicker.hide();
                } else if (JFXColorPalette.this.mouseDragColor != null) {
                    JFXColorPalette.this.colorPicker.setValue(JFXColorPalette.this.mouseDragColor);
                    JFXColorPalette.this.updateSelection(JFXColorPalette.this.mouseDragColor);
                }
                JFXColorPalette.this.dragDetected = false;
            });
        }

        public List<ColorSquare> getSquares() {
            return this.squares;
        }

        protected double computePrefWidth(double height) {
            return 160.0;
        }

        protected double computePrefHeight(double width) {
            return 16 * this.NUM_OF_ROWS;
        }
    }

    class ColorSquare
    extends StackPane {
        Rectangle rectangle;
        boolean isEmpty;

        public ColorSquare() {
            this(null, -1, false);
        }

        public ColorSquare(Color color, int index) {
            this(color, index, false);
        }

        public ColorSquare(Color color, int index, boolean isCustom) {
            this.getStyleClass().add((Object)"color-square");
            if (color != null) {
                this.setFocusTraversable(true);
                this.focusedProperty().addListener((s, ov, nv) -> JFXColorPalette.this.setFocusedSquare(nv != false ? this : null));
                this.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> JFXColorPalette.this.setFocusedSquare(this));
                this.addEventHandler(MouseEvent.MOUSE_EXITED, event -> JFXColorPalette.this.setFocusedSquare(null));
                this.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
                    if (!JFXColorPalette.this.dragDetected && event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 1) {
                        if (!this.isEmpty) {
                            Color fill = (Color)this.rectangle.getFill();
                            JFXColorPalette.this.colorPicker.setValue(fill);
                            JFXColorPalette.this.colorPicker.fireEvent((Event)new ActionEvent());
                            JFXColorPalette.this.updateSelection(fill);
                            event.consume();
                        }
                        JFXColorPalette.this.colorPicker.hide();
                    }
                });
            }
            this.rectangle = new Rectangle(15.0, 15.0);
            if (color == null) {
                this.rectangle.setFill((Paint)Color.WHITE);
                this.isEmpty = true;
            } else {
                this.rectangle.setFill((Paint)color);
            }
            this.rectangle.setStrokeType(StrokeType.INSIDE);
            String tooltipStr = JFXNodeUtils.colorToHex(color);
            Tooltip.install((Node)this, (Tooltip)new Tooltip(tooltipStr == null ? "" : tooltipStr.toUpperCase()));
            this.rectangle.getStyleClass().add((Object)"color-rect");
            this.getChildren().add((Object)this.rectangle);
        }

        public void selectColor(KeyEvent event) {
            if (this.rectangle.getFill() != null) {
                if (this.rectangle.getFill() instanceof Color) {
                    JFXColorPalette.this.colorPicker.setValue((Color)this.rectangle.getFill());
                    JFXColorPalette.this.colorPicker.fireEvent((Event)new ActionEvent());
                }
                event.consume();
            }
            JFXColorPalette.this.colorPicker.hide();
        }
    }
}

