/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.download;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.ANFControl;
import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.download.IssuedCertDownloadClient;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.ManagerType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class IssuedCertificateDownloader {
    private static final Logger log = Logger.getLogger(IssuedCertificateDownloader.class);
    ANFCryptoToken tk;
    private IssuedCertDownloadClient downloadClient;

    public IssuedCertificateDownloader() {
        this.downloadClient = new IssuedCertDownloadClient();
    }

    public static void main(String[] args) throws Throwable {
        new IssuedCertificateDownloader().recibirToPFX(new File("503949362134-7651266.pfx"), "12341234".toCharArray());
    }

    public IssuedCertificateDownloader(ManagerType type, int token) throws Throwable {
        try {
            switch (type) {
                case SMI: {
                    this.tk = ANFControl.get().getInstance(ManagerType.SMI);
                    this.recibir(token);
                }
                case P11_VAULT: {
                    this.tk = ANFControl.get().getInstance(ManagerType.P11_VAULT);
                    this.recibir(token);
                    break;
                }
                case PLUGSIGN: 
                case P11_ANF: 
                case P11_BIT4ID: {
                    this.tk = ANFControl.get().getInstance(type);
                    this.recibir(token);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void recibir(int token) throws Exception {
        String serial = this.tk.getSerialNumberToken(token);
        Enumeration listAlias = this.tk.getAlias(serial);
        String alias = "61760";
        while (listAlias.hasMoreElements()) {
            alias = (String)listAlias.nextElement();
            this.tk.getCertificateChain(serial, alias);
            X509Certificate[] certs = this.recibir(this.tk, serial, alias);
            if (certs == null) continue;
            IssuedCertificateDownloader.importar(this.tk, serial, alias, certs);
        }
    }

    public int recibirToSTonServer(ANFCryptoToken st, String serial, char[] pin) throws NOPINException, Exception {
        Enumeration listAlias = st.getAlias(serial);
        int c = 0;
        while (listAlias.hasMoreElements()) {
            String alias = (String)listAlias.nextElement();
            X509Certificate[] chain = st.getCertificateChain(serial, alias);
            int cert = CertUtils.getFinalCert((X509Certificate[])chain);
            if (cert == -1) continue;
            log.info((Object)("Descargando certificados asociados al alias " + alias));
            X509Certificate[] certs = this.downloadClient.downloadIssued(new X509Certificate[]{chain[cert]});
            if (certs == null || !IssuedCertificateDownloader.importar(st, serial, alias, certs)) continue;
            ++c;
        }
        return c;
    }

    public int recibirToPFX(File pfx, char[] pass) {
        log.info((Object)("recibiendo a PFX " + pfx.getName()));
        ANFCryptoToken anf = ANFControl.get().getInstancePFX(pfx, pass);
        String serial = anf.getSerialNumberToken(0);
        Enumeration listAlias = anf.getAlias(serial);
        int c = 0;
        while (listAlias.hasMoreElements()) {
            String alias = (String)listAlias.nextElement();
            log.info((Object)("cargando cadena de certificados con alias " + alias));
            X509Certificate[] chain = anf.getCertificateChain(serial, alias);
            if (chain == null) continue;
            log.info((Object)("cadena de certificados en PFX de tamano " + chain.length));
            log.info((Object)("Descargando certificados asociados al alias " + alias));
            X509Certificate[] certs = this.downloadClient.downloadIssued(chain);
            if (certs != null) {
                log.info((Object)("se descargo una cadena de " + certs.length + " certificados, importando en alias " + alias));
                if (!IssuedCertificateDownloader.importar(anf, serial, alias, certs)) continue;
                ++c;
                continue;
            }
            log.info((Object)"no se descargaron certificados ");
        }
        return c;
    }

    public X509Certificate[] recibir(ANFCryptoToken tk, String serial, String alias) {
        try {
            X509Certificate[] cert = tk.getCertificateChain(serial, alias);
            return this.downloadClient.downloadIssued(cert);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    public static byte[] readFile(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            byte[] arr = new byte[(int)file.length()];
            in.read(arr);
            in.close();
            return arr;
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return null;
    }

    public static void writeFile(byte[] arr, File file) {
        try {
            FileOutputStream f = new FileOutputStream(file);
            f.write(arr);
            f.close();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private static boolean recibirImportar(ANFCryptoToken tk, String serial, InputStream pkcs7Response, String alias) {
        try {
            X509Certificate[] chain = CertUtils.getCertificates((InputStream)pkcs7Response);
            return IssuedCertificateDownloader.importar(tk, serial, alias, chain);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return false;
        }
    }

    public static boolean importar(ANFCryptoToken tk, String serial, String alias, X509Certificate[] chain) {
        try {
            X509Certificate[] sortChain = CertUtils.sortChain((X509Certificate[])chain);
            log.info((Object)("importando certificados al almacen de llaves con alias " + alias));
            log.info((Object)"cadena de certificados a importar:");
            for (int i = 0; i < sortChain.length; ++i) {
                log.info((Object)("importando chain[" + i + "]=" + sortChain[i].getSubjectX500Principal()));
            }
            tk.importCertificate(serial, alias, sortChain);
            log.info((Object)"cadena de certificados importada exitosamente");
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public static void setProxy(String proxyHost, String portNumber, String socksProxyHost, String socksPortNumber, final String authUser, final String authPassword) {
        if (socksProxyHost != null) {
            System.setProperty("socksProxyHost", socksProxyHost);
        }
        if (socksPortNumber != null) {
            System.setProperty("socksProxyPort", socksPortNumber);
        }
        if (proxyHost != null) {
            System.getProperties().put("http.proxyHost", proxyHost);
        }
        if (portNumber != null) {
            System.getProperties().put("http.proxyPort", portNumber);
        }
        if (authUser != null) {
            System.setProperty("http.proxyUser", authUser);
        }
        if (authPassword != null) {
            System.setProperty("http.proxyPassword", authPassword);
        }
        System.getProperties().put("http.proxySet", "true");
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(authUser, authPassword.toCharArray());
            }
        });
    }
}

