/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr;

import com.anf.cryptotoken.activation.csr.EncodableBuilder;
import com.anf.cryptotoken.activation.csr.params.QcStatementsParams;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.oid.QcPSD2Info;
import com.anf.cryptotoken.oid.QcStatementsInfo;
import com.anf.cryptotoken.oid.QcStatementsUtils;
import com.anf.ra.xml.ApplicationForm;
import java.util.TreeMap;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Extension;

public class QcStatementsBuilder
implements EncodableBuilder<QcStatementsParams, ASN1Encodable> {
    @Override
    public ASN1Sequence build(QcStatementsParams params) throws NumberFormatException {
        ApplicationForm.Applicant.QcStatements qcStatements = params.getQcStatements();
        if (qcStatements == null) {
            return null;
        }
        qcStatements.setQcSSCD("" + params.isQscd());
        boolean qcCompliance = Boolean.parseBoolean(qcStatements.getQcCompliance());
        ApplicationForm.Applicant.QcStatements.QcLimitValue qcLimitValue = qcStatements.getQcLimitValue();
        QcStatementsInfo qcInfo = new QcStatementsInfo(qcCompliance, qcStatements.getQcRetentionPeriod() > 0 ? String.valueOf(qcStatements.getQcRetentionPeriod()) : null, qcLimitValue != null ? String.valueOf(qcLimitValue.getQcBase()) : null, qcLimitValue != null ? String.valueOf(qcLimitValue.getQcExp()) : null, qcStatements.getQcSSCD(), qcLimitValue != null ? qcLimitValue.getMoney() : null);
        ApplicationForm.Applicant.QcStatements.QcPSD2 qcPSD2 = qcStatements.getQcPSD2();
        if (qcPSD2 != null) {
            TreeMap rolesMap = new TreeMap();
            qcPSD2.getRoles().forEach(role -> {
                String[] split = role.split("_");
                if (split.length == 2 && split[0].equals("PSP")) {
                    rolesMap.put(split[1], role);
                }
            });
            qcInfo.setPsd2Info(new QcPSD2Info(rolesMap, qcPSD2.getNameNCA(), qcPSD2.getIdNCA(), qcPSD2.getAuthNumber(), qcPSD2.getCountryCode()));
        }
        return QcStatementsUtils.getQcStatementsValue((ProfilePolicy)params.getProfile(), (boolean)params.isQscd(), (QcStatementsInfo)qcInfo, (boolean)params.isCentralized());
    }

    @Override
    public ASN1ObjectIdentifier oid() {
        return Extension.qCStatements;
    }
}

