/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr;

import com.anf.cryptotoken.activation.csr.EncodableBuilder;
import com.anf.cryptotoken.activation.csr.params.PoliciesParams;
import com.anf.cryptotoken.activation.exception.CSRBuildException;
import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.oid.QcStatementsUtils;
import com.anf.ra.xml.ApplicationForm;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;

public class PoliciesBuilder
implements EncodableBuilder<PoliciesParams, ASN1Sequence> {
    @Override
    public ASN1Sequence build(PoliciesParams params) {
        try {
            ASN1EncodableVector policiesVector = new ASN1EncodableVector();
            TreeSet<String> oidSet = new TreeSet<String>();
            for (ApplicationForm.Applicant.Policyinfos.PolicyInfo policyInfo : params.getPolicies()) {
                String oid;
                String policyOID = policyInfo.getOid();
                if (params.isQscd() && params.getPolicyOidMapper() != null) {
                    policyOID = (String)params.getPolicyOidMapper().apply(policyOID);
                }
                if (PolicyOID.fromOid((String)policyOID) != null && policyInfo.getUrl() != null) {
                    URL policyURL = new URL(policyInfo.getUrl());
                    ASN1EncodableVector derQualifier = new ASN1EncodableVector();
                    PolicyQualifierInfo qualifierInfoCPS = new PolicyQualifierInfo(policyURL.toString());
                    derQualifier.add((ASN1Encodable)qualifierInfoCPS);
                    if (!ProfilePolicy.isQSeal((ProfilePolicy)PolicyOID.getProfilePolicy((String)policyOID))) {
                        DisplayText displayText = new DisplayText(policyInfo.getUsernotice());
                        UserNotice userNotice = new UserNotice(null, displayText);
                        PolicyQualifierInfo qualifierInfoUN = new PolicyQualifierInfo((ASN1ObjectIdentifier)PolicyQualifierId.id_qt_unotice, (ASN1Encodable)userNotice);
                        derQualifier.add((ASN1Encodable)qualifierInfoUN);
                    }
                    ASN1ObjectIdentifier qualifierInfoOID = new ASN1ObjectIdentifier(policyOID);
                    policiesVector.add((ASN1Encodable)new PolicyInformation(qualifierInfoOID, (ASN1Sequence)new DERSequence(derQualifier)));
                } else {
                    PolicyInformation pi = new PolicyInformation(new ASN1ObjectIdentifier(policyOID));
                    policiesVector.add((ASN1Encodable)pi);
                }
                if (!params.isQcCompliance() || (oid = QcStatementsUtils.getQcpOid((String)policyOID)) == null || !oidSet.add(oid)) continue;
                PolicyInformation pi = new PolicyInformation(new ASN1ObjectIdentifier(oid));
                policiesVector.add((ASN1Encodable)pi);
            }
            return new DERSequence(policiesVector);
        }
        catch (MalformedURLException e) {
            throw new CSRBuildException(e);
        }
    }

    @Override
    public ASN1ObjectIdentifier oid() {
        return Extension.certificatePolicies;
    }
}

