/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.client;

import com.anf.cryptotoken.activation.client.ActivationRequestResult;
import com.anf.cryptotoken.activation.exception.NullCSRError;
import com.anf.cryptotoken.activation.exception.SendCSRError;
import com.anf.cryptotoken.activation.exception.StoreCSRError;
import com.anf.cryptotoken.activation.result.CertRequestInfoImpl;
import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.PKCS10RequestFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;

public class CertRequestActivationClient {
    private static final Logger log = LogManager.getLogger(CertRequestActivationClient.class);
    private boolean connect = true;
    private File csrStore = null;
    private String arSignedFilePath;
    private int retryTimes = 3;
    String certReqURL = "https://gestiones.anf.es/ra/certificaterequest";
    String user = "aa";
    String pass = "bb";

    public CertRequestActivationClient(boolean connect, File arSignedFilePath) {
        this.connect = connect;
        if (connect) {
            try {
                this.arSignedFilePath = arSignedFilePath.getCanonicalPath();
            }
            catch (IOException e) {
                log.catching((Throwable)e);
            }
        }
    }

    public CertRequestActivationClient(File arSignedFilePath) {
        this(arSignedFilePath != null && arSignedFilePath.exists(), arSignedFilePath);
    }

    public CertRequestActivationClient() {
    }

    public CertRequestActivationClient(String certReqURL) {
        this.certReqURL = certReqURL;
    }

    public void setCsrStore(File csrStore) {
        this.csrStore = csrStore;
    }

    public ActivationRequestResult sendCertificateRequest(String localizator, byte[] p10) {
        ActivationRequestResult result = new ActivationRequestResult();
        if (p10 != null) {
            if (this.csrStore != null) {
                try {
                    FileUtils.writeByteArrayToFile((File)this.csrStore, (byte[])p10);
                }
                catch (Exception e) {
                    throw new StoreCSRError(e);
                }
            }
        } else {
            log.error("no se pudo obtener la codificacion en formato PKCS10");
            throw new NullCSRError();
        }
        PKCS10Request csr = PKCS10RequestFactory.createOldPKCS10((byte[])p10);
        boolean ok = csr.verifySignature();
        log.info("csr signature: " + ok);
        if (ok) {
            if (this.connect) {
                this.sendRequest(localizator, csr, result);
            } else {
                result.setSuccess(true);
            }
        }
        return result;
    }

    private void sendRequest(String localizador, PKCS10Request csr, ActivationRequestResult result) {
        try {
            X500Name subject = csr.getSubject();
            boolean ok = false;
            byte[] pkcs10 = csr.getEncoded();
            log.info("enviando PKCS10 a " + this.certReqURL);
            URL url = new URL(this.certReqURL + "?USERNAME=" + this.user + "&PASSWORD=" + this.pass);
            URLConnection httpConn = url.openConnection();
            httpConn.setRequestProperty("localizator", localizador);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            this.prepareZipRequest(localizador, pkcs10, httpConn.getOutputStream());
            httpConn.connect();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)httpConn.getInputStream(), (OutputStream)bOut);
            String response = bOut.toString();
            log.info("respuesta de " + this.certReqURL + ": " + response);
            log.debug(response);
            ok = response.equals("<OK/>");
            if (!ok) {
                log.info("error activando solicitud: " + response);
            }
            result.setCertRequestInfoResult(new CertRequestInfoImpl(url, localizador, response, subject.toString()));
            result.setSuccess(ok);
            log.info("solicitud {} activada OK", (Object)localizador);
        }
        catch (Exception e) {
            throw new SendCSRError(e);
        }
    }

    private void prepareZipRequest(String localizador, byte[] pkcs10, OutputStream out) throws IOException, FileNotFoundException {
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            ZipEntry zipEntry = new ZipEntry("Request" + localizador + ".req");
            zipOut.putNextEntry(zipEntry);
            zipOut.write(pkcs10);
            zipEntry = new ZipEntry("XMLSolicitante1" + localizador + ".xml");
            zipOut.putNextEntry(zipEntry);
            try (FileInputStream fInput = new FileInputStream(this.arSignedFilePath);){
                IOUtils.copy((InputStream)fInput, (OutputStream)zipOut);
            }
            zipOut.finish();
        }
    }

    public void setConnect(boolean connect) {
        this.connect = connect;
    }

    public boolean isConnect() {
        return this.connect;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setCertReqURL(String certReqURL) {
        this.certReqURL = certReqURL;
    }

    public String getCertReqURL() {
        return this.certReqURL;
    }
}

