/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation;

import com.anf.cryptotoken.ANFControl;
import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.activation.ActivationResult;
import com.anf.cryptotoken.activation.client.ActivationRequestResult;
import com.anf.cryptotoken.activation.csr.CSRElementsBuilder;
import com.anf.cryptotoken.activation.csr.params.CSRBuildParams;
import com.anf.cryptotoken.activation.csr.params.CSRParamsBuilder;
import com.anf.cryptotoken.activation.exception.NonQSCDTokenError;
import com.anf.cryptotoken.activation.exception.SigDecodingError;
import com.anf.cryptotoken.activation.exception.TokenCountLimitError;
import com.anf.cryptotoken.activation.exception.TokenProfileError;
import com.anf.cryptotoken.activation.params.ActivationParams;
import com.anf.cryptotoken.activation.params.ActivationParamsFactory;
import com.anf.cryptotoken.activation.params.CommonActivationParams;
import com.anf.cryptotoken.activation.result.ActivationResultImpl;
import com.anf.cryptotoken.activation.sig.SigFileDecoder;
import com.anf.cryptotoken.activation.sig.SigFileDecodingResult;
import com.anf.cryptotoken.activation.xml.XmlParser;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.TKManager;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.ui.keyboard.handler.auth.PINConfig;
import java.io.File;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActivationService {
    private static final Logger log = LogManager.getLogger(ActivationService.class);
    private CSRElementsBuilder csrElementsBuilder = new CSRElementsBuilder();
    private SigFileDecoder sigFileDecoder = new SigFileDecoder();
    private CSRParamsBuilder csrParamsBuilder = new CSRParamsBuilder();
    private XmlParser xmlParser = new XmlParser();

    public ActivationResult activateOnToken(CommonActivationParams params, ANFCryptoToken token, String serial) {
        ActivationParams activationParams = ActivationParamsFactory.activationParams(params, token, serial);
        return this.activate(activationParams);
    }

    public SigFileDecodingResult decodeSigFile(File sigFile, String sigPassword) {
        SigFileDecodingResult decodeSigFileResult = this.sigFileDecoder.decodeSigFile(sigFile, sigPassword, false);
        if (!decodeSigFileResult.isDecoded()) {
            throw new SigDecodingError();
        }
        String xml = decodeSigFileResult.getXml();
        decodeSigFileResult.setXmlInfo(this.xmlParser.parseXml(xml));
        return decodeSigFileResult;
    }

    public ActivationResult activateOnPfx(CommonActivationParams params, File pfx, char[] pass) {
        ANFCryptoToken anf = ANFControl.get().getInstancePFX(pfx, pass);
        return this.activateOnToken(params, anf, anf.getSerialNumberToken(0));
    }

    public ActivationResult activateFromXmlNoSend(ActivationParams params, String xml) {
        params.commonParams().setConnect(false);
        return this.activateFromXml(params, xml, null);
    }

    public ActivationResult activateFromXml(ActivationParams params, String xml, File signedXml) {
        ActivationResultImpl result = new ActivationResultImpl();
        CSRBuildParams csrParams = this.csrParamsBuilder.buildCsrParams(params, xml, signedXml);
        this.activate(params, csrParams, result);
        return result;
    }

    public ActivationResult activate(ActivationParams params) {
        ActivationResultImpl result = new ActivationResultImpl(params);
        CSRBuildParams csrParams = this.csrParamsBuilder.buildCsrParams(params, result);
        this.activate(params, csrParams, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate(ActivationParams params, CSRBuildParams csrParams, ActivationResult result) {
        int keyBoardSession = KeyBoardHandler.newKeyBoardSession();
        PINConfig pinConfig = KeyBoardHandler.getPinConfig();
        TKManager token = params.token();
        try {
            ProfilePolicy profile = csrParams.getPoliciesParams().getProfile();
            if (!token.accept(profile)) {
                throw new TokenProfileError(profile.name());
            }
            if (csrParams.getPoliciesParams().isQscd() && !token.isHSM() && !params.isForcedQSCD()) {
                throw new NonQSCDTokenError();
            }
            if (!token.canGenerateCertificateCount(1)) {
                throw new TokenCountLimitError();
            }
            if (params.isOnePassword()) {
                KeyBoardHandler.setPINConfig((PINConfig)PINConfig.DONT_ERASE);
                String commonId = UUID.randomUUID().toString();
                token.setCommonKeyBoardId(commonId);
                log.info("id de teclado en activacion: {}", (Object)commonId);
            }
            ActivationRequestResult sendResult = this.activateProfile(params.getAlias(), csrParams);
            result.setCertReqInfo(sendResult.getCertRequestInfoResult());
            result.setResult(true);
        }
        finally {
            if (params.isOnePassword()) {
                KeyBoardHandler.setPINConfig((PINConfig)pinConfig);
                token.setCommonKeyBoardId(null);
                token.setCommonKeyBoardId(null);
                KeyBoardHandler.removeAllInSession((int)keyBoardSession);
            }
        }
    }

    public ActivationRequestResult activateProfile(String alias, CSRBuildParams csrBuildParams) {
        return this.csrElementsBuilder.build(alias, csrBuildParams);
    }
}

